/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.NodeListImpl;
import org.exist.fluent.DataUtils;
import org.exist.fluent.ElementBuilder;
import org.exist.fluent.NamespaceMap;
import org.exist.fluent.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeBuilder {
    private static final Logger LOG = LogManager.getLogger(AttributeBuilder.class);
    private final CompletedCallback callback;
    private final NamespaceMap namespaceBindings;
    private final Element element;
    private boolean done;
    private final Document doc;
    private final NodeListImpl removedAttributes = new NodeListImpl();
    private final NodeListImpl addedAttributes = new NodeListImpl();
    private final Map<QName, Attr> removedMap = new HashMap<QName, Attr>();
    private final Map<QName, Attr> addedMap = new HashMap<QName, Attr>();

    AttributeBuilder(Element element, NamespaceMap namespaceBindings, CompletedCallback callback) {
        this.element = element;
        this.callback = callback;
        this.namespaceBindings = namespaceBindings.extend();
        this.doc = ElementBuilder.createDocumentNode();
    }

    private void checkDone() {
        if (this.done) {
            throw new IllegalStateException("builder already done");
        }
    }

    public AttributeBuilder namespace(String key, String uri) {
        this.namespaceBindings.put(key, uri);
        return this;
    }

    public AttributeBuilder attr(String name, Object value) {
        this.checkDone();
        QName qname = QName.parse(name, this.namespaceBindings, null);
        Attr attr = this.addedMap.get(qname);
        if (attr != null) {
            this.addedAttributes.remove((Object)attr);
        }
        if ((attr = qname.getAttributeNode(this.element)) != null) {
            if (!this.removedMap.containsKey(qname)) {
                this.removedAttributes.add((Node)attr);
                this.removedMap.put(qname, attr);
            }
        } else assert (!this.removedMap.containsKey(qname));
        attr = qname.createAttribute(this.doc);
        attr.setValue(DataUtils.toXMLString(value));
        this.addedAttributes.add((Node)attr);
        this.addedMap.put(qname, attr);
        return this;
    }

    public AttributeBuilder attrIf(boolean condition, String name, Object value) {
        this.checkDone();
        if (condition) {
            this.attr(name, value);
        }
        return this;
    }

    public AttributeBuilder delAttr(String name) {
        this.checkDone();
        QName qname = QName.parse(name, this.namespaceBindings, null);
        Attr attr = this.addedMap.get(qname);
        if (attr != null) {
            this.addedAttributes.remove((Object)attr);
            this.addedMap.remove(qname);
        }
        if ((attr = qname.getAttributeNode(this.element)) != null && !this.removedMap.containsKey(qname)) {
            this.removedAttributes.add((Node)attr);
            this.removedMap.put(qname, attr);
        }
        return this;
    }

    public void commit() {
        this.checkDone();
        this.done = true;
        if (this.removedAttributes.isEmpty() && this.addedAttributes.isEmpty()) {
            return;
        }
        this.callback.completed((NodeList)this.removedAttributes, (NodeList)this.addedAttributes);
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.done) {
                LOG.warn("disposed without commit");
            }
        }
        finally {
            super.finalize();
        }
    }

    static interface CompletedCallback {
        public void completed(NodeList var1, NodeList var2);
    }
}

