/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.ConsistencyCheck;
import org.exist.backup.ErrorReport;
import org.exist.collections.CollectionConfigurationException;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.TextImpl;
import org.exist.fluent.DatabaseException;
import org.exist.fluent.Document;
import org.exist.fluent.Folder;
import org.exist.fluent.ItemList;
import org.exist.fluent.Listener;
import org.exist.fluent.ListenerManager;
import org.exist.fluent.Name;
import org.exist.fluent.NamespaceMap;
import org.exist.fluent.Node;
import org.exist.fluent.QueryService;
import org.exist.fluent.Resource;
import org.exist.fluent.Source;
import org.exist.fluent.StaleMarker;
import org.exist.fluent.Transaction;
import org.exist.fluent.WeakMultiValueHashMap;
import org.exist.fluent.XMLDocument;
import org.exist.security.AuthenticationException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.ContentLoadingObserver;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.NodePath;
import org.exist.storage.RangeIndexSpec;
import org.exist.storage.lock.Lock;
import org.exist.storage.sync.Sync;
import org.exist.storage.txn.TransactionManager;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.FileUtils;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.ValueSequence;

public class Database {
    private static final Logger LOG = LogManager.getLogger(Database.class);
    private static final ConsistencyCheck.ProgressCallback NULL_PROGRESS_CALLBACK = new ConsistencyCheck.ProgressCallback(){

        public void error(ErrorReport error) {
        }

        public void startCollection(String path) {
        }

        public void startDocument(String name, int current, int count) {
        }
    };
    private static String dbName = "exist";
    public static final String ROOT_PREFIX = "/db";
    private static volatile BrokerPool pool;
    private static TransactionManager txManager;
    private static final ThreadLocal<Transaction> localTransaction;
    private static final WeakHashMap<NativeBroker, Boolean> instrumentedBrokers;
    private final Subject user;
    private final NamespaceMap namespaceBindings;
    String defaultCharacterEncoding = "UTF-8";
    private static final WeakMultiValueHashMap<String, StaleMarker> staleMap;
    private static final ContentLoadingObserver contentObserver;
    private static final Defragmenter defragmenter;
    static final Iterator EMPTY_ITERATOR;
    static final Iterable EMPTY_ITERABLE;

    public static void startup(Path configFile) {
        try {
            if (Database.isStarted()) {
                throw new IllegalStateException("database already started");
            }
            configFile = configFile.toAbsolutePath();
            Configuration config = new Configuration(FileUtils.fileName((Path)configFile), Optional.of(configFile.getParent().toAbsolutePath()));
            BrokerPool.configure((String)dbName, (int)1, (int)5, (Configuration)config);
            pool = BrokerPool.getInstance((String)dbName);
            txManager = pool.getTransactionManager();
            Database.configureRootCollection(configFile);
            defragmenter.start();
            QueryService.statistics().reset();
        }
        catch (DatabaseConfigurationException e) {
            throw new DatabaseException(e);
        }
        catch (EXistException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void configureRootCollection(Path configFile) {
        Database db = new Database(pool.getSecurityManager().getSystemSubject());
        StringBuilder configXml = new StringBuilder();
        configXml.append("<collection xmlns='http://exist-db.org/collection-config/1.0'>");
        configXml.append(ListenerManager.getTriggerConfigXml());
        XMLDocument configDoc = db.getFolder("/").documents().load(Name.generate(db), Source.xml(configFile.toFile()));
        Node indexNode = configDoc.query().optional("/exist/indexer/index", new Object[0]).node();
        if (indexNode.extant()) {
            configXml.append(indexNode.toString());
        }
        configDoc.delete();
        configXml.append("</collection>");
        try {
            Node currentConfig = db.getFolder("/db/system/config/db").documents().get("collection.xconf").xml().root();
            if (currentConfig.query().presub().single("deep-equal(., $1)", configXml.toString()).booleanValue()) {
                return;
            }
        }
        catch (DatabaseException currentConfig) {
            // empty catch block
        }
        Transaction tx = db.requireTransactionWithBroker();
        try {
            pool.getConfigurationManager().addConfiguration(tx.tx, tx.broker, tx.broker.getCollection(XmldbURI.ROOT_COLLECTION_URI), configXml.toString());
            tx.commit();
            DBBroker broker = db.acquireBroker();
            try {
                broker.reindexCollection(XmldbURI.ROOT_COLLECTION_URI);
            }
            finally {
                db.releaseBroker(broker);
            }
        }
        catch (IOException | CollectionConfigurationException | PermissionDeniedException e) {
            throw new DatabaseException(e);
        }
        finally {
            tx.abortIfIncomplete();
        }
    }

    public static void shutdown() {
        if (pool == null) {
            return;
        }
        defragmenter.stop();
        pool.shutdown();
        pool = null;
    }

    @Deprecated
    public static void ensureStarted(Path configFile) {
        if (Database.isStarted()) {
            Optional currentPath = pool.getConfiguration().getConfigFilePath();
            if (!currentPath.map(cp -> cp.toAbsolutePath().equals(configFile.toAbsolutePath())).orElse(false).booleanValue()) {
                throw new IllegalStateException("database already started with different configuration " + currentPath);
            }
        } else {
            Database.startup(configFile);
        }
    }

    public static boolean isStarted() {
        return BrokerPool.isConfigured((String)dbName);
    }

    public static void flush() {
        if (!BrokerPool.isConfigured((String)dbName)) {
            throw new IllegalStateException("database not started");
        }
        try (DBBroker broker = pool.get(Optional.of(pool.getSecurityManager().getSystemSubject()));){
            broker.flush();
            broker.sync(Sync.MAJOR);
        }
        catch (EXistException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkConsistency() {
        BrokerPool brokerPool = pool;
        synchronized (brokerPool) {
            try {
                DBBroker broker = pool.enterServiceMode(pool.getSecurityManager().getSystemSubject());
                try {
                    List errors = new ConsistencyCheck(broker, false, false).checkAll(NULL_PROGRESS_CALLBACK);
                    if (errors.isEmpty()) {
                        boolean bl = true;
                        return bl;
                    }
                    LOG.fatal("database corrupted");
                    for (ErrorReport error : errors) {
                        LOG.error(error.toString().replace("\n", " "));
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    pool.exitServiceMode(pool.getSecurityManager().getSystemSubject());
                }
            }
            catch (TerminatedException e) {
                throw new DatabaseException(e);
            }
            catch (PermissionDeniedException e) {
                throw new DatabaseException(e);
            }
        }
    }

    public static Database login(String username, String password) {
        Subject user;
        try {
            user = pool.getSecurityManager().authenticate(username, (Object)password);
        }
        catch (AuthenticationException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return new Database(user);
    }

    public static Database current() throws DatabaseException {
        DBBroker broker;
        if (pool == null) {
            try {
                pool = BrokerPool.getInstance((String)dbName);
                txManager = pool.getTransactionManager();
            }
            catch (EXistException e) {
                throw new DatabaseException(e);
            }
        }
        try {
            broker = pool.getActiveBroker();
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
        return new Database(broker.getCurrentSubject());
    }

    public static void remove(Listener listener) {
        ListenerManager.INSTANCE.remove(listener);
    }

    static String normalizePath(String path) {
        if (path.startsWith(ROOT_PREFIX)) {
            path = path.equals(ROOT_PREFIX) ? "/" : path.substring(ROOT_PREFIX.length());
        }
        return path;
    }

    Database(Subject user) {
        this.user = user;
        this.namespaceBindings = new NamespaceMap(new String[0]);
    }

    Database(Database parent, NamespaceMap namespaceBindings) {
        this.user = parent.user;
        this.namespaceBindings = namespaceBindings.extend();
    }

    @Deprecated
    public void setDefaultExportEncoding(String encoding) {
        this.setDefaultCharacterEncoding(encoding);
    }

    public void setDefaultCharacterEncoding(String encoding) {
        this.defaultCharacterEncoding = encoding;
    }

    DBBroker acquireBroker() {
        try {
            NativeBroker broker = (NativeBroker)pool.get(Optional.ofNullable(this.user));
            if (instrumentedBrokers.get(broker) == null) {
                broker.addContentLoadingObserver(contentObserver);
                instrumentedBrokers.put(broker, Boolean.TRUE);
            }
            return broker;
        }
        catch (EXistException e) {
            throw new DatabaseException(e);
        }
    }

    void releaseBroker(DBBroker broker) {
        broker.close();
    }

    public NamespaceMap namespaceBindings() {
        return this.namespaceBindings;
    }

    private Sequence adoptInternal(Object o) {
        DBBroker broker = this.acquireBroker();
        try {
            XQueryContext context = new XQueryContext((org.exist.Database)broker.getBrokerPool());
            context.declareNamespaces(this.namespaceBindings.getCombinedMap());
            context.setBackwardsCompatibility(false);
            context.setStaticallyKnownDocuments(DocumentSet.EMPTY_DOCUMENT_SET);
            Sequence sequence = XPathUtil.javaObjectToXPath((Object)o, (XQueryContext)context, (boolean)true);
            return sequence;
        }
        catch (XPathException e) {
            throw new DatabaseException(e);
        }
        finally {
            this.releaseBroker(broker);
        }
    }

    public ItemList adopt(org.w3c.dom.Node node) {
        return new ItemList(this.adoptInternal(node), this.namespaceBindings.extend(), this);
    }

    public boolean contains(String path) {
        if (path.length() == 0) {
            throw new IllegalArgumentException("empty path: " + path);
        }
        if (path.equals("/")) {
            return true;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("path not absolute: " + path);
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("path ends with '/': " + path);
        }
        int i = path.lastIndexOf(47);
        assert (i != -1);
        DBBroker broker = this.acquireBroker();
        try {
            if (broker.getCollection(XmldbURI.create((String)path)) != null) {
                boolean bl = true;
                return bl;
            }
            String folderPath = path.substring(0, i);
            String name = path.substring(i + 1);
            org.exist.collections.Collection collection = broker.openCollection(XmldbURI.create((String)folderPath), Lock.LockMode.NO_LOCK);
            if (collection == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = collection.getDocument(broker, XmldbURI.create((String)name)) != null;
            return bl;
        }
        catch (PermissionDeniedException pde) {
            throw new DatabaseException(pde.getMessage(), pde);
        }
        finally {
            this.releaseBroker(broker);
        }
    }

    public Document getDocument(String path) {
        if (path.length() == 0) {
            throw new IllegalArgumentException("empty document path: " + path);
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("document path not absolute: " + path);
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("document path ends with '/': " + path);
        }
        int i = path.lastIndexOf(47);
        assert (i != -1);
        return this.getFolder(i == 0 ? "/" : path.substring(0, i)).documents().get(path.substring(i + 1));
    }

    public Folder getFolder(String path) {
        return new Folder(path, false, this.namespaceBindings.extend(), this);
    }

    public Folder createFolder(String path) {
        return new Folder(path, true, this.namespaceBindings.extend(), this);
    }

    public QueryService query(Resource ... context) {
        return this.query(Arrays.asList(context));
    }

    public QueryService query(final Collection<? extends Resource> context) {
        return new QueryService(this.getFolder("/")){

            @Override
            void prepareContext(DBBroker broker) {
                DefaultDocumentSet mdocs = new DefaultDocumentSet();
                this.base = new ValueSequence();
                for (Resource res : context) {
                    QueryService qs = res.query();
                    if (qs.docs != null) {
                        mdocs.addAll(qs.docs);
                    }
                    if (qs.base == null) continue;
                    try {
                        this.base.addAll(qs.base);
                    }
                    catch (XPathException e) {
                        throw new DatabaseException("unexpected item type conflict", e);
                    }
                }
                this.docs = mdocs;
            }
        };
    }

    static Transaction requireTransaction() {
        Transaction t = localTransaction.get();
        return t == null ? new Transaction(txManager, null) : new Transaction(t, null);
    }

    Transaction requireTransactionWithBroker() {
        Transaction t = localTransaction.get();
        return t == null ? new Transaction(txManager, this) : new Transaction(t, this);
    }

    void checkSame(Resource o) {
        if (o.database() != null && o.database().user != this.user) {
            throw new IllegalArgumentException("cannot combine objects from two database instances in one operation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stale(String key) {
        int updated = 0;
        WeakMultiValueHashMap<String, StaleMarker> weakMultiValueHashMap = staleMap;
        synchronized (weakMultiValueHashMap) {
            for (StaleMarker value : staleMap.get(key)) {
                value.mark();
                ++updated;
            }
            staleMap.remove(key);
        }
    }

    static void trackStale(String key, StaleMarker value) {
        staleMap.put(Database.normalizePath(key), value);
    }

    static void queueDefrag(DocumentImpl doc) {
        defragmenter.queue(doc);
    }

    static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    static {
        localTransaction = new ThreadLocal();
        instrumentedBrokers = new WeakHashMap();
        staleMap = new WeakMultiValueHashMap();
        contentObserver = new ContentLoadingObserver(){

            public void dropIndex(org.exist.collections.Collection collection) {
                Database.stale(Database.normalizePath(collection.getURI().getCollectionPath()));
            }

            public void dropIndex(DocumentImpl doc) {
                Database.stale(Database.normalizePath(doc.getURI().getCollectionPath()));
            }

            public void removeNode(NodeHandle node, NodePath currentPath, String content) {
                Database.stale(Database.normalizePath(((DocumentImpl)node.getOwnerDocument()).getURI().getCollectionPath()) + "#" + node.getNodeId());
            }

            public void flush() {
            }

            public void setDocument(DocumentImpl document) {
            }

            public void storeAttribute(AttrImpl node, NodePath currentPath, RangeIndexSpec spec, boolean remove) {
            }

            public void storeText(TextImpl node, NodePath currentPath) {
            }

            public void sync() {
            }

            public void printStatistics() {
            }

            public void close() {
            }

            public void remove() {
            }

            public void closeAndRemove() {
            }
        };
        defragmenter = new Defragmenter();
        EMPTY_ITERATOR = new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        EMPTY_ITERABLE = new Iterable(){

            public Iterator iterator() {
                return EMPTY_ITERATOR;
            }
        };
    }

    private static class Defragmenter
    implements Runnable {
        private static final Logger LOG = LogManager.getLogger((String)"org.exist.fluent.Database.defragmenter");
        private static final long DEFRAG_INTERVAL = 10000L;
        private Set<DocumentImpl> docsToDefrag = new TreeSet<DocumentImpl>();
        private Thread thread;

        private Defragmenter() {
        }

        public void start() {
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread((Runnable)this, "Database defragmenter");
            this.thread.setPriority(2);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public void stop() {
            if (this.thread == null) {
                return;
            }
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }

        public synchronized void queue(DocumentImpl doc) {
            this.docsToDefrag.add(doc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Set<DocumentImpl> docsToDefragCopy;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                Defragmenter defragmenter = this;
                synchronized (defragmenter) {
                    LOG.debug(new MessageFormat("checking for documents to defragment, {0,choice,0#no candidates|1#1 candidate|1<{0,number,integer} candidates}").format(new Object[]{this.docsToDefrag.size()}));
                    docsToDefragCopy = this.docsToDefrag;
                    this.docsToDefrag = new TreeSet<DocumentImpl>();
                }
                int count = 0;
                try (DBBroker broker = pool.get(Optional.of(pool.getSecurityManager().getSystemSubject()));){
                    Integer fragmentationLimitObject = broker.getBrokerPool().getConfiguration().getInteger("xupdate.fragmentation");
                    int fragmentationLimit = fragmentationLimitObject == null ? 0 : fragmentationLimitObject;
                    Iterator<DocumentImpl> it = docsToDefragCopy.iterator();
                    while (it.hasNext()) {
                        DocumentImpl doc = it.next();
                        if (doc.getMetadata().getSplitCount() <= fragmentationLimit) {
                            it.remove();
                            continue;
                        }
                        if (!doc.getUpdateLock().attempt(Lock.LockMode.WRITE_LOCK)) continue;
                        try {
                            String docPath = Database.normalizePath(doc.getURI().getCollectionPath());
                            if (staleMap.containsKey(docPath)) continue;
                            LOG.debug("defragmenting " + docPath);
                            ++count;
                            Transaction tx = Database.requireTransaction();
                            try {
                                broker.defragXMLResource(tx.tx, doc);
                                tx.commit();
                                it.remove();
                            }
                            finally {
                                tx.abortIfIncomplete();
                            }
                        }
                        finally {
                            doc.getUpdateLock().release(Lock.LockMode.WRITE_LOCK);
                        }
                    }
                }
                catch (EXistException e) {
                    LOG.error("unable to get broker with system privileges to defragment documents", (Throwable)e);
                }
                LOG.debug(new MessageFormat("defragmented {0,choice,0#0 documents|1#1 document|1<{0,number,integer} documents}, next cycle in {1,number,integer}s").format(new Object[]{count, 10L}));
            }
        }
    }
}

