/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentMetadata;
import org.exist.fluent.Database;
import org.exist.fluent.DatabaseException;
import org.exist.fluent.Folder;
import org.exist.fluent.Listener;
import org.exist.fluent.ListenerManager;
import org.exist.fluent.Name;
import org.exist.fluent.NamedResource;
import org.exist.fluent.NamespaceMap;
import org.exist.fluent.QueryService;
import org.exist.fluent.Resource;
import org.exist.fluent.StaleMarker;
import org.exist.fluent.Trigger;
import org.exist.fluent.XMLDocument;
import org.exist.security.Permission;
import org.exist.storage.DBBroker;
import org.exist.xquery.value.Sequence;

public class Document
extends NamedResource {
    protected DocumentImpl doc;
    protected StaleMarker staleMarker;
    private ListenersFacet listeners;
    private MetadataFacet metadata;

    Document(DocumentImpl dimpl, NamespaceMap namespaceBindings, Database db) {
        super(namespaceBindings, db);
        this.changeDoc(dimpl);
    }

    private void changeDoc(DocumentImpl dimpl) {
        if (dimpl == null) {
            throw new NullPointerException("no such document");
        }
        assert (this.getClass() == (dimpl instanceof BinaryDocument ? Document.class : XMLDocument.class));
        this.doc = dimpl;
        String path = dimpl.getURI().getCollectionPath();
        this.staleMarker = new StaleMarker();
        this.staleMarker.track(path.substring(0, path.lastIndexOf(47)));
        this.staleMarker.track(path);
    }

    static Document newInstance(DocumentImpl dimpl, Resource origin) {
        return Document.newInstance(dimpl, origin.namespaceBindings().extend(), origin.database());
    }

    static Document newInstance(DocumentImpl dimpl, NamespaceMap namespaceBindings, Database db) {
        return dimpl instanceof BinaryDocument ? new Document(dimpl, namespaceBindings, db) : new XMLDocument(dimpl, namespaceBindings, db);
    }

    @Override
    Sequence convertToSequence() {
        throw new UnsupportedOperationException("binary resources are not convertible");
    }

    public ListenersFacet listeners() {
        if (this.listeners == null) {
            this.listeners = new ListenersFacet();
        }
        return this.listeners;
    }

    @Override
    public MetadataFacet metadata() {
        if (this.metadata == null) {
            this.metadata = new MetadataFacet(this.doc.getPermissions(), this.doc.getMetadata(), this.db);
        }
        return this.metadata;
    }

    public XMLDocument xml() {
        throw new DatabaseException("document is not XML");
    }

    public boolean equals(Object o) {
        if (o instanceof Document) {
            return this.doc.getDocId() == ((Document)o).doc.getDocId();
        }
        return false;
    }

    public int hashCode() {
        return this.doc.getDocId();
    }

    public String toString() {
        return "document '" + this.path() + "'";
    }

    @Override
    public String name() {
        return this.doc.getFileURI().getCollectionPath();
    }

    @Override
    public String path() {
        return Database.normalizePath(this.doc.getURI().getCollectionPath());
    }

    public Folder folder() {
        this.staleMarker.check();
        String path = this.path();
        int i = path.lastIndexOf(47);
        assert (i != -1);
        return new Folder(i == 0 ? "/" : path.substring(0, i), false, this);
    }

    public long length() {
        return this.doc.getContentLength();
    }

    @Override
    public void delete() {
        this.staleMarker.check();
        this.folder().removeDocument(this.doc);
    }

    @Override
    public Document copy(Folder destination, Name name) {
        return Document.newInstance(this.moveOrCopy(destination, name, true), this);
    }

    @Override
    public void move(Folder destination, Name name) {
        this.changeDoc(this.moveOrCopy(destination, name, false));
    }

    private DocumentImpl moveOrCopy(Folder destination, Name name, boolean copy) {
        this.db.checkSame(destination);
        this.staleMarker.check();
        name.setOldName(this.name());
        return destination.moveOrCopyDocument(this.doc, name, copy);
    }

    public String contentsAsString() {
        DBBroker broker = this.db.acquireBroker();
        try {
            InputStream is = broker.getBinaryResource((BinaryDocument)this.doc);
            byte[] data = new byte[(int)broker.getBinaryResourceSize((BinaryDocument)this.doc)];
            is.read(data);
            is.close();
            String string = new String(data, this.db.defaultCharacterEncoding);
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new DatabaseException(e);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
        finally {
            this.db.releaseBroker(broker);
        }
    }

    public void export(File destination) throws IOException {
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(destination));){
            this.write(stream);
        }
    }

    public void write(OutputStream stream) throws IOException {
        DBBroker broker = this.db.acquireBroker();
        try {
            broker.readBinaryResource((BinaryDocument)this.doc, stream);
        }
        finally {
            this.db.releaseBroker(broker);
        }
    }

    @Override
    QueryService createQueryService() {
        return QueryService.NULL;
    }

    public static class MetadataFacet
    extends NamedResource.MetadataFacet {
        private final DocumentMetadata docMetadata;

        private MetadataFacet(Permission permissions, DocumentMetadata docMetadata, Database db) {
            super(permissions, db);
            this.docMetadata = docMetadata;
        }

        @Override
        public Date creationDate() {
            return new Date(this.docMetadata.getCreated());
        }

        public Date lastModificationDate() {
            return new Date(this.docMetadata.getLastModified());
        }

        public String mimeType() {
            return this.docMetadata.getMimeType();
        }

        public void setMimeType(String mimeType) {
            this.docMetadata.setMimeType(mimeType);
        }
    }

    public class ListenersFacet {
        public void add(Trigger trigger, Listener listener) {
            this.add(EnumSet.of(trigger), listener);
        }

        public void add(Set<Trigger> triggers, Listener listener) {
            Document.this.staleMarker.check();
            ListenerManager.INSTANCE.add(Document.this.path(), ListenerManager.Depth.ZERO, triggers, listener, Document.this);
        }

        public void remove(Listener listener) {
            ListenerManager.INSTANCE.remove(Document.this.path(), ListenerManager.Depth.ZERO, (org.exist.fluent.Listener)listener);
        }
    }

    public static class Event
    extends Listener.Event {
        public final Document document;

        Event(Trigger trigger, String path, Document document) {
            super(trigger, path);
            this.document = document;
        }

        Event(ListenerManager.EventKey key, Document document) {
            super(key);
            this.document = document;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o) && (this.document == null ? ((Event)o).document == null : this.document.equals(((Event)o).document));
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 37 + (this.document == null ? 0 : this.document.hashCode());
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            buf.insert(3, "Document.");
            buf.insert(buf.length() - 1, ", " + this.document);
            return buf.toString();
        }
    }

    public static interface Listener
    extends org.exist.fluent.Listener {
        public void handle(Event var1);
    }
}

