/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.memtree.NodeImpl;
import org.exist.fluent.DataUtils;
import org.exist.fluent.ItemList;
import org.exist.fluent.NamespaceMap;
import org.exist.fluent.Node;
import org.exist.fluent.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementBuilder<K> {
    private static final Logger LOG = LogManager.getLogger(ElementBuilder.class);
    private CompletedCallback<K> callback;
    private final boolean allowFragment;
    private final List<Element> stack = new LinkedList<Element>();
    private final List<org.w3c.dom.Node> top = new LinkedList<org.w3c.dom.Node>();
    private boolean done;
    private final Document doc;
    private NamespaceMap namespaceBindings;

    static Document createDocumentNode() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            return dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("unable to create new memory DOM", e);
        }
    }

    public static ElementBuilder<org.w3c.dom.Node> createScratch(NamespaceMap namespaceBindings) {
        ElementBuilder<org.w3c.dom.Node> builder;
        ElementBuilder<org.w3c.dom.Node> elementBuilder = builder = new ElementBuilder<org.w3c.dom.Node>(namespaceBindings, true, null);
        elementBuilder.getClass();
        super.setCallback(elementBuilder.new ScratchCallback());
        return builder;
    }

    ElementBuilder(NamespaceMap namespaceBindings, boolean allowFragment, CompletedCallback<K> callback) {
        this.callback = callback;
        this.allowFragment = allowFragment;
        this.namespaceBindings = namespaceBindings == null ? new NamespaceMap(new String[0]) : namespaceBindings.extend();
        this.doc = ElementBuilder.createDocumentNode();
    }

    private void setCallback(CompletedCallback<K> callback) {
        this.callback = callback;
    }

    private org.w3c.dom.Node current() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("no current node");
        }
        return this.stack.get(0);
    }

    private void checkDone() {
        if (this.done) {
            throw new IllegalStateException("builder already done");
        }
    }

    public ElementBuilder<K> namespace(String key, String uri) {
        this.namespaceBindings.put(key, uri);
        return this;
    }

    public ElementBuilder<K> node(Node node) {
        return this.node(node.getDOMNode());
    }

    public ElementBuilder<K> nodes(ItemList.NodesFacet nodes) {
        for (Node node : nodes) {
            this.node(node);
        }
        return this;
    }

    public ElementBuilder<K> node(org.w3c.dom.Node node) {
        this.checkDone();
        if (node instanceof NodeImpl) {
            ((NodeImpl)node).expand();
        }
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                NodeList children = node.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    this.node(children.item(i));
                }
                break;
            }
            case 1: {
                this.appendElem((Element)node);
                break;
            }
            case 3: {
                this.appendText(node.getTextContent());
                break;
            }
            default: {
                throw new RuntimeException("can't append node type " + node.getNodeType());
            }
        }
        return this;
    }

    public ElementBuilder<K> elem(String tag) {
        this.checkDone();
        Element elem = QName.parse(tag, this.namespaceBindings).createElement(this.doc);
        this.appendElem(elem);
        this.stack.add(0, elem);
        return this;
    }

    private org.w3c.dom.Node adopt(org.w3c.dom.Node node) {
        Document ownerDoc;
        Document document = ownerDoc = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        if (ownerDoc == this.doc) {
            return node;
        }
        if (node.getParentNode() == null) {
            try {
                org.w3c.dom.Node result = this.doc.adoptNode(node);
                if (result != null) {
                    return result;
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return this.doc.importNode(node, true);
    }

    private void appendElem(Element elem) {
        if (this.stack.isEmpty()) {
            if (!this.allowFragment && !this.top.isEmpty()) {
                throw new IllegalStateException("unable to build document fragment with multiple root nodes in current context");
            }
            this.top.add(elem);
        } else {
            this.current().appendChild(this.adopt(elem));
        }
    }

    public ElementBuilder<K> end(String tag) {
        this.checkDone();
        try {
            Element elem = this.stack.remove(0);
            QName elemName = QName.of(elem);
            if (!elemName.equals(QName.parse(tag, this.namespaceBindings))) {
                throw new IllegalStateException("element on top of stack is '" + elemName + "' not '" + tag + "'");
            }
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException("no open elements to match end(" + tag + ")");
        }
    }

    public ElementBuilder<K> end(String ... tags) {
        this.checkDone();
        try {
            Element elem = this.stack.remove(0);
            QName elemName = QName.of(elem);
            boolean matched = false;
            for (String tag : tags) {
                if (!elemName.equals(QName.parse(tag, this.namespaceBindings))) continue;
                matched = true;
                break;
            }
            if (!matched) {
                throw new IllegalStateException("element on top of stack is '" + elemName + "' not one of " + Arrays.asList(tags));
            }
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException("no open elements to match end(" + Arrays.asList(tags) + ")");
        }
    }

    public ElementBuilder<K> attr(String name, Object value) {
        this.checkDone();
        if (this.current().getNodeType() != 1) {
            throw new IllegalStateException("current node is not an element");
        }
        QName.parse(name, this.namespaceBindings, null).setAttribute((Element)this.current(), DataUtils.toXMLString(value));
        return this;
    }

    public ElementBuilder<K> attrIf(boolean condition, String name, Object value) {
        if (condition) {
            this.attr(name, value);
        }
        return this;
    }

    public ElementBuilder<K> text(Object text) {
        this.checkDone();
        this.appendText(DataUtils.toXMLString(text));
        return this;
    }

    private void appendText(String text) {
        Text textNode = this.doc.createTextNode(text);
        if (this.stack.isEmpty()) {
            if (!this.allowFragment) {
                throw new IllegalStateException("unable to add a root text node in current context");
            }
            this.top.add(textNode);
        } else {
            if (this.current().getNodeType() != 1) {
                throw new IllegalStateException("current node is not an element");
            }
            this.current().appendChild(textNode);
        }
    }

    public K commit() {
        this.checkDone();
        this.done = true;
        if (this.stack.size() != 0) {
            throw new IllegalStateException("can't commit with " + this.stack.size() + " elements left open");
        }
        if (this.top.isEmpty()) {
            return null;
        }
        return this.callback.completed(this.top.toArray(new org.w3c.dom.Node[this.top.size()]));
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.done) {
                LOG.warn("disposed without commit");
            }
        }
        finally {
            super.finalize();
        }
    }

    private class ScratchCallback
    implements CompletedCallback<org.w3c.dom.Node> {
        private ScratchCallback() {
        }

        @Override
        public org.w3c.dom.Node completed(org.w3c.dom.Node[] nodes) {
            if (nodes.length == 1) {
                return nodes[0];
            }
            DocumentFragment frag = ElementBuilder.this.doc.createDocumentFragment();
            for (int i = 0; i < nodes.length; ++i) {
                frag.appendChild(ElementBuilder.this.adopt(nodes[i]));
            }
            return frag;
        }
    }

    static interface CompletedCallback<T> {
        public T completed(org.w3c.dom.Node[] var1);
    }
}

