/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.fluent.Database;
import org.exist.fluent.DatabaseException;
import org.exist.fluent.Document;
import org.exist.fluent.ElementBuilder;
import org.exist.fluent.Listener;
import org.exist.fluent.ListenerManager;
import org.exist.fluent.Name;
import org.exist.fluent.NamedResource;
import org.exist.fluent.NamespaceMap;
import org.exist.fluent.QueryService;
import org.exist.fluent.Resource;
import org.exist.fluent.Source;
import org.exist.fluent.StaleMarker;
import org.exist.fluent.Transaction;
import org.exist.fluent.Trigger;
import org.exist.fluent.XMLDocument;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Folder
extends NamedResource
implements Cloneable {
    private String path;
    private StaleMarker staleMarker;
    private ChildrenFacet children;
    private DocumentsFacet documents;
    private ListenersFacet listeners;
    private NamedResource.MetadataFacet metadata;
    private DBBroker broker;
    private Collection handle;
    private Transaction tx;
    private Lock.LockMode lockMode;
    private boolean ownBroker;

    Folder(String path, boolean createIfMissing, Resource origin) {
        this(path, createIfMissing, origin.namespaceBindings().extend(), origin.database());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Folder(String path, boolean createIfMissing, NamespaceMap namespaceBindings, Database db) {
        super(namespaceBindings, db);
        if (path.length() == 0 || path.charAt(0) != '/') {
            throw new IllegalArgumentException("path must start with /, got " + path);
        }
        try {
            Collection collection;
            this.broker = db.acquireBroker();
            if (createIfMissing) {
                this.tx = Database.requireTransaction();
                try {
                    collection = this.createInternal(path);
                    this.tx.commit();
                }
                finally {
                    this.tx.abortIfIncomplete();
                }
            }
            try {
                collection = this.broker.getCollection(XmldbURI.create((String)path));
                if (collection == null) {
                    throw new DatabaseException("collection not found '" + path + "'");
                }
            }
            catch (PermissionDeniedException pde) {
                throw new DatabaseException(pde.getMessage(), pde);
            }
            this.changePath(collection.getURI().getCollectionPath());
        }
        finally {
            db.releaseBroker(this.broker);
            this.broker = null;
            this.tx = null;
        }
    }

    private void changePath(String newPath) {
        this.path = Database.normalizePath(newPath);
        this.staleMarker = new StaleMarker();
        this.staleMarker.track(this.path);
    }

    public ListenersFacet listeners() {
        if (this.listeners == null) {
            this.listeners = new ListenersFacet();
        }
        return this.listeners;
    }

    @Override
    public NamedResource.MetadataFacet metadata() {
        if (this.metadata == null) {
            this.metadata = new NamedResource.MetadataFacet(this.getQuickHandle().getPermissionsNoLock(), this.db){

                @Override
                public Date creationDate() {
                    return new Date(Folder.this.getQuickHandle().getCreationTime());
                }
            };
        }
        return this.metadata;
    }

    public Folder clone() {
        this.staleMarker.check();
        return new Folder(this.path(), false, this.namespaceBindings.clone(), this.db);
    }

    public Folder cloneWithoutNamespaceBindings() {
        this.staleMarker.check();
        return new Folder(this.path(), false, new NamespaceMap(new String[0]), this.db);
    }

    public boolean equals(Object o) {
        if (o instanceof Folder) {
            return this.path().equals(((Folder)o).path());
        }
        return false;
    }

    public int hashCode() {
        return this.path().hashCode();
    }

    public String toString() {
        return "folder '" + this.path() + "'";
    }

    private Collection createInternal(String targetPath) {
        try {
            Collection collection = this.broker.getOrCreateCollection(this.tx.tx, XmldbURI.create((String)targetPath));
            this.broker.saveCollection(this.tx.tx, collection);
            this.broker.flush();
            return collection;
        }
        catch (PermissionDeniedException e) {
            throw new DatabaseException(e);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
        catch (TriggerException e) {
            throw new DatabaseException(e);
        }
    }

    void transact(Lock.LockMode _lockMode) {
        if (this.tx != null) {
            throw new IllegalStateException("transaction already in progress");
        }
        this.tx = Database.requireTransaction();
        this.acquire(_lockMode);
    }

    void commit() {
        if (this.tx == null) {
            throw new IllegalStateException("no transaction in progress");
        }
        this.tx.commit();
    }

    void acquire(Lock.LockMode _lockMode) {
        DBBroker _broker = this.db.acquireBroker();
        this.ownBroker = true;
        try {
            this.acquire(_lockMode, _broker);
        }
        catch (RuntimeException e) {
            this.db.releaseBroker(_broker);
            this.ownBroker = false;
            throw e;
        }
    }

    void acquire(Lock.LockMode _lockMode, DBBroker _broker) {
        this.staleMarker.check();
        if (this.broker != null || this.handle != null) {
            throw new IllegalStateException("broker already acquired");
        }
        this.broker = _broker;
        try {
            this.handle = this.broker.openCollection(XmldbURI.create((String)this.path()), _lockMode);
            if (this.handle == null) {
                throw new DatabaseException("collection not found '" + this.path + "'");
            }
            this.lockMode = _lockMode;
        }
        catch (RuntimeException e) {
            this.broker = null;
            this.handle = null;
            throw e;
        }
        catch (PermissionDeniedException pde) {
            this.broker = null;
            this.handle = null;
            throw new DatabaseException(pde.getMessage(), pde);
        }
    }

    void release() {
        if (this.broker == null || this.handle == null) {
            throw new IllegalStateException("broker not acquired");
        }
        if (this.tx != null) {
            this.tx.abortIfIncomplete();
        }
        if (this.lockMode != Lock.LockMode.NO_LOCK) {
            this.handle.getLock().release(this.lockMode);
        }
        if (this.ownBroker) {
            this.db.releaseBroker(this.broker);
        }
        this.ownBroker = false;
        this.broker = null;
        this.handle = null;
        this.tx = null;
    }

    void changeLock(Lock.LockMode newLockMode) {
        if (this.broker == null || this.handle == null) {
            throw new IllegalStateException("broker not acquired");
        }
        if (this.lockMode == newLockMode) {
            return;
        }
        if (this.lockMode == Lock.LockMode.NO_LOCK) {
            try {
                this.handle.getLock().acquire(newLockMode);
                this.lockMode = newLockMode;
            }
            catch (LockException e) {
                throw new DatabaseException(e);
            }
        } else {
            if (newLockMode != Lock.LockMode.NO_LOCK) {
                throw new IllegalStateException("cannot change between read and write lock modes");
            }
            this.handle.getLock().release(this.lockMode);
            this.lockMode = newLockMode;
        }
    }

    private Collection getQuickHandle() {
        this.acquire(Lock.LockMode.NO_LOCK);
        try {
            Collection collection = this.handle;
            return collection;
        }
        finally {
            this.release();
        }
    }

    public boolean isEmpty() {
        this.acquire(Lock.LockMode.NO_LOCK);
        try {
            boolean bl = this.handle.getDocumentCount(this.broker) == 0 && this.handle.getChildCollectionCount(this.broker) == 0;
            return bl;
        }
        catch (PermissionDeniedException pde) {
            throw new DatabaseException(pde.getMessage(), pde);
        }
        finally {
            this.release();
        }
    }

    public void clear() {
        this.transact(Lock.LockMode.WRITE_LOCK);
        try {
            if (this.handle.getDocumentCount(this.broker) == 0 && this.handle.getChildCollectionCount(this.broker) == 0) {
                return;
            }
            this.broker.removeCollection(this.tx.tx, this.handle);
            this.createInternal(this.path);
            this.commit();
        }
        catch (PermissionDeniedException e) {
            throw new DatabaseException(e);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
        catch (TriggerException e) {
            throw new DatabaseException(e);
        }
        finally {
            this.release();
        }
        this.changePath(this.path);
    }

    @Override
    public void delete() {
        this.transact(Lock.LockMode.NO_LOCK);
        try {
            if (this.path.equals("/")) {
                Iterator it = this.handle.iterator(this.broker);
                while (it.hasNext()) {
                    DocumentImpl dimpl = (DocumentImpl)it.next();
                    if (dimpl instanceof BinaryDocument) {
                        this.handle.removeBinaryResource(this.tx.tx, this.broker, dimpl);
                        continue;
                    }
                    this.handle.removeXMLResource(this.tx.tx, this.broker, dimpl.getFileURI());
                }
            }
            this.broker.removeCollection(this.tx.tx, this.handle);
            this.commit();
        }
        catch (PermissionDeniedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
        catch (LockException e) {
            throw new DatabaseException(e);
        }
        catch (TriggerException e) {
            throw new DatabaseException(e);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void move(Folder destination, Name name) {
        this.changePath(this.moveOrCopyThisFolder(destination, name, false));
    }

    @Override
    public Folder copy(Folder destination, Name name) {
        return new Folder(this.moveOrCopyThisFolder(destination, name, true), false, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String moveOrCopyThisFolder(Folder destination, Name name, boolean copy) {
        this.db.checkSame(destination);
        this.transact(Lock.LockMode.WRITE_LOCK);
        try {
            destination.acquire(Lock.LockMode.WRITE_LOCK, this.broker);
            try {
                name.setOldName(this.name());
                name.setContext(this.handle);
                if (copy) {
                    this.broker.copyCollection(this.tx.tx, this.handle, destination.handle, XmldbURI.create((String)name.get()));
                } else {
                    this.broker.moveCollection(this.tx.tx, this.handle, destination.handle, XmldbURI.create((String)name.get()));
                }
                this.commit();
            }
            catch (PermissionDeniedException e) {
                throw new DatabaseException(e);
            }
            catch (LockException e) {
                throw new DatabaseException(e);
            }
            catch (IOException e) {
                throw new DatabaseException(e);
            }
            catch (TriggerException e) {
                throw new DatabaseException(e);
            }
            catch (EXistException e) {
                throw new DatabaseException(e);
            }
            finally {
                destination.release();
            }
        }
        finally {
            this.release();
        }
        return destination.path() + "/" + name.get();
    }

    public DocumentsFacet documents() {
        if (this.documents == null) {
            this.documents = new DocumentsFacet();
        }
        return this.documents;
    }

    public boolean contains(NamedResource res) {
        this.staleMarker.check();
        this.db.checkSame(res);
        return res.path().startsWith(this.path() + (this.path().equals("/") ? "" : "/"));
    }

    public String relativePath(String subPath) {
        if (subPath.equals(this.path())) {
            return "";
        }
        if (this.path().equals("/") && subPath.charAt(0) == '/') {
            return subPath.substring(1);
        }
        if (!subPath.startsWith(this.path() + "/")) {
            throw new IllegalArgumentException("path '" + subPath + "' does not fall under this collection's path '" + this.path() + "'");
        }
        return subPath.substring(this.path().length() + 1);
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String name() {
        return this.path().substring(this.path().lastIndexOf(47) + 1);
    }

    public Folder parent() {
        String parentPath = this.getQuickHandle().getURI().removeLastSegment().getCollectionPath();
        if (parentPath == null || parentPath.length() == 0) {
            throw new DatabaseException("this is the root collection");
        }
        return new Folder(parentPath, false, this);
    }

    public ChildrenFacet children() {
        if (this.children == null) {
            this.children = new ChildrenFacet();
        }
        return this.children;
    }

    public void export(File destination) throws IOException {
        this.documents().export(destination);
        this.children().export(destination);
    }

    @Override
    Sequence convertToSequence() {
        this.staleMarker.check();
        return this.getDocsSequence(true);
    }

    private Sequence getDocsSequence(boolean recursive) {
        try {
            MutableDocumentSet docs;
            this.acquire(Lock.LockMode.READ_LOCK);
            try {
                docs = this.handle.allDocs(this.broker, (MutableDocumentSet)new DefaultDocumentSet(), recursive);
            }
            catch (PermissionDeniedException pde) {
                throw new DatabaseException(pde.getMessage(), pde);
            }
            finally {
                this.release();
            }
            ExtArrayNodeSet result = new ExtArrayNodeSet(docs.getDocumentCount(), 1);
            Iterator i = docs.getDocumentIterator();
            while (i.hasNext()) {
                result.add((Item)new NodeProxy((DocumentImpl)i.next()));
            }
            return result;
        }
        catch (XPathException e) {
            throw new RuntimeException("unexpected exception converting document set to sequence", e);
        }
    }

    @Override
    public QueryService query() {
        this.staleMarker.check();
        return super.query();
    }

    @Override
    QueryService createQueryService() {
        return new QueryService(this){

            @Override
            void prepareContext(DBBroker broker_) {
                Folder.this.acquire(Lock.LockMode.READ_LOCK, broker_);
                try {
                    this.docs = Folder.this.handle.allDocs(broker_, (MutableDocumentSet)new DefaultDocumentSet(), true);
                    this.baseUri = new AnyURIValue(Folder.this.handle.getURI());
                }
                catch (PermissionDeniedException pde) {
                    throw new DatabaseException(pde.getMessage(), pde);
                }
                finally {
                    Folder.this.release();
                }
            }
        };
    }

    void removeDocument(DocumentImpl dimpl) {
        this.transact(Lock.LockMode.WRITE_LOCK);
        try {
            if (dimpl instanceof BinaryDocument) {
                this.handle.removeBinaryResource(this.tx.tx, this.broker, dimpl.getFileURI());
            } else {
                this.handle.removeXMLResource(this.tx.tx, this.broker, dimpl.getFileURI());
            }
            this.commit();
        }
        catch (IOException | TriggerException | PermissionDeniedException | LockException e) {
            throw new DatabaseException(e);
        }
        finally {
            this.release();
        }
    }

    DocumentImpl moveOrCopyDocument(DocumentImpl doc, Name name, boolean copy) {
        XmldbURI uri;
        this.transact(Lock.LockMode.WRITE_LOCK);
        try {
            name.setContext(this.handle);
            uri = XmldbURI.create((String)name.get());
            if (copy) {
                this.tx.lockRead(doc);
                this.broker.copyResource(this.tx.tx, doc, this.handle, uri);
            } else {
                this.tx.lockWrite(doc);
                this.broker.moveResource(this.tx.tx, doc, this.handle, uri);
            }
            this.commit();
        }
        catch (PermissionDeniedException pde) {
            throw new DatabaseException(pde.getMessage(), pde);
        }
        catch (LockException e) {
            throw new DatabaseException("lock denied", e);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
        catch (TriggerException e) {
            throw new DatabaseException(e);
        }
        catch (EXistException e) {
            throw new DatabaseException(e);
        }
        finally {
            this.release();
        }
        DBBroker _broker = null;
        Collection _handle = this.getQuickHandle();
        try {
            _broker = this.db.acquireBroker();
            DocumentImpl documentImpl = _handle.getDocument(_broker, uri);
            return documentImpl;
        }
        catch (PermissionDeniedException pde) {
            throw new DatabaseException(pde.getMessage(), pde);
        }
        finally {
            if (_broker != null) {
                this.db.releaseBroker(_broker);
            }
        }
    }

    public class ListenersFacet {
        public void add(Trigger trigger, org.exist.fluent.Listener listener) {
            this.add(EnumSet.of(trigger), listener);
        }

        public void add(Set<Trigger> triggers, org.exist.fluent.Listener listener) {
            Folder.this.staleMarker.check();
            ListenerManager.INSTANCE.add(Folder.this.path(), ListenerManager.Depth.MANY, triggers, listener, Folder.this);
        }

        public void remove(org.exist.fluent.Listener listener) {
            ListenerManager.INSTANCE.remove(Folder.this.path(), ListenerManager.Depth.MANY, listener);
        }
    }

    public class DocumentsFacet
    extends Resource
    implements Iterable<Document> {
        private ListenersFacet listeners;

        private DocumentsFacet() {
            super(Folder.this.namespaceBindings, Folder.this.db);
        }

        @Override
        Sequence convertToSequence() {
            Folder.this.staleMarker.check();
            return Folder.this.getDocsSequence(false);
        }

        public ListenersFacet listeners() {
            if (this.listeners == null) {
                this.listeners = new ListenersFacet();
            }
            return this.listeners;
        }

        public ElementBuilder<XMLDocument> build(final Name name) {
            Folder target = name.stripPathPrefix(Folder.this);
            if (target != Folder.this) {
                return target.documents().build(name);
            }
            Folder.this.staleMarker.check();
            return new ElementBuilder<XMLDocument>(Folder.this.namespaceBindings(), false, new ElementBuilder.CompletedCallback<XMLDocument>(){

                @Override
                public XMLDocument completed(Node[] nodes) {
                    assert (nodes.length == 1);
                    Node node = nodes[0];
                    Folder.this.transact(Lock.LockMode.WRITE_LOCK);
                    try {
                        name.setContext(Folder.this.handle);
                        IndexInfo info = Folder.this.handle.validateXMLResource(((Folder)Folder.this).tx.tx, Folder.this.broker, XmldbURI.create((String)name.get()), node);
                        Folder.this.changeLock(Lock.LockMode.NO_LOCK);
                        Folder.this.handle.store(((Folder)Folder.this).tx.tx, Folder.this.broker, info, node);
                        Folder.this.commit();
                    }
                    catch (EXistException e) {
                        throw new DatabaseException(e);
                    }
                    catch (PermissionDeniedException e) {
                        throw new DatabaseException(e);
                    }
                    catch (TriggerException e) {
                        throw new DatabaseException(e);
                    }
                    catch (SAXException e) {
                        throw new DatabaseException(e);
                    }
                    catch (LockException e) {
                        throw new DatabaseException(e);
                    }
                    catch (IOException e) {
                        throw new DatabaseException(e);
                    }
                    finally {
                        Folder.this.release();
                    }
                    return DocumentsFacet.this.get(name.get()).xml();
                }
            });
        }

        public boolean contains(String documentPath) {
            this.checkIsRelativeDocPath(documentPath);
            if (documentPath.contains("/")) {
                return this.database().contains(Folder.this.path() + "/" + documentPath);
            }
            DBBroker _broker = null;
            try {
                _broker = this.db.acquireBroker();
                boolean bl = Folder.this.getQuickHandle().getDocument(_broker, XmldbURI.create((String)documentPath)) != null;
                return bl;
            }
            catch (PermissionDeniedException pde) {
                throw new DatabaseException(pde.getMessage(), pde);
            }
            finally {
                if (_broker != null) {
                    this.db.releaseBroker(_broker);
                }
            }
        }

        public XMLDocument load(Name name, Source.XML source) {
            Folder target = name.stripPathPrefix(Folder.this);
            if (target != Folder.this) {
                return target.documents().load(name, source);
            }
            Folder.this.transact(Lock.LockMode.WRITE_LOCK);
            try {
                source.applyOldName(name);
                name.setContext(Folder.this.handle);
                IndexInfo info = Folder.this.handle.validateXMLResource(((Folder)Folder.this).tx.tx, Folder.this.broker, XmldbURI.create((String)name.get()), source.toInputSource());
                Folder.this.changeLock(Lock.LockMode.NO_LOCK);
                Folder.this.handle.store(((Folder)Folder.this).tx.tx, Folder.this.broker, info, source.toInputSource());
                Folder.this.commit();
            }
            catch (EXistException e) {
                throw new DatabaseException("failed to create document '" + name + "' from source " + source, e);
            }
            catch (PermissionDeniedException e) {
                throw new DatabaseException("failed to create document '" + name + "' from source " + source, e);
            }
            catch (TriggerException e) {
                throw new DatabaseException("failed to create document '" + name + "' from source " + source, e);
            }
            catch (SAXException e) {
                throw new DatabaseException("failed to create document '" + name + "' from source " + source, e);
            }
            catch (LockException e) {
                throw new DatabaseException("failed to create document '" + name + "' from source " + source, e);
            }
            catch (IOException e) {
                throw new DatabaseException("failed to create document '" + name + "' from source " + source, e);
            }
            finally {
                Folder.this.release();
            }
            return this.get(name.get()).xml();
        }

        public Document load(Name name, Source.Blob source) {
            Folder target = name.stripPathPrefix(Folder.this);
            if (target != Folder.this) {
                return target.documents().load(name, source);
            }
            Folder.this.transact(Lock.LockMode.WRITE_LOCK);
            try {
                source.applyOldName(name);
                name.setContext(Folder.this.handle);
                try (InputStream inputStream = source.toInputStream();){
                    Folder.this.handle.addBinaryResource(((Folder)Folder.this).tx.tx, Folder.this.broker, XmldbURI.create((String)name.get()), inputStream, null, (long)source.getLength());
                }
                Folder.this.commit();
            }
            catch (IOException e) {
                throw new DatabaseException("failed to create document '" + name + "' from source " + source, e);
            }
            finally {
                Folder.this.release();
            }
            return this.get(name.get());
        }

        public Document get(String documentPath) {
            this.checkIsRelativeDocPath(documentPath);
            if (documentPath.contains("/")) {
                return this.database().getDocument(Folder.this.path() + "/" + documentPath);
            }
            DBBroker _broker = null;
            try {
                _broker = this.db.acquireBroker();
                DocumentImpl dimpl = Folder.this.getQuickHandle().getDocument(_broker, XmldbURI.create((String)documentPath));
                if (dimpl == null) {
                    throw new DatabaseException("no such document: " + documentPath);
                }
                Document document = Document.newInstance(dimpl, Folder.this);
                return document;
            }
            catch (PermissionDeniedException pde) {
                throw new DatabaseException(pde.getMessage(), pde);
            }
            finally {
                if (_broker != null) {
                    this.db.releaseBroker(_broker);
                }
            }
        }

        private void checkIsRelativeDocPath(String docPath) {
            if (docPath.startsWith("/")) {
                throw new IllegalArgumentException("relative path cannot start with '/': " + docPath);
            }
            if (docPath.endsWith("/")) {
                throw new IllegalArgumentException("relative path cannot end with '/': " + docPath);
            }
        }

        public int size() {
            DBBroker _broker = null;
            try {
                _broker = this.db.acquireBroker();
                int n = Folder.this.getQuickHandle().getDocumentCount(_broker);
                return n;
            }
            catch (PermissionDeniedException pde) {
                throw new DatabaseException(pde.getMessage(), pde);
            }
            finally {
                this.db.releaseBroker(_broker);
            }
        }

        public void export(File destination) throws IOException {
            if (!destination.exists()) {
                destination.mkdirs();
            }
            if (!destination.isDirectory()) {
                throw new IOException("export destination not a directory: " + destination);
            }
            for (Document doc : this) {
                doc.export(new File(destination, doc.name()));
            }
        }

        @Override
        public QueryService query() {
            Folder.this.staleMarker.check();
            return super.query();
        }

        @Override
        QueryService createQueryService() {
            return new QueryService(Folder.this){

                @Override
                protected void prepareContext(DBBroker broker_) {
                    Folder.this.acquire(Lock.LockMode.READ_LOCK, broker_);
                    try {
                        this.docs = Folder.this.handle.allDocs(broker_, (MutableDocumentSet)new DefaultDocumentSet(), false);
                        this.baseUri = new AnyURIValue(Folder.this.handle.getURI());
                    }
                    catch (PermissionDeniedException pde) {
                        throw new DatabaseException(pde.getMessage(), pde);
                    }
                    finally {
                        Folder.this.release();
                    }
                }
            };
        }

        @Override
        public Iterator<Document> iterator() {
            return new Iterator<Document>(){
                private Iterator<DocumentImpl> delegate;
                private Document last;
                {
                    Folder.this.acquire(Lock.LockMode.READ_LOCK);
                    try {
                        this.delegate = Folder.this.handle.iterator(Folder.this.broker);
                    }
                    catch (PermissionDeniedException | LockException e) {
                        throw new DatabaseException(e.getMessage(), e);
                    }
                    finally {
                        Folder.this.release();
                    }
                }

                @Override
                public void remove() {
                    Folder.this.staleMarker.check();
                    if (this.last == null) {
                        throw new IllegalStateException("no document to remove");
                    }
                    this.last.delete();
                    this.last = null;
                }

                @Override
                public boolean hasNext() {
                    Folder.this.staleMarker.check();
                    return this.delegate.hasNext();
                }

                @Override
                public Document next() {
                    Folder.this.staleMarker.check();
                    this.last = Document.newInstance(this.delegate.next(), Folder.this);
                    return this.last;
                }
            };
        }

        public class ListenersFacet {
            public void add(Trigger trigger, Document.Listener listener) {
                this.add(EnumSet.of(trigger), listener);
            }

            public void add(Set<Trigger> triggers, Document.Listener listener) {
                Folder.this.staleMarker.check();
                ListenerManager.INSTANCE.add(Folder.this.path(), ListenerManager.Depth.ONE, triggers, listener, Folder.this);
            }

            public void remove(Document.Listener listener) {
                ListenerManager.INSTANCE.remove(Folder.this.path(), ListenerManager.Depth.ONE, (org.exist.fluent.Listener)listener);
            }
        }
    }

    public class ChildrenFacet
    implements Iterable<Folder> {
        private ChildrenFacet() {
        }

        public Folder get(String descendantName) {
            Folder.this.staleMarker.check();
            if (descendantName.startsWith("/")) {
                throw new IllegalArgumentException("descendant name starts with '/': " + descendantName);
            }
            String parentPath = Folder.this.path();
            if (parentPath.equals("/")) {
                parentPath = "";
            }
            return new Folder(parentPath + "/" + descendantName, false, Folder.this);
        }

        public Folder create(String descendantName) {
            Folder.this.staleMarker.check();
            if (descendantName.startsWith("/")) {
                throw new IllegalArgumentException("descendant name starts with '/': " + descendantName);
            }
            String parentPath = Folder.this.path();
            if (parentPath.equals("/")) {
                parentPath = "";
            }
            return new Folder(parentPath + "/" + descendantName, true, Folder.this);
        }

        public int size() {
            DBBroker _broker = null;
            try {
                _broker = Folder.this.db.acquireBroker();
                int n = Folder.this.getQuickHandle().getChildCollectionCount(_broker);
                return n;
            }
            catch (PermissionDeniedException pde) {
                throw new DatabaseException(pde.getMessage(), pde);
            }
            finally {
                Folder.this.db.releaseBroker(_broker);
            }
        }

        public boolean contains(String descendantName) {
            Folder.this.staleMarker.check();
            if (descendantName.startsWith("/")) {
                throw new IllegalArgumentException("child name starts with '/': " + descendantName);
            }
            DBBroker _broker = null;
            try {
                _broker = Folder.this.db.acquireBroker();
                boolean bl = _broker.getCollection(XmldbURI.create((String)(Folder.this.path() + "/" + descendantName))) != null;
                return bl;
            }
            catch (PermissionDeniedException pde) {
                throw new DatabaseException(pde.getMessage(), pde);
            }
            finally {
                Folder.this.db.releaseBroker(_broker);
            }
        }

        public void export(File destination) throws IOException {
            if (!destination.exists()) {
                destination.mkdirs();
            }
            if (!destination.isDirectory()) {
                throw new IOException("export destination not a directory: " + destination);
            }
            for (Folder child : this) {
                child.export(new File(destination, child.name()));
            }
        }

        @Override
        public Iterator<Folder> iterator() {
            Folder.this.staleMarker.check();
            return new FolderIterator();
        }

        public class FolderIterator
        implements Iterator<Folder> {
            private Folder last;
            private Iterator<XmldbURI> delegate = null;
            private DBBroker broker = null;

            private Iterator<XmldbURI> getDelegate() throws IllegalStateException {
                if (this.delegate == null) {
                    try {
                        this.broker = Folder.this.db.acquireBroker();
                        this.delegate = Folder.this.getQuickHandle().collectionIterator(this.broker);
                    }
                    catch (PermissionDeniedException | LockException e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                }
                return this.delegate;
            }

            @Override
            public void remove() {
                Folder.this.staleMarker.check();
                if (this.last == null) {
                    throw new IllegalStateException("no collection to remove");
                }
                this.last.delete();
                this.last = null;
            }

            @Override
            public boolean hasNext() {
                Folder.this.staleMarker.check();
                boolean result = this.getDelegate().hasNext();
                if (!result) {
                    Folder.this.db.releaseBroker(this.broker);
                }
                return result;
            }

            @Override
            public Folder next() {
                Folder.this.staleMarker.check();
                this.last = ChildrenFacet.this.get(this.getDelegate().next().getCollectionPath());
                return this.last;
            }
        }
    }

    public static class Event
    extends Listener.Event {
        public final Folder folder;

        Event(Trigger trigger, String path, Folder folder) {
            super(trigger, path);
            this.folder = folder;
        }

        Event(ListenerManager.EventKey key, Folder folder) {
            super(key);
            this.folder = folder;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o) && (this.folder == null ? ((Event)o).folder == null : this.folder.equals(((Event)o).folder));
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 37 + (this.folder == null ? 0 : this.folder.hashCode());
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            buf.insert(3, "Folder.");
            buf.insert(buf.length() - 1, ", " + this.folder);
            return buf.toString();
        }
    }

    public static interface Listener
    extends org.exist.fluent.Listener {
        public void handle(Event var1);
    }
}

