/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.fluent.Database;
import org.exist.fluent.DatabaseException;
import org.exist.fluent.Folder;
import org.exist.fluent.Name;
import org.exist.fluent.NamespaceMap;
import org.exist.fluent.Resource;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;

public abstract class NamedResource
extends Resource {
    protected NamedResource(NamespaceMap namespaceBindings, Database db) {
        super(namespaceBindings, db);
    }

    public abstract String name();

    public abstract String path();

    public abstract NamedResource copy(Folder var1, Name var2);

    public abstract void move(Folder var1, Name var2);

    public abstract void delete();

    public abstract MetadataFacet metadata();

    public static abstract class MetadataFacet {
        private static final Pattern INSTRUCTIONS_REGEX = Pattern.compile("(a|(u?g?o?){1,3})((=r?w?u?)|([-+](r?w?u?){1,3}))(,(a|(u?g?o?){1,3})((=r?w?u?)|([-+](r?w?u?){1,3})))*");
        private static final Pattern SEGMENT_REGEX = Pattern.compile("([augo]+)([-+=])([rwu]*)");
        private Permission permissions;
        private final Database db;

        protected MetadataFacet(Permission permissions, Database db) {
            this.permissions = permissions;
            this.db = db;
        }

        public abstract Date creationDate();

        public String owner() {
            return this.permissions.getOwner().getName();
        }

        public void owner(String owner) {
            DBBroker broker = null;
            try {
                broker = this.db.acquireBroker();
                this.permissions.setOwner(owner);
            }
            catch (PermissionDeniedException pde) {
                throw new DatabaseException(pde.getMessage(), pde);
            }
            finally {
                if (broker != null) {
                    this.db.releaseBroker(broker);
                }
            }
        }

        public String group() {
            return this.permissions.getGroup().getName();
        }

        public void group(String group) {
            DBBroker broker = null;
            try {
                broker = this.db.acquireBroker();
                this.permissions.setGroup(group);
            }
            catch (PermissionDeniedException pde) {
                throw new DatabaseException(pde.getMessage(), pde);
            }
            finally {
                if (broker != null) {
                    this.db.releaseBroker(broker);
                }
            }
        }

        public boolean hasPermission(char who, char what) {
            int mask = this.convertPermissionBit(what);
            switch (who) {
                case 'a': {
                    mask = mask | mask << 3 | mask << 6;
                    break;
                }
                case 'u': {
                    mask <<= 6;
                    break;
                }
                case 'g': {
                    mask <<= 3;
                    break;
                }
                case 'o': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal permission \"who\" code '" + who + "'");
                }
            }
            return (this.permissions.getMode() & mask) == mask;
        }

        private int convertPermissionBit(char what) {
            switch (what) {
                case 'r': {
                    return 4;
                }
                case 'w': {
                    return 2;
                }
                case 'x': {
                    return 1;
                }
            }
            throw new IllegalArgumentException("illegal permission \"what\" code '" + what + "'");
        }

        private int convertPermissionBits(String what) {
            int perms = 0;
            for (int i = 0; i < what.length(); ++i) {
                perms |= this.convertPermissionBit(what.charAt(i));
            }
            return perms;
        }

        public void changePermissions(String instructions) {
            if (!INSTRUCTIONS_REGEX.matcher(instructions).matches()) {
                throw new IllegalArgumentException("bad permissions instructions: " + instructions);
            }
            StringTokenizer tokenizer = new StringTokenizer(instructions, ",");
            try {
                while (tokenizer.hasMoreTokens()) {
                    int newPerms;
                    Matcher matcher = SEGMENT_REGEX.matcher(tokenizer.nextToken());
                    if (!matcher.matches()) {
                        throw new RuntimeException("internal error: illegal segment got through syntax regex, instruction string " + instructions);
                    }
                    int perms = this.convertPermissionBits(matcher.group(3));
                    int mask = 0;
                    boolean all = matcher.group(1).equals("a");
                    if (all || matcher.group(1).indexOf(117) != -1) {
                        mask |= perms << 6;
                    }
                    if (all || matcher.group(1).indexOf(103) != -1) {
                        mask |= perms << 3;
                    }
                    if (all || matcher.group(1).indexOf(111) != -1) {
                        mask |= perms;
                    }
                    switch (matcher.group(2).charAt(0)) {
                        case '=': {
                            newPerms = mask;
                            break;
                        }
                        case '+': {
                            newPerms = this.permissions.getMode() | mask;
                            break;
                        }
                        case '-': {
                            newPerms = this.permissions.getMode() & ~mask;
                            break;
                        }
                        default: {
                            throw new RuntimeException("internal error: illegal segment operator got through syntax regex, instruction string " + instructions);
                        }
                    }
                    this.permissions.setMode(newPerms);
                }
            }
            catch (PermissionDeniedException pde) {
                throw new DatabaseException(pde.getMessage(), pde);
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.permissions.getOwnerMode() == this.permissions.getGroupMode() && this.permissions.getOwnerMode() == this.permissions.getOtherMode()) {
                this.appendPermissions('a', 'u', buf);
                buf.append(' ');
            } else {
                this.appendPermissions('u', 'u', buf);
                buf.append(',');
                this.appendPermissions('g', 'g', buf);
                buf.append(',');
                this.appendPermissions('o', 'o', buf);
                buf.append(' ');
            }
            if (this.owner() != null) {
                buf.append("u:").append(this.owner()).append(' ');
            }
            if (this.group() != null) {
                buf.append("g:").append(this.group()).append(' ');
            }
            buf.append(this.creationDate());
            return buf.toString();
        }

        private void appendPermissions(char prefix, char who, StringBuilder buf) {
            buf.append(prefix).append('=');
            if (this.hasPermission(who, 'r')) {
                buf.append('r');
            }
            if (this.hasPermission(who, 'w')) {
                buf.append('w');
            }
            if (this.hasPermission(who, 'u')) {
                buf.append('u');
            }
        }
    }
}

