/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import org.exist.fluent.NamespaceMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QName
extends javax.xml.namespace.QName
implements Comparable<QName> {
    private static final long serialVersionUID = -7374508115268644368L;
    private final String tag;

    public QName(String namespace, String localName, String prefix) {
        super(namespace == null ? "" : namespace, localName, prefix == null ? "" : prefix);
        if (localName == null || localName.length() == 0) {
            throw new IllegalArgumentException("null or empty local name");
        }
        this.tag = prefix == null || prefix.equals("") ? localName : prefix + ":" + localName;
    }

    @Override
    public int compareTo(QName o) {
        return 2 * this.getNamespaceURI().compareTo(o.getNamespaceURI()) + this.getLocalPart().compareTo(o.getLocalPart());
    }

    public boolean hasNamespace() {
        return !this.getNamespaceURI().equals("");
    }

    public Element createElement(Document doc) {
        if (this.hasNamespace()) {
            return doc.createElementNS(this.getNamespaceURI(), this.tag);
        }
        return doc.createElement(this.tag);
    }

    public Attr createAttribute(Document doc) {
        if (this.hasNamespace()) {
            return doc.createAttributeNS(this.getNamespaceURI(), this.tag);
        }
        return doc.createAttribute(this.tag);
    }

    public void setAttribute(Element elem, String value) {
        if (this.hasNamespace()) {
            elem.setAttributeNS(this.getNamespaceURI(), this.tag, value);
        } else {
            elem.setAttribute(this.tag, value);
        }
    }

    public Attr getAttributeNode(Element elem) {
        if (this.hasNamespace()) {
            return elem.getAttributeNodeNS(this.getNamespaceURI(), this.getLocalPart());
        }
        return elem.getAttributeNode(this.tag);
    }

    public String getTag() {
        return this.tag;
    }

    public static QName of(Node node) {
        String localName = node.getLocalName();
        if (localName == null) {
            localName = node.getNodeName();
        }
        return new QName(node.getNamespaceURI(), localName, node.getPrefix());
    }

    public static QName parse(String tag, NamespaceMap namespaces) {
        return QName.parse(tag, namespaces, namespaces.get(""));
    }

    public static QName parse(String tag, NamespaceMap namespaces, String defaultNamespace) {
        String ns;
        int colonIndex = tag.indexOf(58);
        if (colonIndex == 0 || colonIndex == tag.length() - 1) {
            throw new IllegalArgumentException("illegal tag syntax '" + tag + "'");
        }
        String prefix = colonIndex == -1 ? "" : tag.substring(0, colonIndex);
        String string = ns = prefix.length() > 0 ? namespaces.get(prefix) : defaultNamespace;
        if (ns == null && prefix.length() > 0) {
            throw new IllegalArgumentException("no namespace registered for tag prefix '" + prefix + "'");
        }
        return new QName(ns, tag.substring(colonIndex + 1), prefix);
    }
}

