/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.io.IOException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.fluent.DataUtils;
import org.exist.fluent.DatabaseException;
import org.exist.fluent.Document;
import org.exist.fluent.Item;
import org.exist.fluent.ItemList;
import org.exist.fluent.NamespaceMap;
import org.exist.fluent.QName;
import org.exist.fluent.Resource;
import org.exist.fluent.XMLDocument;
import org.exist.security.PermissionDeniedException;
import org.exist.source.Source;
import org.exist.source.StringSourceWithMapKey;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.PathExpr;
import org.exist.xquery.SequenceConstructor;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.Variable;
import org.exist.xquery.VariableImpl;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.FunExactlyOne;
import org.exist.xquery.functions.fn.FunExists;
import org.exist.xquery.functions.fn.FunZeroOrOne;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class QueryService
implements Cloneable {
    private static final Pattern PRE_SUB_PATTERN = Pattern.compile("\\$(\\d+)");
    private static final Logger LOG = LogManager.getLogger(QueryService.class);
    private static final Statistics STATS = new Statistics();
    private NamespaceMap namespaceBindings;
    private Map<String, Document> moduleMap = new TreeMap<String, Document>();
    private final org.exist.fluent.Database db;
    protected DocumentSet docs;
    protected DocumentSet overrideDocs;
    protected Sequence base;
    protected AnyURIValue baseUri;
    private Map<QName, Object> bindings = new HashMap<QName, Object>();
    private boolean presub;
    static final QueryService NULL = new QueryService(){

        @Override
        protected ItemList executeQuery(String query, WrapperFactory wrappeFactory, Object[] params) {
            return ItemList.NULL;
        }

        @Override
        public QueryAnalysis analyze(String query, Object ... params) {
            throw new UnsupportedOperationException("NULL query service");
        }

        @Override
        public QueryService let(String var, Object value) {
            return this;
        }

        @Override
        public QueryService namespace(String key, String uri) {
            return this;
        }

        @Override
        public NamespaceMap namespaceBindings() {
            throw new UnsupportedOperationException("NULL query service");
        }

        @Override
        public QueryService importModule(Document module) {
            return this;
        }

        @Override
        public Item single(String query, Object ... params) {
            throw new DatabaseException("expected 1 result item, got 0 (NULL query)");
        }
    };
    final Pattern MODULE_DECLARATION_DQUOTE = Pattern.compile("\\A\\s*module\\s+namespace\\s+[\\p{Alpha}_][\\w.-]*\\s*=\\s*\"(([^\"]*(\"\")?)*)\"\\s*;");
    final Pattern MODULE_DECLARATION_SQUOTE = Pattern.compile("\\A\\s*module\\s+namespace\\s+[\\p{Alpha}_][\\w.-]*\\s*=\\s*'(([^']*('')?)*)'\\s*;");
    private static final WrapperFactory EXACTLY_ONE = new WrapperFactory(){

        @Override
        public Function createWrapper(XQueryContext context) {
            return new FunExactlyOne(context);
        }
    };
    private static final WrapperFactory ZERO_OR_ONE = new WrapperFactory(){

        @Override
        public Function createWrapper(XQueryContext context) {
            return new FunZeroOrOne(context);
        }
    };
    private static final WrapperFactory EXISTS = new WrapperFactory(){

        @Override
        public Function createWrapper(XQueryContext context) {
            return new FunExists(context);
        }
    };

    public static Statistics statistics() {
        return STATS;
    }

    QueryService(Resource origin) {
        this.namespaceBindings = origin.namespaceBindings().extend();
        this.db = origin.database();
    }

    QueryService(Resource origin, DocumentSet docs, Sequence base) {
        this(origin);
        this.docs = docs;
        this.base = base;
    }

    private QueryService() {
        this.namespaceBindings = null;
        this.db = null;
    }

    boolean isFreshFrom(Resource origin) {
        return !this.presub && this.bindings.isEmpty() && this.moduleMap.isEmpty() && (this.namespaceBindings == null || this.namespaceBindings.isFreshFrom(origin.namespaceBindings()));
    }

    void prepareContext(DBBroker broker) {
    }

    public org.exist.fluent.Database database() {
        return new org.exist.fluent.Database(this.db, this.namespaceBindings);
    }

    public QueryService let(String variableName, Object value) {
        if (variableName == null) {
            throw new NullPointerException("null variable name");
        }
        if (variableName.startsWith("$")) {
            variableName = variableName.substring(1);
        }
        if (variableName.length() == 0) {
            throw new IllegalArgumentException("empty variable name");
        }
        return this.let(QName.parse(variableName, this.namespaceBindings, ""), value);
    }

    public QueryService let(QName variableName, Object value) {
        this.bindings.put(variableName, value);
        return this;
    }

    public QueryService namespace(String key, String uri) {
        this.namespaceBindings.put(key, uri);
        return this;
    }

    public NamespaceMap namespaceBindings() {
        return this.namespaceBindings;
    }

    public QueryService importModule(Document module) {
        if (module instanceof XMLDocument) {
            throw new DatabaseException("module cannot be an XML document: " + module);
        }
        Matcher matcher = this.MODULE_DECLARATION_DQUOTE.matcher(module.contentsAsString());
        if (!matcher.find() && !(matcher = this.MODULE_DECLARATION_SQUOTE.matcher(module.contentsAsString())).find()) {
            throw new DatabaseException("couldn't find a module declaration at the top of " + module);
        }
        module.metadata().setMimeType("application/xquery");
        String moduleNamespace = matcher.group(1);
        Document prevModule = this.moduleMap.get(moduleNamespace);
        if (prevModule != null && !prevModule.equals(module)) {
            throw new DatabaseException("module " + moduleNamespace + " already bound to " + prevModule + ", can't rebind to " + module);
        }
        this.moduleMap.put(moduleNamespace, module);
        return this;
    }

    public QueryService importSameModulesAs(QueryService that) {
        this.moduleMap.putAll(that.moduleMap);
        return this;
    }

    public QueryService limitRootDocuments(XMLDocument ... rootDocs) {
        return this.limitRootDocuments(Arrays.asList(rootDocs));
    }

    public QueryService limitRootDocuments(Collection<XMLDocument> rootDocs) {
        this.overrideDocs = new DefaultDocumentSet();
        for (XMLDocument doc : rootDocs) {
            ((MutableDocumentSet)this.overrideDocs).add(doc.doc);
        }
        return this;
    }

    public QueryService presub() {
        this.presub = true;
        return this;
    }

    public QueryService clone() {
        return this.clone(null, null);
    }

    public QueryService clone(NamespaceMap nsBindingsOverride, Map<QName, ?> varBindingsOverride) {
        try {
            QueryService that = (QueryService)super.clone();
            NamespaceMap namespaceMap = that.namespaceBindings = nsBindingsOverride != null ? nsBindingsOverride.clone() : that.namespaceBindings.clone();
            if (varBindingsOverride == null) {
                that.bindings = new HashMap<QName, Object>(that.bindings);
            } else {
                that.bindings = new HashMap<QName, Object>();
                for (Map.Entry<QName, ?> entry : varBindingsOverride.entrySet()) {
                    that.let(entry.getKey(), entry.getValue());
                }
            }
            that.moduleMap = new TreeMap<String, Document>(this.moduleMap);
            return that;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }

    public ItemList all(String query, Object ... params) {
        return this.executeQuery(query, null, params);
    }

    public void run(String query, Object ... params) {
        this.executeQuery(query, null, params);
    }

    /*
     * Exception decompiling
     */
    ItemList executeQuery(String query, WrapperFactory wrapperFactory, Object[] params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CompiledXQuery wrap(CompiledXQuery expr, WrapperFactory wrapperFactory, XQueryContext context) throws XPathException {
        if (wrapperFactory == null) {
            return expr;
        }
        Function wrapper = wrapperFactory.createWrapper(context);
        wrapper.setArguments(Collections.singletonList((Expression)expr));
        return wrapper;
    }

    private Source buildQuerySource(String query, Object[] params, String cookie) {
        Map<String, String> combinedMap = this.namespaceBindings.getCombinedMap();
        for (Map.Entry<String, Document> entry : this.moduleMap.entrySet()) {
            combinedMap.put("<module> " + entry.getKey(), entry.getValue().path());
        }
        for (Map.Entry<Object, Object> entry : this.bindings.entrySet()) {
            combinedMap.put("<var> " + entry.getKey(), null);
        }
        combinedMap.put("<posvars> " + params.length, null);
        combinedMap.put("<cookie>", cookie);
        return new StringSourceWithMapKey(query, combinedMap);
    }

    private void buildXQueryDynamicContext(XQueryContext context, Object[] params, MutableDocumentSet docsToLock, boolean bindVariables) throws XPathException {
        context.setBackwardsCompatibility(false);
        context.setStaticallyKnownDocuments(this.docs);
        context.setBaseURI(this.baseUri == null ? new AnyURIValue("/db") : this.baseUri);
        if (bindVariables) {
            for (Map.Entry<QName, Object> entry : this.bindings.entrySet()) {
                context.declareVariable(new org.exist.dom.QName(entry.getKey().getLocalPart(), entry.getKey().getNamespaceURI(), entry.getKey().getPrefix()), this.convertValue(entry.getValue()));
            }
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    Object convertedValue = this.convertValue(params[i]);
                    if (docsToLock != null && convertedValue instanceof Sequence) {
                        docsToLock.addAll(((Sequence)convertedValue).getDocumentSet());
                    }
                    context.declareVariable("_" + (i + 1), convertedValue);
                }
            }
        }
    }

    private void buildXQueryStaticContext(XQueryContext context, boolean importModules) throws XPathException {
        context.declareNamespaces(this.namespaceBindings.getCombinedMap());
        for (Map.Entry<String, Document> entry : this.moduleMap.entrySet()) {
            context.importModule(entry.getKey(), null, "xmldb:exist:///db" + entry.getValue().path());
        }
    }

    private Object convertValue(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        if (o instanceof Resource) {
            try {
                return ((Resource)o).convertToSequence();
            }
            catch (UnsupportedOperationException e) {
                return o;
            }
        }
        ArrayList<Object> list = null;
        if (o instanceof Collection) {
            list = new ArrayList((Collection)o);
        } else if (o instanceof Object[]) {
            list = new ArrayList<Object>(Arrays.asList((Object[])o));
        }
        if (list != null) {
            ListIterator<Object> it = list.listIterator();
            while (it.hasNext()) {
                it.set(this.convertValue(it.next()));
            }
            return list;
        }
        return DataUtils.toXMLObject(o);
    }

    private String presub(String query, Object[] params) {
        if (params == null) {
            return query;
        }
        StringBuffer buf = new StringBuffer();
        Matcher matcher = PRE_SUB_PATTERN.matcher(query);
        while (matcher.find()) {
            matcher.appendReplacement(buf, ((String)params[Integer.parseInt(matcher.group(1)) - 1]).replace("\\", "\\\\").replace("$", "\\$"));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public ItemList unordered(String query, Object ... params) {
        return this.all(query, params);
    }

    public Item single(String query, Object ... params) {
        ItemList result = this.executeQuery(query, EXACTLY_ONE, params);
        assert (result.size() == 1) : "expected single result, got " + result.size();
        return result.get(0);
    }

    public Item optional(String query, Object ... params) {
        ItemList result = this.executeQuery(query, ZERO_OR_ONE, params);
        assert (result.size() <= 1) : "expected zero or one results, got " + result.size();
        return result.size() == 0 ? Item.NULL : result.get(0);
    }

    public boolean flag(String query, boolean defaultValue) {
        Item item = this.optional(query, new Object[0]);
        if (item != Item.NULL) {
            try {
                return item.booleanValue();
            }
            catch (Exception e) {
                LOG.error("illegal flag value '" + item + "' found for query " + query + "; using default '" + defaultValue + "'");
            }
        }
        return defaultValue;
    }

    public boolean exists(String query, Object ... params) {
        return this.executeQuery(query, EXISTS, params).get(0).booleanValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryAnalysis analyze(String query, Object ... params) {
        if (this.presub) {
            query = this.presub(query, params);
        }
        long t1 = System.currentTimeMillis();
        long t2 = 0L;
        long t3 = 0L;
        DBBroker broker = null;
        try {
            QueryAnalysis queryAnalysis;
            block14: {
                broker = this.db.acquireBroker();
                this.prepareContext(broker);
                Source source = this.buildQuerySource(query, params, "analyze");
                XQuery xquery = broker.getBrokerPool().getXQueryService();
                XQueryPool pool = broker.getBrokerPool().getXQueryPool();
                CompiledXQuery compiledQuery = pool.borrowCompiledXQuery(broker, source);
                try {
                    AnalysisXQueryContext context;
                    if (compiledQuery == null) {
                        context = new AnalysisXQueryContext(broker);
                        this.buildXQueryStaticContext(context, false);
                        this.buildXQueryDynamicContext(context, params, null, false);
                        t2 = System.currentTimeMillis();
                        compiledQuery = xquery.compile(broker, (XQueryContext)context, source);
                        t3 = System.currentTimeMillis();
                    } else {
                        context = (AnalysisXQueryContext)compiledQuery.getContext();
                        t2 = System.currentTimeMillis();
                    }
                    queryAnalysis = new QueryAnalysis(compiledQuery, Collections.unmodifiableSet(context.requiredVariables), Collections.unmodifiableSet(context.requiredFunctions));
                    if (compiledQuery == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (compiledQuery != null) {
                            compiledQuery.getContext().runCleanupTasks();
                            pool.returnCompiledXQuery(source, compiledQuery);
                        }
                        throw throwable;
                    }
                    catch (XPathException e) {
                        LOG.warn("query compilation failed --  " + query + "  -- " + (params == null ? "" : " with params " + Arrays.asList(params)) + (this.bindings.isEmpty() ? "" : " and bindings " + this.bindings));
                        throw new DatabaseException("failed to compile query", e);
                    }
                    catch (IOException e) {
                        throw new DatabaseException("unexpected exception", e);
                    }
                    catch (PermissionDeniedException e) {
                        throw new DatabaseException("permission denied", e);
                    }
                }
                compiledQuery.getContext().runCleanupTasks();
                pool.returnCompiledXQuery(source, compiledQuery);
            }
            return queryAnalysis;
        }
        finally {
            this.db.releaseBroker(broker);
            STATS.update(query, t1, t2, t3, 0L, System.currentTimeMillis());
        }
    }

    public static class Statistics {
        private static final NumberFormat COUNT_FORMAT = NumberFormat.getIntegerInstance();
        private static final MessageFormat FULL_ENTRY_FORMAT = new MessageFormat("{1} uses in {3,number,0.000}s ({11,number,percent}, {7,number,0.00}ms avg) [{4,number,0.000}s compiling ({8,number,0.00}ms avg, {2,number,percent} cache hits), {5,number,0.000}s preparing ({9,number,0.00}ms avg), {6,number,0.000}s executing ({10,number,0.00}ms avg)]: {0}");
        private static final MessageFormat STAND_ALONE_ENTRY_FORMAT = new MessageFormat("{1,number,integer} uses in {3,number,0.000}s ({7,number,0.00}ms avg) [{4,number,0.000}s compiling ({8,number,0.00}ms avg, {2,number,percent} cache hits), {5,number,0.000}s preparing ({9,number,0.00}ms avg), {6,number,0.000}s executing ({10,number,0.00}ms avg)]: {0}");
        private static final Comparator<Entry> TOTAL_TIME_DESCENDING = new Comparator<Entry>(){

            @Override
            public int compare(Entry e1, Entry e2) {
                return e1.queryTime == e2.queryTime ? 0 : (e1.queryTime > e2.queryTime ? -1 : 1);
            }
        };
        private final Map<String, Entry> entries = new HashMap<String, Entry>();

        void update(String query, long t1, long t2, long t3, long t4, long t5) {
            long tCompilation;
            long tQuery = t5 - t1;
            long tPreparation = t2 > 0L ? t2 - t1 : -1L;
            long l = tCompilation = t3 > 0L ? t3 - t2 : -1L;
            long tExecution = t4 > 0L ? t4 - (t3 > 0L ? t3 : t2) : -1L;
            this.get(null).update(tQuery, tPreparation, tCompilation, tExecution);
            this.get(query).update(tQuery, tPreparation, tCompilation, tExecution);
        }

        synchronized Entry get(String query) {
            Entry entry = this.entries.get(query);
            if (entry == null) {
                entry = new Entry(query);
                this.entries.put(query, entry);
            }
            return entry;
        }

        public synchronized List<Entry> entries() {
            return new ArrayList<Entry>(this.entries.values());
        }

        public Entry totals() {
            return this.get(null);
        }

        public synchronized void reset() {
            this.entries.clear();
        }

        public synchronized String toString() {
            return this.toStringTop(this.entries.size());
        }

        public synchronized String toStringTop(int n) {
            StringBuilder out = new StringBuilder();
            List<Entry> list = this.entries();
            if (list.isEmpty()) {
                return "<no queries executed>";
            }
            Collections.sort(list, TOTAL_TIME_DESCENDING);
            int maxCountLength = COUNT_FORMAT.format(list.get((int)0).numQueries).length();
            double totalDuration = list.get((int)0).queryTime;
            for (Entry entry : list.subList(0, Math.min(n, list.size()))) {
                out.append(entry.toString(maxCountLength, totalDuration)).append('\n');
            }
            return out.toString();
        }

        public static class Entry {
            public final String query;
            public long numQueries;
            public long queriesPrepared;
            public long queriesCompiled;
            public long queriesRun;
            public double queryTime;
            public double queryPreparationTime;
            public double queryCompilationTime;
            public double queryRunTime;

            Entry(String query) {
                this.query = query;
            }

            synchronized void update(long tQuery, long tPreparation, long tCompilation, long tRun) {
                ++this.numQueries;
                this.queryTime += (double)tQuery / 1000.0;
                if (tPreparation >= 0L) {
                    ++this.queriesPrepared;
                    this.queryPreparationTime += (double)tPreparation / 1000.0;
                }
                if (tCompilation >= 0L) {
                    ++this.queriesCompiled;
                    this.queryCompilationTime += (double)tCompilation / 1000.0;
                }
                if (tRun >= 0L) {
                    this.queryRunTime += (double)tRun / 1000.0;
                    ++this.queriesRun;
                }
            }

            public synchronized String toString(int maxCountLength, double totalDuration) {
                String formattedCount = String.format("%" + maxCountLength + "s", COUNT_FORMAT.format(this.numQueries));
                return FULL_ENTRY_FORMAT.format(new Object[]{this.query == null ? "TOTALS" : this.query, formattedCount, (double)(this.queriesPrepared - this.queriesCompiled) / (double)this.queriesPrepared, this.queryTime, this.queryCompilationTime, this.queryPreparationTime, this.queryRunTime, this.queryTime * 1000.0 / (double)this.numQueries, this.queriesCompiled == 0L ? 0.0 : this.queryCompilationTime * 1000.0 / (double)this.queriesCompiled, this.queriesPrepared == 0L ? 0.0 : this.queryPreparationTime * 1000.0 / (double)this.queriesPrepared, this.queriesRun == 0L ? 0.0 : this.queryRunTime * 1000.0 / (double)this.queriesRun, this.queryTime / totalDuration});
            }

            public synchronized String toString() {
                return STAND_ALONE_ENTRY_FORMAT.format(new Object[]{this.query == null ? "TOTALS" : this.query, this.numQueries, (double)(this.queriesPrepared - this.queriesCompiled) / (double)this.queriesPrepared, this.queryTime, this.queryCompilationTime, this.queryPreparationTime, this.queryRunTime, this.queryTime * 1000.0 / (double)this.numQueries, this.queriesCompiled == 0L ? 0.0 : this.queryCompilationTime * 1000.0 / (double)this.queriesCompiled, this.queriesPrepared == 0L ? 0.0 : this.queryPreparationTime * 1000.0 / (double)this.queriesPrepared, this.queriesRun == 0L ? 0.0 : this.queryRunTime * 1000.0 / (double)this.queriesRun});
            }
        }
    }

    public static class QueryAnalysis {
        private final CompiledXQuery query;
        private final Set<QName> requiredVariables;
        private final Set<QName> requiredFunctions;

        private QueryAnalysis(CompiledXQuery query, Set<QName> requiredVariables, Set<QName> requiredFunctions) {
            this.query = query;
            this.requiredVariables = requiredVariables;
            this.requiredFunctions = requiredFunctions;
        }

        public String returnTypeName() {
            return Type.getTypeName((int)(this.query instanceof Expression ? ((PathExpr)this.query).returnsType() : 11));
        }

        public Cardinality cardinality() {
            if (this.query instanceof Expression) {
                int cardinality = ((Expression)this.query).getCardinality();
                switch (cardinality) {
                    case 1: {
                        return Cardinality.ZERO;
                    }
                    case 2: {
                        return Cardinality.ONE;
                    }
                    case 3: {
                        return Cardinality.ZERO_OR_ONE;
                    }
                    case 7: {
                        return Cardinality.ZERO_OR_MORE;
                    }
                    case 6: {
                        return Cardinality.ONE_OR_MORE;
                    }
                }
                LOG.error("unexpected eXist cardinality flag " + cardinality);
            }
            return Cardinality.ZERO_OR_MORE;
        }

        public Set<QName> requiredVariables() {
            return this.requiredVariables;
        }

        public Set<QName> requiredFunctions() {
            return this.requiredFunctions;
        }

        public static enum Cardinality {
            ZERO,
            ZERO_OR_ONE,
            ONE,
            ZERO_OR_MORE,
            ONE_OR_MORE;

        }
    }

    private static final class AnalysisXQueryContext
    extends XQueryContext {
        final Set<QName> requiredFunctions = new TreeSet<QName>();
        final Set<QName> requiredVariables = new TreeSet<QName>();

        private AnalysisXQueryContext(DBBroker broker) {
            super((Database)broker.getBrokerPool());
        }

        public Variable resolveVariable(org.exist.dom.QName qname) throws XPathException {
            Variable var = super.resolveVariable(qname);
            if (var == null) {
                this.requiredVariables.add(new QName(qname.getNamespaceURI(), qname.getLocalPart(), qname.getPrefix()));
                var = new VariableImpl(qname);
            }
            return var;
        }

        public UserDefinedFunction resolveFunction(org.exist.dom.QName qname, int argCount) throws XPathException {
            UserDefinedFunction func = super.resolveFunction(qname, argCount);
            if (func == null) {
                this.requiredFunctions.add(new QName(qname.getNamespaceURI(), qname.getLocalPart(), qname.getPrefix()));
                func = new UserDefinedFunction((XQueryContext)this, new FunctionSignature(qname, null, new SequenceType(11, 7), true));
                func.setFunctionBody((Expression)new SequenceConstructor((XQueryContext)this));
            }
            return func;
        }
    }

    private static interface WrapperFactory {
        public Function createWrapper(XQueryContext var1);
    }
}

