/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import org.exist.fluent.Database;
import org.exist.fluent.NamespaceMap;
import org.exist.fluent.QueryService;
import org.exist.xquery.value.Sequence;

public abstract class Resource {
    protected final Database db;
    protected final NamespaceMap namespaceBindings;
    private QueryService query;

    protected Resource(NamespaceMap namespaceBindings, Database db) {
        this.db = db;
        this.namespaceBindings = namespaceBindings;
    }

    public QueryService query() {
        if (this.query == null || !this.query.isFreshFrom(this)) {
            this.query = this.createQueryService();
            if (this.query == null) {
                Sequence seq = this.convertToSequence();
                this.query = new QueryService(this, seq.getDocumentSet(), seq);
            }
        }
        return this.query;
    }

    public final NamespaceMap namespaceBindings() {
        return this.namespaceBindings;
    }

    public final Database database() {
        return new Database(this.db, this.namespaceBindings);
    }

    QueryService createQueryService() {
        return null;
    }

    abstract Sequence convertToSequence();
}

