/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import org.exist.dom.persistent.DocumentImpl;
import org.exist.fluent.Database;
import org.exist.fluent.DatabaseException;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;

class Transaction {
    private final TransactionManager txManager;
    final Txn tx;
    final DBBroker broker;
    private final Database db;
    private boolean complete;

    Transaction(TransactionManager txManager, Database db) {
        this.txManager = txManager;
        this.tx = txManager.beginTransaction();
        this.db = db;
        this.broker = db == null ? null : db.acquireBroker();
        this.complete = false;
    }

    Transaction(Transaction tx, Database db) {
        this.txManager = null;
        this.tx = tx.tx;
        this.db = db;
        this.broker = db == null ? null : db.acquireBroker();
        this.complete = true;
    }

    void commit() {
        block7: {
            if (this.complete) {
                return;
            }
            try {
                if (this.tx == null || this.txManager == null) break block7;
                try {
                    this.txManager.commit(this.tx);
                    this.complete = true;
                }
                catch (TransactionException e) {
                    throw new DatabaseException(e);
                }
            }
            finally {
                if (this.broker != null) {
                    this.db.releaseBroker(this.broker);
                }
            }
        }
    }

    void abortIfIncomplete() {
        if (this.complete) {
            return;
        }
        if (this.tx != null && this.txManager != null) {
            this.txManager.abort(this.tx);
        }
        if (this.broker != null) {
            this.db.releaseBroker(this.broker);
        }
        this.complete = true;
    }

    void lockWrite(DocumentImpl doc) {
        try {
            this.tx.acquireLock(doc.getUpdateLock(), Lock.LockMode.WRITE_LOCK);
        }
        catch (LockException e) {
            throw new DatabaseException(e);
        }
    }

    void lockRead(DocumentImpl doc) {
        try {
            this.tx.acquireLock(doc.getUpdateLock(), Lock.LockMode.READ_LOCK);
        }
        catch (LockException e) {
            throw new DatabaseException(e);
        }
    }
}

