/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.exist.security.internal.aider.UnixStylePermissionAider;
import org.exist.util.SyntaxException;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public abstract class AbstractXMLDBTask
extends Task {
    protected String driver = "org.exist.xmldb.DatabaseImpl";
    protected String user = "guest";
    protected String password = "guest";
    protected String uri = null;
    protected boolean ssl = false;
    protected boolean createDatabase = false;
    protected String configuration = null;
    protected boolean failonerror = true;
    protected String permissions = null;
    private final String UNIX_PERMS_REGEX = "([r-][w-][x-]){3}";

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setInitdb(boolean create) {
        this.createDatabase = create;
    }

    public void setConfiguration(String config) {
        this.configuration = config;
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    protected void registerDatabase() throws BuildException {
        try {
            Database[] allDataBases;
            this.log("Registering database", 4);
            for (Database database : allDataBases = DatabaseManager.getDatabases()) {
                if (!database.acceptsURI(this.uri)) continue;
                return;
            }
            Class<?> clazz = Class.forName(this.driver);
            Database database = (Database)clazz.newInstance();
            database.setProperty("create-database", this.createDatabase ? "true" : "false");
            database.setProperty("ssl-enable", this.ssl ? "true" : "false");
            if (this.configuration != null) {
                database.setProperty("configuration", this.configuration);
            }
            DatabaseManager.registerDatabase((Database)database);
            this.log("Database driver registered.");
        }
        catch (Exception e) {
            throw new BuildException("failed to initialize XMLDB database driver", (Throwable)e);
        }
    }

    protected final Collection mkcol(Collection rootCollection, String baseURI, String path, String relPath) throws XMLDBException {
        Collection current = rootCollection;
        StringTokenizer tokenizer = new StringTokenizer(relPath, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            path = path != null ? path + "/" + token : "/" + token;
            this.log("Get collection " + baseURI + path, 4);
            Collection collection = DatabaseManager.getCollection((String)(baseURI + path), (String)this.user, (String)this.password);
            if (collection == null) {
                this.log("Create collection management service for collection " + current.getName(), 4);
                CollectionManagementService mgtService = (CollectionManagementService)current.getService("CollectionManagementService", "1.0");
                this.log("Create child collection " + token, 4);
                current = mgtService.createCollection(token);
                this.log("Created collection " + current.getName() + '.', 4);
                continue;
            }
            current = collection;
        }
        return current;
    }

    protected final void setPermissions(Resource res) throws BuildException {
        Collection base = null;
        UserManagementService service = null;
        if (this.uri == null) {
            throw new BuildException("you have to specify an XMLDB collection URI");
        }
        try {
            this.log("Get base collection: " + this.uri, 4);
            base = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            if (base == null) {
                String msg = "Collection " + this.uri + " could not be found.";
                if (this.failonerror) {
                    throw new BuildException(msg);
                }
                this.log(msg, 0);
            } else {
                service = (UserManagementService)base.getService("UserManagementService", "1.0");
                this.setPermissions(res, service);
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    protected final void setPermissions(Collection col) throws BuildException {
        try {
            if (this.permissions != null) {
                this.setPermissions(null, (UserManagementService)col.getService("UserManagementService", "1.0"));
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    protected final void setPermissions(Resource res, UserManagementService service) throws BuildException {
        try {
            if (this.permissions != null) {
                if (this.permissions.matches("([r-][w-][x-]){3}")) {
                    UnixStylePermissionAider perm = UnixStylePermissionAider.fromString((String)this.permissions);
                    if (res != null) {
                        service.chmod(res, perm.getMode());
                    } else {
                        service.chmod(perm.getMode());
                    }
                } else if (res != null) {
                    service.chmod(res, this.permissions);
                } else {
                    service.chmod(this.permissions);
                }
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
        catch (SyntaxException e) {
            String msg = "Syntax error in permissions: " + this.permissions;
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }
}

