/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.UserTask;
import org.exist.security.Account;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class ChownTask
extends UserTask {
    private String name = null;
    private String group = null;
    private String resource = null;

    @Override
    public void execute() throws BuildException {
        super.execute();
        if (this.name == null || this.group == null) {
            throw new BuildException("Must specify user and group");
        }
        try {
            Account usr = this.service.getAccount(this.name);
            if (this.resource != null) {
                Resource res = this.base.getResource(this.resource);
                this.service.chown(res, usr, this.group);
            } else {
                this.service.chown(usr, this.group);
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    public void setName(String user) {
        this.name = user;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

