/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.UserTask;
import org.xmldb.api.base.XMLDBException;

public class ListGroupsTask
extends UserTask {
    private String outputproperty = null;
    private String separator = ",";

    @Override
    public void execute() throws BuildException {
        super.execute();
        try {
            this.log("Listing all groups", 4);
            String[] groups = this.service.getGroups();
            if (groups != null) {
                boolean isFirst = true;
                StringBuilder buffer = new StringBuilder();
                for (String group : groups) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        buffer.append(this.separator);
                    }
                    buffer.append(group);
                }
                if (buffer.length() > 0) {
                    this.log("Setting output property " + this.outputproperty + " to " + buffer.toString(), 4);
                    this.getProject().setNewProperty(this.outputproperty, buffer.toString());
                }
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    public void setOutputproperty(String outputproperty) {
        this.outputproperty = outputproperty;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

