/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import java.net.URISyntaxException;
import org.apache.tools.ant.BuildException;
import org.exist.ant.AbstractXMLDBTask;
import org.exist.xmldb.EXistCollectionManagementService;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBCopyTask
extends AbstractXMLDBTask {
    private String resource = null;
    private String collection = null;
    private String destination = null;
    private String name = null;

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("You have to specify an XMLDB collection URI");
        }
        if (this.resource == null && this.collection == null) {
            throw new BuildException("Missing parameter: either resource or collection should be specified");
        }
        this.registerDatabase();
        try {
            this.log("Get base collection: " + this.uri, 4);
            Collection base = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            if (base == null) {
                String msg = "Collection " + this.uri + " could not be found.";
                if (this.failonerror) {
                    throw new BuildException(msg);
                }
                this.log(msg, 0);
            } else {
                this.log("Create collection management service for collection " + base.getName(), 4);
                EXistCollectionManagementService service = (EXistCollectionManagementService)base.getService("CollectionManagementService", "1.0");
                if (this.resource != null) {
                    this.log("Copying resource: " + this.resource, 2);
                    Resource res = base.getResource(this.resource);
                    if (res == null) {
                        String msg = "Resource " + this.resource + " not found.";
                        if (this.failonerror) {
                            throw new BuildException(msg);
                        }
                        this.log(msg, 0);
                    } else {
                        service.copyResource(XmldbURI.xmldbUriFor((String)this.resource), XmldbURI.xmldbUriFor((String)this.destination), XmldbURI.xmldbUriFor((String)this.name));
                    }
                } else {
                    this.log("Copying collection: " + this.collection, 2);
                    service.copy(XmldbURI.xmldbUriFor((String)this.collection), XmldbURI.xmldbUriFor((String)this.destination), XmldbURI.xmldbUriFor((String)this.name));
                }
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception during copy: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
        catch (URISyntaxException e) {
            String msg = "URI syntax exception: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setName(String name) {
        this.name = name;
    }
}

