/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.exist.ant.AbstractXMLDBTask;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.ExtendedResource;
import org.xml.sax.ContentHandler;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class XMLDBExtractTask
extends AbstractXMLDBTask {
    private String resource = null;
    private File destFile = null;
    private File destDir = null;
    private boolean createdirectories = false;
    private boolean subcollections = false;
    private boolean overwrite = false;

    public void execute() throws BuildException {
        if (this.uri == null) {
            if (this.failonerror) {
                throw new BuildException("You need to specify an XMLDB collection URI");
            }
        } else {
            this.registerDatabase();
            try {
                Collection base = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
                if (base == null) {
                    throw new BuildException("Collection " + this.uri + " could not be found.");
                }
                if (this.resource != null && this.destDir == null) {
                    this.log("Extracting resource: " + this.resource + " to " + this.destFile.getAbsolutePath(), 2);
                    Resource res = base.getResource(this.resource);
                    if (res == null) {
                        String msg = "Resource " + this.resource + " not found.";
                        if (this.failonerror) {
                            throw new BuildException(msg);
                        }
                        this.log(msg, 0);
                    } else {
                        this.writeResource(res, this.destFile);
                    }
                } else {
                    this.extractResources(base, null);
                    if (this.subcollections) {
                        this.extractSubCollections(base, null);
                    }
                }
            }
            catch (XMLDBException e) {
                String msg = "XMLDB exception caught while executing query: " + e.getMessage();
                if (this.failonerror) {
                    throw new BuildException(msg, (Throwable)e);
                }
                this.log(msg, e, 0);
            }
            catch (IOException e) {
                String msg = "XMLDB exception caught while writing destination file: " + e.getMessage();
                if (this.failonerror) {
                    throw new BuildException(msg, (Throwable)e);
                }
                this.log(msg, e, 0);
            }
        }
    }

    private void extractResources(Collection base, String path) throws XMLDBException, IOException {
        String[] resources = base.listResources();
        if (resources != null) {
            File dir = this.destDir;
            this.log("Extracting to directory " + this.destDir.getAbsolutePath(), 4);
            if (path != null) {
                dir = new File(this.destDir, path);
            }
            for (String resource : resources) {
                Resource res = base.getResource(resource);
                this.log("Extracting resource: " + res.getId(), 4);
                if (!dir.exists() && this.createdirectories) {
                    dir.mkdirs();
                }
                if (!dir.exists()) continue;
                this.writeResource(res, dir);
            }
        }
    }

    private void extractSubCollections(Collection base, String path) throws XMLDBException, IOException {
        String[] childCols = base.listChildCollections();
        if (childCols != null) {
            for (String childCol : childCols) {
                String subdir;
                Collection col = base.getChildCollection(childCol);
                if (col == null) continue;
                this.log("Extracting collection: " + col.getName(), 4);
                File dir = this.destDir;
                if (path != null) {
                    dir = new File(this.destDir, path + File.separator + childCol);
                    subdir = path + File.separator + childCol;
                } else {
                    subdir = childCol;
                }
                if (!dir.exists() && this.createdirectories) {
                    dir.mkdirs();
                }
                this.extractResources(col, subdir);
                if (!this.subcollections) continue;
                this.extractSubCollections(col, subdir);
            }
        }
    }

    private void writeResource(Resource res, File dest) throws XMLDBException, IOException {
        if (res instanceof XMLResource) {
            this.writeXMLResource((XMLResource)res, dest);
        } else if (res instanceof ExtendedResource) {
            this.writeBinaryResource(res, dest);
        }
    }

    private void writeXMLResource(XMLResource res, File dest) throws IOException, XMLDBException {
        File parentDir;
        if (this.createdirectories && !(parentDir = new File(dest.getParent())).exists()) {
            parentDir.mkdirs();
        }
        if (dest != null || this.overwrite) {
            OutputStreamWriter writer;
            Properties outputProperties = new Properties();
            outputProperties.setProperty("indent", "yes");
            SAXSerializer serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            if (dest.isDirectory()) {
                String fname = res.getId();
                File file = new File(dest, fname);
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            } else {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dest), StandardCharsets.UTF_8);
            }
            this.log("Writing resource " + res.getId() + " to destination " + dest.getAbsolutePath(), 4);
            serializer.setOutput((Writer)writer, outputProperties);
            res.getContentAsSAX((ContentHandler)serializer);
            SerializerPool.getInstance().returnObject((Object)serializer);
            ((Writer)writer).close();
        } else {
            String msg = "Destination xml file " + (dest != null ? dest.getAbsolutePath() + " " : "") + "exists. Use overwrite property to overwrite this file.";
            if (this.failonerror) {
                throw new BuildException(msg);
            }
            this.log(msg, 0);
        }
    }

    private void writeBinaryResource(Resource res, File dest) throws XMLDBException, IOException {
        File parentDir;
        if (this.createdirectories && !(parentDir = new File(dest.getParent())).exists()) {
            parentDir.mkdirs();
        }
        if (dest != null || this.overwrite) {
            if (dest.isDirectory()) {
                String fname = res.getId();
                dest = new File(dest, fname);
            }
            FileOutputStream os = new FileOutputStream(dest);
            ((ExtendedResource)res).getContentIntoAStream((OutputStream)os);
        } else {
            String msg = "Dest binary file " + (dest != null ? dest.getAbsolutePath() + " " : "") + "exists. Use overwrite property to overwrite file.";
            if (this.failonerror) {
                throw new BuildException(msg);
            }
            this.log(msg, 0);
        }
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    @Deprecated
    public void setType(String type) {
    }

    public void setCreatedirectories(boolean createdirectories) {
        this.createdirectories = createdirectories;
    }

    public void setSubcollections(boolean subcollections) {
        this.subcollections = subcollections;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

