/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.AbstractXMLDBTask;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBListTask
extends AbstractXMLDBTask {
    private boolean hasCollections = false;
    private boolean hasResources = false;
    private String separator = ",";
    private String outputproperty;

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("You have to specify an XMLDB collection URI");
        }
        if (!this.hasCollections && !this.hasResources) {
            throw new BuildException("You have at least one of collections or resources or both");
        }
        this.registerDatabase();
        try {
            boolean isFirst;
            String[] childCollections;
            this.log("Get base collection: " + this.uri, 4);
            Collection base = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            if (base == null) {
                String msg = "Collection " + this.uri + " could not be found.";
                if (this.failonerror) {
                    throw new BuildException(msg);
                }
                this.log(msg, 0);
            }
            StringBuilder buffer = new StringBuilder();
            if (this.hasCollections && (childCollections = base.listChildCollections()) != null) {
                this.log("Listing child collections", 4);
                isFirst = true;
                for (String col : childCollections) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        buffer.append(this.separator);
                    }
                    buffer.append(col);
                }
            }
            if (this.hasResources) {
                this.log("Listing resources", 4);
                String[] resources = base.listResources();
                if (resources != null) {
                    if (buffer.length() > 0) {
                        buffer.append(this.separator);
                    }
                    isFirst = true;
                    for (String resource : resources) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            buffer.append(this.separator);
                        }
                        buffer.append(resource);
                    }
                }
            }
            if (buffer.length() > 0) {
                this.log("Set property " + this.outputproperty, 2);
                this.getProject().setNewProperty(this.outputproperty, buffer.toString());
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception during list: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    public void setCollections(boolean collections) {
        this.hasCollections = collections;
    }

    public void setResources(boolean resources) {
        this.hasResources = resources;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setOutputproperty(String outputproperty) {
        this.outputproperty = outputproperty;
    }
}

