/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.exist.ant.AbstractXMLDBTask;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XPathQueryService;

public class XMLDBQueryTask
extends AbstractXMLDBTask {
    private String query = null;
    private String text = null;

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("you have to specify an XMLDB collection URI");
        }
        if (this.text != null) {
            PropertyHelper helper = PropertyHelper.getPropertyHelper((Project)this.getProject());
            this.query = helper.replaceProperties(null, this.text, null);
        }
        if (this.query == null) {
            throw new BuildException("you have to specify a query");
        }
        this.log("XQuery is:\n" + this.query, 4);
        this.registerDatabase();
        try {
            Collection collection = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            if (collection == null) {
                String msg = "Collection " + this.uri + " could not be found.";
                if (this.failonerror) {
                    throw new BuildException(msg);
                }
                this.log(msg, 0);
            } else {
                XPathQueryService service = (XPathQueryService)collection.getService("XPathQueryService", "1.0");
                ResourceSet results = service.query(this.query);
                this.log("Found " + results.getSize());
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught while executing query: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void addText(String text) {
        this.text = text;
    }
}

