/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.exist.ant.AbstractXMLDBTask;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.EXistResource;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBStoreTask
extends AbstractXMLDBTask {
    private File mimeTypesFile = null;
    private File srcFile = null;
    private String targetFile = null;
    private ArrayList<FileSet> fileSetList = null;
    private boolean createCollection = false;
    private boolean createSubcollections = false;
    private boolean includeEmptyDirs = true;
    private String type = null;
    private String defaultMimeType = null;
    private String forceMimeType = null;
    private MimeTable mtable = null;

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("you have to specify an XMLDB collection URI");
        }
        if (this.fileSetList == null && this.srcFile == null) {
            throw new BuildException("no file set specified");
        }
        this.registerDatabase();
        int p = this.uri.indexOf("/db");
        if (p == -1) {
            throw new BuildException("invalid uri: '" + this.uri + "'");
        }
        String baseURI = this.uri.substring(0, p);
        String path = p == this.uri.length() - 3 ? "" : this.uri.substring(p + 3);
        Collection root = null;
        try {
            if (this.createCollection) {
                root = DatabaseManager.getCollection((String)(baseURI + "/db"), (String)this.user, (String)this.password);
                root = this.mkcol(root, baseURI, "/db", path);
            } else {
                root = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
            return;
        }
        if (root == null) {
            String msg = "Collection " + this.uri + " could not be found.";
            if (this.failonerror) {
                throw new BuildException(msg);
            }
            this.log(msg, 0);
        } else {
            Collection col = root;
            String prevDir = null;
            if (this.srcFile != null) {
                String resourceType;
                this.log("Storing " + this.srcFile.getName());
                MimeType mime = this.getMimeTable().getContentTypeFor(this.srcFile.getName());
                String baseMimeType = this.forceMimeType != null ? this.forceMimeType : (mime != null ? mime.getName() : this.defaultMimeType);
                if (this.type != null) {
                    if ("xml".equals(this.type)) {
                        mime = baseMimeType != null ? new MimeType(baseMimeType, 0) : MimeType.XML_TYPE;
                    } else if ("binary".equals(this.type)) {
                        MimeType mimeType = mime = baseMimeType != null ? new MimeType(baseMimeType, 1) : MimeType.BINARY_TYPE;
                    }
                }
                if (mime == null) {
                    String msg = "Cannot guess mime-type kind for " + this.srcFile.getName() + ". Treating it as a binary.";
                    this.log(msg, 0);
                    mime = baseMimeType != null ? new MimeType(baseMimeType, 1) : MimeType.BINARY_TYPE;
                }
                String string = resourceType = mime.isXMLType() ? "XMLResource" : "BinaryResource";
                if (this.targetFile == null) {
                    this.targetFile = this.srcFile.getName();
                }
                try {
                    this.log("Creating resource " + this.targetFile + " in collection " + col.getName() + " of type " + resourceType + " with mime-type: " + mime.getName(), 4);
                    Resource res = col.createResource(this.targetFile, resourceType);
                    if (this.srcFile.length() != 0L) {
                        res.setContent((Object)this.srcFile);
                        ((EXistResource)res).setMimeType(mime.getName());
                        col.storeResource(res);
                    }
                    if (this.permissions != null) {
                        this.setPermissions(res);
                    }
                }
                catch (XMLDBException e) {
                    String msg = "XMLDB exception caught: " + e.getMessage();
                    if (this.failonerror) {
                        throw new BuildException(msg, (Throwable)e);
                    }
                    this.log(msg, e, 0);
                }
            } else {
                for (FileSet fileSet : this.fileSetList) {
                    String msg;
                    String relDir;
                    this.log("Storing fileset", 4);
                    DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                    scanner.scan();
                    String[] includedFiles = scanner.getIncludedFiles();
                    String[] includedDirs = scanner.getIncludedDirectories();
                    this.log("Found " + includedDirs.length + " directories and " + includedFiles.length + " files.\n");
                    File baseDir = scanner.getBasedir();
                    if (this.includeEmptyDirs && this.createSubcollections) {
                        for (String included : includedDirs) {
                            try {
                                this.log("Creating " + included + " ...\n");
                                p = included.lastIndexOf(File.separatorChar);
                                if (p != -1) {
                                    relDir = included.substring(0, p);
                                    relDir = relDir.replace(File.separatorChar, '/');
                                    if (!this.createSubcollections || prevDir != null && relDir.equals(prevDir)) continue;
                                    col = this.mkcol(root, baseURI, "/db" + path, relDir);
                                    prevDir = relDir;
                                    continue;
                                }
                                col = this.mkcol(root, baseURI, "/db" + path, included);
                            }
                            catch (XMLDBException e) {
                                msg = "XMLDB exception caught: " + e.getMessage();
                                if (this.failonerror) {
                                    throw new BuildException(msg, (Throwable)e);
                                }
                                this.log(msg, e, 0);
                            }
                        }
                    }
                    for (String included : includedFiles) {
                        try {
                            File file = new File(baseDir, included);
                            this.log("Storing " + included + " ...\n");
                            p = included.lastIndexOf(File.separatorChar);
                            if (p != -1) {
                                relDir = included.substring(0, p);
                                relDir = relDir.replace(File.separatorChar, '/');
                                if (this.createSubcollections && (prevDir == null || !relDir.equals(prevDir))) {
                                    col = this.mkcol(root, baseURI, "/db" + path, relDir);
                                    prevDir = relDir;
                                }
                            } else {
                                col = root;
                            }
                            MimeType currentMime = this.getMimeTable().getContentTypeFor(file.getName());
                            String currentBaseMimeType = this.forceMimeType != null ? this.forceMimeType : (currentMime != null ? currentMime.getName() : this.defaultMimeType);
                            if (this.type != null) {
                                if ("xml".equals(this.type)) {
                                    currentMime = currentBaseMimeType != null ? new MimeType(currentBaseMimeType, 0) : MimeType.XML_TYPE;
                                } else if ("binary".equals(this.type)) {
                                    MimeType mimeType = currentMime = currentBaseMimeType != null ? new MimeType(currentBaseMimeType, 1) : MimeType.BINARY_TYPE;
                                }
                            }
                            if (currentMime == null) {
                                String msg2 = "Cannot find mime-type kind for " + file.getName() + ". Treating it as a binary.";
                                this.log(msg2, 0);
                                currentMime = currentBaseMimeType != null ? new MimeType(currentBaseMimeType, 1) : MimeType.BINARY_TYPE;
                            }
                            String resourceType = currentMime.isXMLType() ? "XMLResource" : "BinaryResource";
                            this.log("Creating resource " + file.getName() + " in collection " + col.getName() + " of type " + resourceType + " with mime-type: " + currentMime.getName(), 4);
                            Resource res = col.createResource(file.getName(), resourceType);
                            res.setContent((Object)file);
                            ((EXistResource)res).setMimeType(currentMime.getName());
                            col.storeResource(res);
                            if (this.permissions == null) continue;
                            this.setPermissions(res);
                        }
                        catch (XMLDBException e) {
                            msg = "XMLDB exception caught: " + e.getMessage();
                            if (this.failonerror) {
                                throw new BuildException(msg, (Throwable)e);
                            }
                            this.log(msg, e, 0);
                        }
                    }
                }
            }
        }
    }

    public void addFileset(FileSet set) {
        if (this.fileSetList == null) {
            this.fileSetList = new ArrayList();
        }
        this.fileSetList.add(set);
    }

    public void setSrcFile(File file) {
        this.srcFile = file;
    }

    public void setTargetFile(String name) {
        this.targetFile = name;
    }

    public void setCreatecollection(boolean create) {
        this.createCollection = create;
    }

    public void setCreatesubcollections(boolean create) {
        this.createSubcollections = create;
    }

    public void setIncludeEmptyDirs(boolean create) {
        this.includeEmptyDirs = create;
    }

    public void setMimeTypesFile(File file) {
        this.mimeTypesFile = file;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDefaultMimeType(String mimeType) {
        this.defaultMimeType = mimeType;
    }

    public void setForceMimeType(String mimeType) {
        this.forceMimeType = mimeType;
    }

    private MimeTable getMimeTable() throws BuildException {
        if (this.mtable == null) {
            if (this.mimeTypesFile != null && this.mimeTypesFile.exists()) {
                this.log("Trying to use MIME Types file " + this.mimeTypesFile.getAbsolutePath(), 4);
                this.mtable = MimeTable.getInstance((Path)this.mimeTypesFile.toPath());
            } else {
                this.log("Using default MIME Types resources", 4);
                this.mtable = MimeTable.getInstance();
            }
        }
        return this.mtable;
    }
}

