/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.AbstractXMLDBTask;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XUpdateQueryService;

public class XMLDBXUpdateTask
extends AbstractXMLDBTask {
    private String resource = null;
    private String commands = null;

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("You have to specify an XMLDB collection URI");
        }
        this.log("XUpdate command is: " + this.commands, 4);
        this.registerDatabase();
        try {
            this.log("Get base collection: " + this.uri, 4);
            Collection base = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            if (base == null) {
                String msg = "Collection " + this.uri + " could not be found.";
                if (this.failonerror) {
                    throw new BuildException(msg);
                }
                this.log(msg, 0);
            } else {
                XUpdateQueryService service = (XUpdateQueryService)base.getService("XUpdateQueryService", "1.0");
                if (this.resource != null) {
                    this.log("Updating resource: " + this.resource, 2);
                    Resource res = base.getResource(this.resource);
                    if (res == null) {
                        String msg = "Resource " + this.resource + " not found.";
                        if (this.failonerror) {
                            throw new BuildException(msg);
                        }
                        this.log(msg, 0);
                    } else {
                        service.updateResource(this.resource, this.commands);
                    }
                } else {
                    this.log("Updating collection: " + base.getName(), 2);
                    service.update(this.commands);
                }
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception during XUpdate: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setCommands(String commands) {
        this.commands = commands;
    }
}

