/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http;

import java.util.Optional;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.Subject;
import org.exist.source.DBSource;
import org.exist.source.Source;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Sequence;

public class AuditTrailSessionListener
implements HttpSessionListener {
    private static final Logger LOG = LogManager.getLogger(AuditTrailSessionListener.class);
    public static final String REGISTER_CREATE_XQUERY_SCRIPT_PROPERTY = "org.exist.http.session_create_listener";
    public static final String REGISTER_DESTROY_XQUERY_SCRIPT_PROPERTY = "org.exist.http.session_destroy_listener";

    public void sessionCreated(HttpSessionEvent sessionEvent) {
        HttpSession session = sessionEvent.getSession();
        LOG.info("Session created " + session.getId());
        String xqueryResourcePath = System.getProperty(REGISTER_CREATE_XQUERY_SCRIPT_PROPERTY);
        this.executeXQuery(xqueryResourcePath);
    }

    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        HttpSession session;
        HttpSession httpSession = session = sessionEvent != null ? sessionEvent.getSession() : null;
        if (session != null) {
            LOG.info("Destroyed session " + session.getId());
        } else {
            LOG.info("Destroyed session");
        }
        String xqueryResourcePath = System.getProperty(REGISTER_DESTROY_XQUERY_SCRIPT_PROPERTY);
        this.executeXQuery(xqueryResourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeXQuery(String xqueryResourcePath) {
        if (xqueryResourcePath == null) return;
        if (xqueryResourcePath.length() <= 0) return;
        xqueryResourcePath = xqueryResourcePath.trim();
        try {
            BrokerPool pool = BrokerPool.getInstance();
            Subject sysSubject = pool.getSecurityManager().getSystemSubject();
            DocumentImpl resource = null;
            try (DBBroker broker = pool.get(Optional.of(sysSubject));){
                if (broker == null) {
                    LOG.error("Unable to retrieve DBBroker for " + sysSubject.getName());
                    return;
                }
                XmldbURI pathUri = XmldbURI.create((String)xqueryResourcePath);
                resource = broker.getXMLResource(pathUri, Lock.LockMode.READ_LOCK);
                if (resource == null) {
                    LOG.error("Resource [" + xqueryResourcePath + "] does not exist.");
                    return;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Resource [" + xqueryResourcePath + "] exists.");
                }
                DBSource source = new DBSource(broker, (BinaryDocument)resource, true);
                XQuery xquery = pool.getXQueryService();
                if (xquery == null) {
                    LOG.error("broker unable to retrieve XQueryService");
                    return;
                }
                XQueryPool xqpool = pool.getXQueryPool();
                CompiledXQuery compiled = xqpool.borrowCompiledXQuery(broker, (Source)source);
                XQueryContext context = compiled == null ? new XQueryContext((Database)broker.getBrokerPool()) : compiled.getContext();
                context.setStaticallyKnownDocuments(new XmldbURI[]{pathUri});
                context.setBaseURI(new AnyURIValue(pathUri.toString()));
                if (compiled == null) {
                    compiled = xquery.compile(broker, context, (Source)source);
                } else {
                    compiled.getContext().updateContext(context);
                    context.getWatchDog().reset();
                }
                Properties outputProperties = new Properties();
                try {
                    long startTime = System.currentTimeMillis();
                    Sequence result = xquery.execute(broker, compiled, null, outputProperties);
                    long queryTime = System.currentTimeMillis() - startTime;
                    if (!LOG.isTraceEnabled()) return;
                    LOG.trace("XQuery execution results: " + result.toString() + " in " + queryTime + "ms.");
                    return;
                }
                finally {
                    context.runCleanupTasks();
                    xqpool.returnCompiledXQuery((Source)source, compiled);
                }
            }
            finally {
                if (resource != null) {
                    resource.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception while executing [" + xqueryResourcePath + "] script", (Throwable)e);
        }
    }
}

