/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.SAXAdapter;
import org.exist.util.ConfigurationHelper;
import org.exist.util.SingleInstanceConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class Descriptor
implements ErrorHandler {
    private static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    private static Descriptor singletonRef;
    private static final Logger LOG;
    private static final String file = "descriptor.xml";
    private BufferedWriter bufWriteReplayLog = null;
    private boolean requestsFiltered = false;
    private String[] allowSourceList = null;
    private String[][] mapList = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Descriptor() {
        InputStream is = null;
        try {
            NodeList maps;
            NodeList allowsourcexqueries;
            Path f = ConfigurationHelper.lookup((String)file);
            if (!Files.isReadable(f)) {
                LOG.warn("Giving up unable to read descriptor file from " + f);
            } else {
                is = Files.newInputStream(f, new OpenOption[0]);
                LOG.info("Reading Descriptor from file " + f);
            }
            if (is == null) {
                is = Descriptor.class.getResourceAsStream(file);
                if (is != null) {
                    LOG.info("Reading Descriptor from classloader in " + this.getClass().getPackage());
                } else {
                    LOG.warn("Giving up unable to read descriptor.xml file from classloader in " + this.getClass().getPackage());
                    return;
                }
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            InputSource src = new InputSource(is);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            SAXAdapter adapter = new SAXAdapter();
            reader.setContentHandler((ContentHandler)adapter);
            reader.parse(src);
            DocumentImpl doc = adapter.getDocument();
            if ("true".equals(doc.getDocumentElement().getAttribute("request-replay-log"))) {
                Path logFile = Paths.get("request-replay-log.txt", new String[0]);
                this.bufWriteReplayLog = Files.newBufferedWriter(logFile, new OpenOption[0]);
                String attr = doc.getDocumentElement().getAttribute("filtered");
                if (attr != null) {
                    this.requestsFiltered = "true".equals(attr);
                }
            }
            if ((allowsourcexqueries = doc.getElementsByTagName("allow-source")).getLength() > 0) {
                this.configureAllowSourceXQuery((Element)allowsourcexqueries.item(0));
            }
            if ((maps = doc.getElementsByTagName("maps")).getLength() > 0) {
                this.configureMaps((Element)maps.item(0));
            }
        }
        catch (SAXException e) {
            LOG.warn("Error while reading descriptor file: descriptor.xml", (Throwable)e);
            return;
        }
        catch (ParserConfigurationException cfg) {
            LOG.warn("Error while reading descriptor file: descriptor.xml", (Throwable)cfg);
            return;
        }
        catch (IOException io) {
            LOG.warn("Error while reading descriptor file: descriptor.xml", (Throwable)io);
            return;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)ioe);
                }
            }
        }
    }

    public static synchronized Descriptor getDescriptorSingleton() {
        if (singletonRef == null) {
            singletonRef = new Descriptor();
        }
        return singletonRef;
    }

    private void configureAllowSourceXQuery(Element allowsourcexqueries) {
        NodeList nlXQuery = allowsourcexqueries.getElementsByTagName("xquery");
        this.allowSourceList = new String[nlXQuery.getLength()];
        Element elem = null;
        for (int i = 0; i < nlXQuery.getLength(); ++i) {
            elem = (Element)nlXQuery.item(i);
            String path = elem.getAttribute("path");
            if (path == null) {
                LOG.warn("Error element 'xquery' requires an attribute 'path'");
                return;
            }
            this.allowSourceList[i] = path = path.replaceAll("\\$\\{WEBAPP_HOME\\}", SingleInstanceConfiguration.getWebappHome().orElse(Paths.get(".", new String[0])).toAbsolutePath().toString().replace('\\', '/'));
        }
    }

    private void configureMaps(Element maps) {
        NodeList nlMap = maps.getElementsByTagName("map");
        this.mapList = new String[nlMap.getLength()][2];
        Element elem = null;
        for (int i = 0; i < nlMap.getLength(); ++i) {
            elem = (Element)nlMap.item(i);
            String path = elem.getAttribute("path");
            String view = elem.getAttribute("view");
            if (path == null) {
                LOG.warn("Error element 'map' requires an attribute 'path' or an attribute 'pattern'");
                return;
            }
            path = path.replaceAll("\\$\\{WEBAPP_HOME\\}", SingleInstanceConfiguration.getWebappHome().orElse(Paths.get(".", new String[0])).toAbsolutePath().toString().replace('\\', '/'));
            if (view == null) {
                LOG.warn("Error element 'map' requires an attribute 'view'");
                return;
            }
            view = view.replaceAll("\\$\\{WEBAPP_HOME\\}", SingleInstanceConfiguration.getWebappHome().orElse(Paths.get(".", new String[0])).toAbsolutePath().toString().replace('\\', '/'));
            this.mapList[i][0] = path;
            this.mapList[i][1] = view;
        }
    }

    public boolean allowSource(String path) {
        if (this.allowSourceList != null) {
            for (int i = 0; i < this.allowSourceList.length; ++i) {
                if (!this.allowSourceList[i].equals(path = path.replace('\\', '/')) && path.indexOf(this.allowSourceList[i]) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    public String mapPath(String path) {
        if (this.mapList == null) {
            return path;
        }
        for (int i = 0; i < this.mapList.length; ++i) {
            if (!this.mapList[i][0].equals(path) && !(this.mapList[i][0] + "/").equals(path)) continue;
            return this.mapList[i][1];
        }
        return path;
    }

    public boolean requestsFiltered() {
        return this.requestsFiltered;
    }

    public boolean allowRequestLogging() {
        return this.bufWriteReplayLog != null;
    }

    public synchronized void doLogRequestInReplayLog(HttpServletRequest request) {
        if (this.bufWriteReplayLog == null) {
            return;
        }
        try {
            this.bufWriteReplayLog.write("Date: ");
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            this.bufWriteReplayLog.write(formatter.format(new Date()));
            this.bufWriteReplayLog.write(SYSTEM_LINE_SEPARATOR);
            String requestAsString = request.toString();
            this.bufWriteReplayLog.write(requestAsString.substring(requestAsString.indexOf(SYSTEM_LINE_SEPARATOR) + 1));
            this.bufWriteReplayLog.write(SYSTEM_LINE_SEPARATOR);
            this.bufWriteReplayLog.flush();
        }
        catch (IOException ioe) {
            LOG.warn("Could not write request replay log: " + ioe);
            return;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        LOG.error("Error occurred while reading descriptor file [line: " + exception.getLineNumber() + "]:" + exception.getMessage(), (Throwable)exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        LOG.error("Error occurred while reading descriptor file [line: " + exception.getLineNumber() + "]:" + exception.getMessage(), (Throwable)exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        LOG.error("error occurred while reading descriptor file [line: " + exception.getLineNumber() + "]:" + exception.getMessage(), (Throwable)exception);
    }

    static {
        LOG = LogManager.getLogger(Descriptor.class);
    }
}

