/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.debuggee.DebuggeeFactory;
import org.exist.dom.QName;
import org.exist.dom.memtree.ElementImpl;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.memtree.SAXAdapter;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentMetadata;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.dom.persistent.XMLUtil;
import org.exist.http.BadRequestException;
import org.exist.http.Descriptor;
import org.exist.http.NotFoundException;
import org.exist.http.RESTServerParameter;
import org.exist.http.SessionManager;
import org.exist.http.servlets.EXistServlet;
import org.exist.http.servlets.HttpRequestWrapper;
import org.exist.http.servlets.HttpResponseWrapper;
import org.exist.http.servlets.RequestWrapper;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.source.DBSource;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.source.URLSource;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.VirtualTempFile;
import org.exist.util.VirtualTempFileInputSource;
import org.exist.util.io.FilterInputStreamCacheFactory;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.util.serializer.XQuerySerializer;
import org.exist.util.serializer.json.JSONNode;
import org.exist.util.serializer.json.JSONObject;
import org.exist.util.serializer.json.JSONSimpleProperty;
import org.exist.util.serializer.json.JSONValue;
import org.exist.xmldb.XmldbURI;
import org.exist.xqj.Marshaller;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.NameTest;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.exist.xupdate.Modification;
import org.exist.xupdate.XUpdateProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class RESTServer {
    protected static final Logger LOG = LogManager.getLogger(RESTServer.class);
    public static final String SERIALIZATION_METHOD_PROPERTY = "output-as";
    protected static final Properties defaultProperties = new Properties();
    public static final Properties defaultOutputKeysProperties;
    private static final String QUERY_ERROR_HEAD = "<html><head><title>Query Error</title><style type=\"text/css\">.errmsg {  border: 1px solid black;  padding: 15px;  margin-left: 20px;  margin-right: 20px;}h1 { color: #C0C0C0; }.path {  padding-bottom: 10px;}.high {   color: #666699;   font-weight: bold;}</style></head><body><h1>XQuery Error</h1>";
    private final String formEncoding;
    private final String containerEncoding;
    private final boolean useDynamicContentType;
    private final boolean safeMode;
    private final SessionManager sessionManager;
    private final EXistServlet.FeatureEnabled xquerySubmission;
    private final EXistServlet.FeatureEnabled xupdateSubmission;
    private String xqueryContextExqueryRequestAttribute;
    private Constructor cstrHttpServletRequestAdapter;

    public RESTServer(BrokerPool pool, String formEncoding, String containerEncoding, boolean useDynamicContentType, boolean safeMode, EXistServlet.FeatureEnabled xquerySubmission, EXistServlet.FeatureEnabled xupdateSubmission) {
        block4: {
            this.xqueryContextExqueryRequestAttribute = null;
            this.cstrHttpServletRequestAdapter = null;
            this.formEncoding = formEncoding;
            this.containerEncoding = containerEncoding;
            this.useDynamicContentType = useDynamicContentType;
            this.safeMode = safeMode;
            this.sessionManager = new SessionManager();
            this.xquerySubmission = xquerySubmission;
            this.xupdateSubmission = xupdateSubmission;
            try {
                Field fldExqRequestAttr;
                Class<?> clazz = Class.forName("org.exist.extensions.exquery.modules.request.RequestModule");
                if (clazz != null && (fldExqRequestAttr = clazz.getDeclaredField("EXQ_REQUEST_ATTR")) != null) {
                    this.xqueryContextExqueryRequestAttribute = (String)fldExqRequestAttr.get(null);
                    if (this.xqueryContextExqueryRequestAttribute != null && (clazz = Class.forName("org.exist.extensions.exquery.restxq.impl.adapters.HttpServletRequestAdapter")) != null) {
                        this.cstrHttpServletRequestAdapter = clazz.getConstructor(HttpServletRequest.class, FilterInputStreamCacheFactory.FilterInputStreamCacheConfiguration.class);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("EXQuery Request Module is not present: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getParameter(HttpServletRequest request, RESTServerParameter parameter) {
        return request.getParameter(parameter.queryStringKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doGet(DBBroker broker, HttpServletRequest request, HttpServletResponse response, String path) throws BadRequestException, PermissionDeniedException, NotFoundException, IOException {
        block57: {
            if (request.getCharacterEncoding() == null) {
                request.setCharacterEncoding(this.formEncoding);
            }
            if ((option = this.getParameter(request, RESTServerParameter.Release)) != null) {
                sessionId = Integer.parseInt(option);
                this.sessionManager.release(sessionId);
                if (RESTServer.LOG.isDebugEnabled()) {
                    RESTServer.LOG.debug("Released session " + sessionId);
                }
                response.setStatus(200);
                return;
            }
            howmany = 10;
            start = 1;
            typed = false;
            wrap = true;
            source = false;
            cache = false;
            outputProperties = new Properties(RESTServer.defaultOutputKeysProperties);
            query = null;
            if (!this.safeMode && (query = this.getParameter(request, RESTServerParameter.XPath)) == null) {
                query = this.getParameter(request, RESTServerParameter.Query);
            }
            _var = this.getParameter(request, RESTServerParameter.Variables);
            namespaces = null;
            variables = null;
            try {
                if (_var != null) {
                    nsExtractor = new NamespaceExtractor();
                    variables = this.parseXML(_var, nsExtractor);
                    namespaces = nsExtractor.getNamespaces();
                }
            }
            catch (SAXException e) {
                x = new XPathException(e.toString());
                this.writeXPathException(response, 400, "UTF-8", query, path, x);
            }
            catch (ParserConfigurationException e) {
                x = new XPathException(e.toString());
                this.writeXPathException(response, 400, "UTF-8", query, path, x);
            }
            option = this.getParameter(request, RESTServerParameter.HowMany);
            if (option != null) {
                try {
                    howmany = Integer.parseInt(option);
                }
                catch (NumberFormatException nfe) {
                    throw new BadRequestException("Parameter _howmany should be an int");
                }
            }
            if ((option = this.getParameter(request, RESTServerParameter.Start)) != null) {
                try {
                    start = Integer.parseInt(option);
                }
                catch (NumberFormatException nfe) {
                    throw new BadRequestException("Parameter _start should be an int");
                }
            }
            if ((option = this.getParameter(request, RESTServerParameter.Typed)) != null && "yes".equals(option.toLowerCase())) {
                typed = true;
            }
            if ((option = this.getParameter(request, RESTServerParameter.Wrap)) != null) {
                wrap = "yes".equals(option);
                outputProperties.setProperty("_wrap", option);
            }
            if ((option = this.getParameter(request, RESTServerParameter.Cache)) != null) {
                cache = "yes".equals(option);
            }
            if ((option = this.getParameter(request, RESTServerParameter.Indent)) != null) {
                outputProperties.setProperty("indent", option);
            }
            if ((option = this.getParameter(request, RESTServerParameter.Source)) != null && !this.safeMode) {
                source = "yes".equals(option);
            }
            if ((option = this.getParameter(request, RESTServerParameter.Session)) != null) {
                outputProperties.setProperty("serialization.session-id", option);
            }
            if ((stylesheet = this.getParameter(request, RESTServerParameter.XSL)) != null) {
                if ("no".equals(stylesheet)) {
                    outputProperties.setProperty("process-xsl-pi", "no");
                    outputProperties.remove("stylesheet");
                    stylesheet = null;
                } else {
                    outputProperties.setProperty("stylesheet", stylesheet);
                }
            } else {
                outputProperties.setProperty("process-xsl-pi", "yes");
            }
            RESTServer.LOG.debug("stylesheet = " + stylesheet);
            RESTServer.LOG.debug("query = " + query);
            encoding = this.getParameter(request, RESTServerParameter.Encoding);
            if (encoding != null) {
                outputProperties.setProperty("encoding", encoding);
            } else {
                encoding = "UTF-8";
            }
            mimeType = outputProperties.getProperty("media-type");
            if (query != null) {
                try {
                    this.search(broker, query, path, namespaces, variables, howmany, start, typed, outputProperties, wrap, cache, request, response);
                }
                catch (XPathException e) {
                    if (MimeType.XML_TYPE.getName().equals(mimeType)) {
                        this.writeXPathException(response, 400, encoding, query, path, e);
                    }
                    this.writeXPathExceptionHtml(response, 400, encoding, query, path, e);
                }
                return;
            }
            resource = null;
            pathUri = XmldbURI.createInternal((String)path);
            try {
                block56: {
                    block58: {
                        xquery_mime_type = MimeType.XQUERY_TYPE.getName();
                        xproc_mime_type = MimeType.XPROC_TYPE.getName();
                        resource = broker.getXMLResource(pathUri, Lock.LockMode.READ_LOCK);
                        if (null != resource && !this.isExecutableType(resource)) {
                            this.writeResourceAs(resource, broker, stylesheet, encoding, null, outputProperties, request, response);
                            return;
                        }
                        if (resource != null) ** GOTO lbl-1000
                        collection = broker.getCollection(pathUri);
                        if (collection == null) break block58;
                        if (this.safeMode || !collection.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
                            throw new PermissionDeniedException("Not allowed to read collection");
                        }
                        try {
                            this.writeCollection(response, encoding, broker, collection);
                            return;
                        }
                        catch (LockException le) {
                            if (MimeType.XML_TYPE.getName().equals(mimeType)) {
                                this.writeXPathException(response, 400, encoding, query, path, new XPathException(le.getMessage(), (Throwable)le));
                            } else {
                                this.writeXPathExceptionHtml(response, 400, encoding, query, path, new XPathException(le.getMessage(), (Throwable)le));
                            }
                            ** break block59
                        }
                    }
                    if (!source) ** GOTO lbl-1000
                    throw new NotFoundException("Document " + path + " not found");
lbl-1000:
                    // 4 sources

                    {
                        servletPath = pathUri;
                        while (!(null != resource || (servletPath = servletPath.removeLastSegment()) == XmldbURI.EMPTY_URI || null != (resource = broker.getXMLResource(servletPath, Lock.LockMode.READ_LOCK)) && this.isExecutableType(resource))) {
                            if (null == resource) continue;
                            throw new NotFoundException("Document " + path + " not found");
                        }
                        if (null == resource) {
                            throw new NotFoundException("Document " + path + " not found");
                        }
                        pathInfo = pathUri.trimFromBeginning(servletPath).toString();
                        descriptor = Descriptor.getDescriptorSingleton();
                        if (!source) break block56;
                        if (null != descriptor && descriptor.allowSource(path) && resource.getPermissions().validate(broker.getCurrentSubject(), 4)) {
                            if (xquery_mime_type.equals(resource.getMetadata().getMimeType())) {
                                this.writeResourceAs(resource, broker, stylesheet, encoding, MimeType.TEXT_TYPE.getName(), outputProperties, request, response);
                            } else if (xproc_mime_type.equals(resource.getMetadata().getMimeType())) {
                                this.writeResourceAs(resource, broker, stylesheet, encoding, MimeType.XML_TYPE.getName(), outputProperties, request, response);
                            }
                            break block57;
                        }
                        response.sendError(403, "Permission to view XQuery source for: " + path + " denied. Must be explicitly defined in descriptor.xml");
                    }
                    return;
                }
                try {
                    if (xquery_mime_type.equals(resource.getMetadata().getMimeType())) {
                        this.executeXQuery(broker, resource, request, response, outputProperties, servletPath.toString(), pathInfo);
                    } else if (xproc_mime_type.equals(resource.getMetadata().getMimeType())) {
                        this.executeXProc(broker, resource, request, response, outputProperties, servletPath.toString(), pathInfo);
                    }
                }
                catch (XPathException e) {
                    if (RESTServer.LOG.isDebugEnabled()) {
                        RESTServer.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                    if (MimeType.XML_TYPE.getName().equals(mimeType)) {
                        this.writeXPathException(response, 400, encoding, query, path, e);
                        break block57;
                    }
                    this.writeXPathExceptionHtml(response, 400, encoding, query, path, e);
                }
            }
            finally {
                if (resource != null) {
                    resource.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHead(DBBroker broker, HttpServletRequest request, HttpServletResponse response, String path) throws BadRequestException, PermissionDeniedException, NotFoundException, IOException {
        XmldbURI pathUri = XmldbURI.createInternal((String)path);
        if (this.checkForXQueryTarget(broker, pathUri, request, response)) {
            return;
        }
        Properties outputProperties = new Properties(defaultOutputKeysProperties);
        String encoding = this.getParameter(request, RESTServerParameter.Encoding);
        if (encoding != null) {
            outputProperties.setProperty("encoding", encoding);
        } else {
            encoding = "UTF-8";
        }
        DocumentImpl resource = null;
        try {
            resource = broker.getXMLResource(pathUri, Lock.LockMode.READ_LOCK);
            if (resource != null) {
                if (!resource.getPermissions().validate(broker.getCurrentSubject(), 4)) {
                    throw new PermissionDeniedException("Permission to read resource " + path + " denied");
                }
                DocumentMetadata metadata = resource.getMetadata();
                response.setContentType(metadata.getMimeType());
                response.addHeader("Content-Length", Long.toString(resource.getContentLength()));
                this.setCreatedAndLastModifiedHeaders(response, metadata.getCreated(), metadata.getLastModified());
            } else {
                Collection col = broker.getCollection(pathUri);
                if (col == null) {
                    response.sendError(404, "No resource at location: " + path);
                    return;
                }
                if (!col.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
                    throw new PermissionDeniedException("Permission to read resource " + path + " denied");
                }
                response.setContentType(MimeType.XML_TYPE.getName() + "; charset=" + encoding);
                this.setCreatedAndLastModifiedHeaders(response, col.getCreationTime(), col.getCreationTime());
            }
        }
        finally {
            if (resource != null) {
                resource.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(DBBroker broker, HttpServletRequest request, HttpServletResponse response, String path) throws BadRequestException, PermissionDeniedException, IOException, NotFoundException {
        block74: {
            int semicolon;
            String mimeType;
            String encoding;
            XmldbURI pathUri;
            Properties outputProperties;
            block73: {
                if (request.getCharacterEncoding() == null) {
                    request.setCharacterEncoding(this.formEncoding);
                }
                outputProperties = new Properties(defaultOutputKeysProperties);
                pathUri = XmldbURI.createInternal((String)path);
                DocumentImpl resource = null;
                encoding = outputProperties.getProperty("encoding");
                mimeType = outputProperties.getProperty("media-type");
                try {
                    String xquery_mime_type = MimeType.XQUERY_TYPE.getName();
                    String xproc_mime_type = MimeType.XPROC_TYPE.getName();
                    resource = broker.getXMLResource(pathUri, Lock.LockMode.READ_LOCK);
                    XmldbURI servletPath = pathUri;
                    while (!(null != resource || (servletPath = servletPath.removeLastSegment()) == XmldbURI.EMPTY_URI || null != (resource = broker.getXMLResource(servletPath, Lock.LockMode.READ_LOCK)) && (resource.getResourceType() == 1 && xquery_mime_type.equals(resource.getMetadata().getMimeType()) || resource.getResourceType() == 0 && xproc_mime_type.equals(resource.getMetadata().getMimeType())))) {
                        if (null == resource) continue;
                        resource.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                        resource = null;
                        break;
                    }
                    if (resource == null || (resource.getResourceType() != 1 || !xquery_mime_type.equals(resource.getMetadata().getMimeType())) && (resource.getResourceType() != 0 || !xproc_mime_type.equals(resource.getMetadata().getMimeType()))) break block73;
                    String pathInfo = pathUri.trimFromBeginning(servletPath).toString();
                    try {
                        if (xquery_mime_type.equals(resource.getMetadata().getMimeType())) {
                            this.executeXQuery(broker, resource, request, response, outputProperties, servletPath.toString(), pathInfo);
                        }
                        this.executeXProc(broker, resource, request, response, outputProperties, servletPath.toString(), pathInfo);
                    }
                    catch (XPathException e) {
                        if (MimeType.XML_TYPE.getName().equals(mimeType)) {
                            this.writeXPathException(response, 400, encoding, null, path, e);
                        }
                        this.writeXPathExceptionHtml(response, 400, encoding, null, path, e);
                    }
                    return;
                }
                finally {
                    if (resource != null) {
                        resource.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                    }
                }
            }
            String requestType = request.getContentType();
            if (requestType != null && (semicolon = requestType.indexOf(59)) > 0) {
                requestType = requestType.substring(0, semicolon).trim();
            }
            if (requestType == null || !requestType.equals(MimeType.URL_ENCODED_TYPE.getName())) {
                int howmany = 10;
                int start = 1;
                boolean typed = false;
                ElementImpl variables = null;
                boolean enclose = true;
                boolean cache = false;
                String query = null;
                TransactionManager transact = broker.getBrokerPool().getTransactionManager();
                try (Txn transaction = transact.beginTransaction();){
                    String content = this.getRequestContent(request);
                    NamespaceExtractor nsExtractor = new NamespaceExtractor();
                    ElementImpl root = this.parseXML(content, nsExtractor);
                    String rootNS = root.getNamespaceURI();
                    if (rootNS != null && rootNS.equals("http://exist.sourceforge.net/NS/exist")) {
                        if (RESTServerParameter.Query.xmlKey().equals(root.getLocalName())) {
                            String option = root.getAttribute(RESTServerParameter.Start.xmlKey());
                            if (option != null) {
                                try {
                                    start = Integer.parseInt(option);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if ((option = root.getAttribute(RESTServerParameter.Max.xmlKey())) != null) {
                                try {
                                    howmany = Integer.parseInt(option);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if ((option = root.getAttribute(RESTServerParameter.Enclose.xmlKey())) != null) {
                                if ("no".equals(option)) {
                                    enclose = false;
                                }
                            } else {
                                option = root.getAttribute(RESTServerParameter.Wrap.xmlKey());
                                if (option != null && "no".equals(option)) {
                                    enclose = false;
                                }
                            }
                            if ((option = root.getAttribute(RESTServerParameter.Method.xmlKey())) != null && !"".equals(option)) {
                                outputProperties.setProperty(SERIALIZATION_METHOD_PROPERTY, option);
                            }
                            if ((option = root.getAttribute(RESTServerParameter.Typed.xmlKey())) != null && "yes".equals(option)) {
                                typed = true;
                            }
                            if ((option = root.getAttribute(RESTServerParameter.Mime.xmlKey())) != null && !"".equals(option)) {
                                mimeType = option;
                            }
                            if ((option = root.getAttribute(RESTServerParameter.Cache.xmlKey())) != null) {
                                cache = "yes".equals(option);
                            }
                            if ((option = root.getAttribute(RESTServerParameter.Session.xmlKey())) != null && option.length() > 0) {
                                outputProperties.setProperty("serialization.session-id", option);
                            }
                            NodeList children = root.getChildNodes();
                            for (int i = 0; i < children.getLength(); ++i) {
                                Node child = children.item(i);
                                if (child.getNodeType() != 1 || !child.getNamespaceURI().equals("http://exist.sourceforge.net/NS/exist")) continue;
                                if (RESTServerParameter.Text.xmlKey().equals(child.getLocalName())) {
                                    StringBuilder buf = new StringBuilder();
                                    for (Node next = child.getFirstChild(); next != null; next = next.getNextSibling()) {
                                        if (next.getNodeType() != 3 && next.getNodeType() != 4) continue;
                                        buf.append(next.getNodeValue());
                                    }
                                    query = buf.toString();
                                    continue;
                                }
                                if (RESTServerParameter.Variables.xmlKey().equals(child.getLocalName())) {
                                    variables = (ElementImpl)child;
                                    continue;
                                }
                                if (!RESTServerParameter.Properties.xmlKey().equals(child.getLocalName())) continue;
                                for (Node node = child.getFirstChild(); node != null; node = node.getNextSibling()) {
                                    if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("http://exist.sourceforge.net/NS/exist") || !RESTServerParameter.Property.xmlKey().equals(node.getLocalName())) continue;
                                    Element property = (Element)node;
                                    String key = property.getAttribute("name");
                                    String value = property.getAttribute("value");
                                    LOG.debug(key + " = " + value);
                                    if (key == null || value == null) continue;
                                    outputProperties.setProperty(key, value);
                                }
                            }
                        }
                        if (query != null) {
                            try {
                                this.search(broker, query, path, nsExtractor.getNamespaces(), variables, howmany, start, typed, outputProperties, enclose, cache, request, response);
                                transact.commit(transaction);
                            }
                            catch (XPathException e) {
                                if (MimeType.XML_TYPE.getName().equals(mimeType)) {
                                    this.writeXPathException(response, 400, encoding, null, path, e);
                                    break block74;
                                }
                                this.writeXPathExceptionHtml(response, 400, encoding, null, path, e);
                            }
                            break block74;
                        }
                        transact.abort(transaction);
                        throw new BadRequestException("No query specified");
                    }
                    if (rootNS != null && rootNS.equals("http://www.xmldb.org/xupdate")) {
                        Subject currentSubject;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Got xupdate request: " + content);
                        }
                        if (this.xupdateSubmission == EXistServlet.FeatureEnabled.FALSE) {
                            response.setStatus(403);
                            return;
                        }
                        if (!(this.xupdateSubmission != EXistServlet.FeatureEnabled.AUTHENTICATED_USERS_ONLY || (currentSubject = broker.getCurrentSubject()).isAuthenticated() && currentSubject.getId() != 1048574)) {
                            response.setStatus(403);
                            return;
                        }
                        DefaultDocumentSet docs = new DefaultDocumentSet();
                        Collection collection = broker.getCollection(pathUri);
                        if (collection != null) {
                            collection.allDocs(broker, (MutableDocumentSet)docs, true);
                        } else {
                            DocumentImpl xupdateDoc = broker.getResource(pathUri, 4);
                            if (xupdateDoc != null) {
                                docs.add(xupdateDoc);
                            } else {
                                broker.getAllXMLResources((MutableDocumentSet)docs);
                            }
                        }
                        XUpdateProcessor processor = new XUpdateProcessor(broker, (DocumentSet)docs);
                        Modification[] modifications = processor.parse(new InputSource(new StringReader(content)));
                        long mods = 0L;
                        for (int i = 0; i < modifications.length; ++i) {
                            mods += modifications[i].process(transaction);
                            broker.flush();
                        }
                        transact.commit(transaction);
                        this.writeXUpdateResult(response, encoding, mods);
                        break block74;
                    }
                    transact.abort(transaction);
                    throw new BadRequestException("Unknown XML root element: " + root.getNodeName());
                }
                catch (SAXException e) {
                    Exception cause = e;
                    if (e.getException() != null) {
                        cause = e.getException();
                    }
                    LOG.debug("SAX exception while parsing request: " + cause.getMessage(), (Throwable)cause);
                    throw new BadRequestException("SAX exception while parsing request: " + cause.getMessage());
                }
                catch (ParserConfigurationException e) {
                    throw new BadRequestException("Parser exception while parsing request: " + e.getMessage());
                }
                catch (XPathException e) {
                    throw new BadRequestException("Query exception while parsing request: " + e.getMessage());
                }
                catch (IOException e) {
                    throw new BadRequestException("IO exception while parsing request: " + e.getMessage());
                }
                catch (EXistException e) {
                    throw new BadRequestException(e.getMessage());
                }
                catch (LockException e) {
                    throw new PermissionDeniedException(e.getMessage());
                }
            }
            this.doGet(broker, request, response, path);
        }
    }

    private ElementImpl parseXML(String content, NamespaceExtractor nsExtractor) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        InputSource src = new InputSource(new StringReader(content));
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        SAXAdapter adapter = new SAXAdapter();
        nsExtractor.setContentHandler((ContentHandler)adapter);
        nsExtractor.setParent(reader);
        nsExtractor.parse(src);
        org.exist.dom.memtree.DocumentImpl doc = adapter.getDocument();
        return (ElementImpl)doc.getDocumentElement();
    }

    public void doPut(DBBroker broker, XmldbURI path, HttpServletRequest request, HttpServletResponse response) throws BadRequestException, PermissionDeniedException, IOException, NotFoundException {
        if (this.checkForXQueryTarget(broker, path, request, response)) {
            return;
        }
        TransactionManager transact = broker.getBrokerPool().getTransactionManager();
        VirtualTempFile vtempFile = null;
        try (Txn transaction = transact.beginTransaction();){
            MimeType mime;
            try (ServletInputStream is = request.getInputStream();){
                long len = request.getContentLength();
                String lenstr = request.getHeader("Content-Length");
                if (lenstr != null) {
                    len = Long.parseLong(lenstr);
                }
                vtempFile = new VirtualTempFile();
                vtempFile.setTempPrefix("existSRV");
                vtempFile.setTempPostfix(".tmp");
                vtempFile.write((InputStream)is, len);
                vtempFile.close();
            }
            XmldbURI docUri = path.lastSegment();
            XmldbURI collUri = path.removeLastSegment();
            if (docUri == null || collUri == null) {
                transact.abort(transaction);
                throw new BadRequestException("Bad path: " + path);
            }
            Collection collection = broker.getCollection(collUri);
            if (collection == null) {
                LOG.debug("creating collection " + collUri);
                collection = broker.getOrCreateCollection(transaction, collUri);
                broker.saveCollection(transaction, collection);
            }
            String contentType = request.getContentType();
            String charset = null;
            if (contentType != null) {
                String param;
                int equals;
                int semicolon = contentType.indexOf(59);
                if (semicolon > 0 && (equals = (contentType = contentType.substring(0, semicolon).trim()).indexOf(61, semicolon)) > 0 && (param = contentType.substring(semicolon + 1, equals).trim()).compareToIgnoreCase("charset=") == 0) {
                    charset = param.substring(equals + 1).trim();
                }
                mime = MimeTable.getInstance().getContentType(contentType);
            } else {
                mime = MimeTable.getInstance().getContentTypeFor(docUri);
                if (mime != null) {
                    contentType = mime.getName();
                }
            }
            if (mime == null) {
                mime = MimeType.BINARY_TYPE;
                contentType = mime.getName();
            }
            if (mime.isXMLType()) {
                try (VirtualTempFileInputSource vtfis = new VirtualTempFileInputSource(vtempFile, charset);){
                    IndexInfo info = collection.validateXMLResource(transaction, broker, docUri, (InputSource)vtfis);
                    info.getDocument().getMetadata().setMimeType(contentType);
                    collection.store(transaction, broker, info, (InputSource)vtfis);
                    response.setStatus(201);
                }
            }
            try (InputStream is = vtempFile.getByteStream();){
                collection.addBinaryResource(transaction, broker, docUri, is, contentType, vtempFile.length());
            }
            response.setStatus(201);
            transact.commit(transaction);
        }
        catch (SAXParseException e) {
            throw new BadRequestException("Parsing exception at " + e.getLineNumber() + "/" + e.getColumnNumber() + ": " + e.toString());
        }
        catch (TriggerException e) {
            throw new PermissionDeniedException(e.getMessage());
        }
        catch (SAXException e) {
            Exception o = e.getException();
            if (o == null) {
                o = e;
            }
            throw new BadRequestException("Parsing exception: " + o.getMessage());
        }
        catch (EXistException e) {
            throw new BadRequestException("Internal error: " + e.getMessage());
        }
        catch (LockException e) {
            throw new PermissionDeniedException(e.getMessage());
        }
        finally {
            if (vtempFile != null) {
                vtempFile.delete();
            }
        }
    }

    public void doDelete(DBBroker broker, String path, HttpServletRequest request, HttpServletResponse response) throws PermissionDeniedException, NotFoundException, IOException, BadRequestException {
        block34: {
            XmldbURI pathURI = XmldbURI.createInternal((String)path);
            if (this.checkForXQueryTarget(broker, pathURI, request, response)) {
                return;
            }
            TransactionManager transact = broker.getBrokerPool().getTransactionManager();
            try {
                Collection collection = broker.getCollection(pathURI);
                if (collection != null) {
                    LOG.debug("removing collection " + path);
                    try (Txn txn = transact.beginTransaction();){
                        broker.removeCollection(txn, collection);
                        transact.commit(txn);
                    }
                    response.setStatus(200);
                    break block34;
                }
                DocumentImpl doc = broker.getResource(pathURI, 2);
                if (doc == null) {
                    throw new NotFoundException("No document or collection found for path: " + path);
                }
                LOG.debug("removing document " + path);
                try (Txn txn = transact.beginTransaction();){
                    if (doc.getResourceType() == 1) {
                        doc.getCollection().removeBinaryResource(txn, broker, pathURI.lastSegment());
                    } else {
                        doc.getCollection().removeXMLResource(txn, broker, pathURI.lastSegment());
                    }
                    transact.commit(txn);
                }
                response.setStatus(200);
            }
            catch (TriggerException e) {
                throw new PermissionDeniedException("Trigger failed: " + e.getMessage());
            }
            catch (LockException e) {
                throw new PermissionDeniedException("Could not acquire lock: " + e.getMessage());
            }
            catch (TransactionException e) {
                LOG.warn("Transaction aborted: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForXQueryTarget(DBBroker broker, XmldbURI path, HttpServletRequest request, HttpServletResponse response) throws PermissionDeniedException, NotFoundException, IOException, BadRequestException {
        if (request.getAttribute("org.exist.forward") == null) {
            return false;
        }
        String xqueryType = MimeType.XQUERY_TYPE.getName();
        Collection collection = broker.getCollection(path);
        if (collection == null) {
            XmldbURI servletPath = path;
            DocumentImpl resource = null;
            while (!(null != resource || null != (resource = broker.getXMLResource(servletPath, Lock.LockMode.READ_LOCK)) && resource.getResourceType() == 1 && xqueryType.equals(resource.getMetadata().getMimeType()))) {
                if (null != resource) {
                    resource.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                    resource = null;
                    break;
                }
                if ((servletPath = servletPath.removeLastSegment()) != XmldbURI.EMPTY_URI) continue;
            }
            if (resource != null) {
                String pathInfo = path.trimFromBeginning(servletPath).toString();
                Properties outputProperties = new Properties(defaultOutputKeysProperties);
                try {
                    this.executeXQuery(broker, resource, request, response, outputProperties, servletPath.toString(), pathInfo);
                }
                catch (XPathException e) {
                    this.writeXPathExceptionHtml(response, 400, "UTF-8", null, path.toString(), e);
                }
                finally {
                    resource.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                }
                return true;
            }
        }
        return false;
    }

    private String getRequestContent(HttpServletRequest request) throws IOException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        ServletInputStream is = request.getInputStream();
        InputStreamReader reader = new InputStreamReader((InputStream)is, encoding);
        StringWriter content = new StringWriter();
        char[] ch = new char[4096];
        int len = 0;
        while ((len = reader.read(ch)) > -1) {
            content.write(ch, 0, len);
        }
        String xml = content.toString();
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void search(DBBroker broker, String query, String path, List<Namespace> namespaces, ElementImpl variables, int howmany, int start, boolean typed, Properties outputProperties, boolean wrap, boolean cache, HttpServletRequest request, HttpServletResponse response) throws BadRequestException, PermissionDeniedException, XPathException {
        Subject currentSubject;
        if (this.xquerySubmission == EXistServlet.FeatureEnabled.FALSE) {
            response.setStatus(403);
            return;
        }
        if (!(this.xquerySubmission != EXistServlet.FeatureEnabled.AUTHENTICATED_USERS_ONLY || (currentSubject = broker.getCurrentSubject()).isAuthenticated() && currentSubject.getId() != 1048574)) {
            response.setStatus(403);
            return;
        }
        String sessionIdParam = outputProperties.getProperty("serialization.session-id");
        if (sessionIdParam != null) {
            try {
                int sessionId = Integer.parseInt(sessionIdParam);
                if (sessionId > -1) {
                    Sequence cached = this.sessionManager.get(query, sessionId);
                    if (cached != null) {
                        LOG.debug("Returning cached query result");
                        this.writeResults(response, broker, cached, howmany, start, typed, outputProperties, wrap, 0L, 0L);
                    } else {
                        LOG.debug("Cached query result not found. Probably timed out. Repeating query.");
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Invalid session id passed in query request: " + sessionIdParam);
            }
        }
        XmldbURI pathUri = XmldbURI.createInternal((String)path);
        try {
            long compilationTime;
            StringSource source = new StringSource(query);
            XQuery xquery = broker.getBrokerPool().getXQueryService();
            XQueryPool pool = broker.getBrokerPool().getXQueryPool();
            CompiledXQuery compiled = pool.borrowCompiledXQuery(broker, (Source)source);
            XQueryContext context = compiled == null ? new XQueryContext((Database)broker.getBrokerPool()) : compiled.getContext();
            context.setStaticallyKnownDocuments(new XmldbURI[]{pathUri});
            context.setBaseURI(new AnyURIValue(pathUri.toString()));
            this.declareNamespaces(context, namespaces);
            this.declareVariables(context, variables, request, response);
            if (compiled == null) {
                long compilationStart = System.currentTimeMillis();
                compiled = xquery.compile(broker, context, (Source)source);
                compilationTime = System.currentTimeMillis() - compilationStart;
            } else {
                compiled.getContext().updateContext(context);
                context.getWatchDog().reset();
                compilationTime = 0L;
            }
            try {
                long executeStart = System.currentTimeMillis();
                Sequence resultSequence = xquery.execute(broker, compiled, null, outputProperties);
                long executionTime = System.currentTimeMillis() - executeStart;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found " + resultSequence.getItemCount() + " in " + executionTime + "ms.");
                }
                if (cache) {
                    int sessionId = this.sessionManager.add(query, resultSequence);
                    outputProperties.setProperty("serialization.session-id", Integer.toString(sessionId));
                    if (!response.isCommitted()) {
                        response.setIntHeader("X-Session-Id", sessionId);
                    }
                }
                this.writeResults(response, broker, resultSequence, howmany, start, typed, outputProperties, wrap, compilationTime, executionTime);
            }
            finally {
                context.runCleanupTasks();
                pool.returnCompiledXQuery((Source)source, compiled);
            }
        }
        catch (IOException e) {
            throw new BadRequestException(e.getMessage(), e);
        }
    }

    private void declareNamespaces(XQueryContext context, List<Namespace> namespaces) throws XPathException {
        if (namespaces == null) {
            return;
        }
        for (Namespace ns : namespaces) {
            context.declareNamespace(ns.getPrefix(), ns.getUri());
        }
    }

    private HttpRequestWrapper declareVariables(final XQueryContext context, ElementImpl variables, HttpServletRequest request, HttpServletResponse response) throws XPathException {
        HttpRequestWrapper reqw;
        block4: {
            reqw = new HttpRequestWrapper(request, this.formEncoding, this.containerEncoding);
            HttpResponseWrapper respw = new HttpResponseWrapper(response);
            context.declareVariable("request:request", (Object)reqw);
            context.declareVariable("response:response", (Object)respw);
            context.declareVariable("session:session", (Object)reqw.getSession(false));
            try {
                Object exqueryRequestAdapter;
                if (this.xqueryContextExqueryRequestAttribute != null && this.cstrHttpServletRequestAdapter != null && (exqueryRequestAdapter = this.cstrHttpServletRequestAdapter.newInstance(request, new FilterInputStreamCacheFactory.FilterInputStreamCacheConfiguration(){

                    public String getCacheClass() {
                        return (String)context.getBroker().getConfiguration().getProperty("binary.cache.class");
                    }
                })) != null) {
                    context.setAttribute(this.xqueryContextExqueryRequestAttribute, exqueryRequestAdapter);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("EXQuery Request Module is not present: " + e.getMessage(), (Throwable)e);
            }
        }
        if (variables != null) {
            this.declareExternalAndXQJVariables(context, variables);
        }
        return reqw;
    }

    private void declareExternalAndXQJVariables(XQueryContext context, ElementImpl variables) throws XPathException {
        ValueSequence varSeq = new ValueSequence();
        variables.selectChildren((NodeTest)new NameTest(1, new QName(RESTServerParameter.Variable.xmlKey(), "http://exist.sourceforge.net/NS/exist")), (Sequence)varSeq);
        SequenceIterator i = varSeq.iterate();
        while (i.hasNext()) {
            Sequence sequence;
            ElementImpl variable = (ElementImpl)i.nextItem();
            ElementImpl qname = (ElementImpl)variable.getFirstChild((NodeTest)new NameTest(1, new QName("qname", "http://exist.sourceforge.net/NS/exist")));
            String localname = null;
            String prefix = null;
            String uri = null;
            for (NodeImpl child = (NodeImpl)qname.getFirstChild(); child != null; child = (NodeImpl)child.getNextSibling()) {
                if ("localname".equals(child.getLocalName())) {
                    localname = child.getStringValue();
                    continue;
                }
                if ("namespace".equals(child.getLocalName())) {
                    uri = child.getStringValue();
                    continue;
                }
                if (!"prefix".equals(child.getLocalName())) continue;
                prefix = child.getStringValue();
            }
            if (uri != null && prefix != null) {
                context.declareNamespace(prefix, uri);
            }
            if (localname == null) continue;
            QName q = prefix != null && localname != null ? new QName(localname, uri, prefix) : new QName(localname, uri, "");
            NodeImpl value = variable.getFirstChild((NodeTest)new NameTest(1, Marshaller.ROOT_ELEMENT_QNAME));
            try {
                sequence = value == null ? Sequence.EMPTY_SEQUENCE : Marshaller.demarshall((NodeImpl)value);
            }
            catch (XMLStreamException xe) {
                throw new XPathException(xe.toString());
            }
            if (prefix != null) {
                context.declareVariable(q.getPrefix() + ":" + q.getLocalPart(), (Object)sequence);
                continue;
            }
            context.declareVariable(q.getLocalPart(), (Object)sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeXQuery(DBBroker broker, DocumentImpl resource, HttpServletRequest request, HttpServletResponse response, Properties outputProperties, String servletPath, String pathInfo) throws XPathException, BadRequestException, PermissionDeniedException {
        long compilationTime;
        XQueryContext context;
        DBSource source = new DBSource(broker, (BinaryDocument)resource, true);
        XQuery xquery = broker.getBrokerPool().getXQueryService();
        XQueryPool pool = broker.getBrokerPool().getXQueryPool();
        CompiledXQuery compiled = pool.borrowCompiledXQuery(broker, (Source)source);
        if (compiled == null) {
            response.setHeader("X-XQuery-Cached", "false");
            context = new XQueryContext((Database)broker.getBrokerPool());
        } else {
            response.setHeader("X-XQuery-Cached", "true");
            context = compiled.getContext();
        }
        context.setModuleLoadPath(XmldbURI.EMBEDDED_SERVER_URI.append(resource.getCollection().getURI()).toString());
        context.setStaticallyKnownDocuments(new XmldbURI[]{resource.getCollection().getURI()});
        HttpRequestWrapper reqw = this.declareVariables(context, null, request, response);
        reqw.setServletPath(servletPath);
        reqw.setPathInfo(pathInfo);
        if (compiled == null) {
            try {
                long compilationStart = System.currentTimeMillis();
                compiled = xquery.compile(broker, context, (Source)source);
                compilationTime = System.currentTimeMillis() - compilationStart;
            }
            catch (IOException e) {
                throw new BadRequestException("Failed to read query from " + resource.getURI(), e);
            }
        } else {
            compilationTime = 0L;
        }
        DebuggeeFactory.checkForDebugRequest((HttpServletRequest)request, (XQueryContext)context);
        boolean wrap = outputProperties.getProperty("_wrap") != null && "yes".equals(outputProperties.getProperty("_wrap"));
        try {
            long executeStart = System.currentTimeMillis();
            Sequence result = xquery.execute(broker, compiled, null, outputProperties);
            this.writeResults(response, broker, result, -1, 1, false, outputProperties, wrap, compilationTime, System.currentTimeMillis() - executeStart);
        }
        finally {
            context.runCleanupTasks();
            pool.returnCompiledXQuery((Source)source, compiled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeXProc(DBBroker broker, DocumentImpl resource, HttpServletRequest request, HttpServletResponse response, Properties outputProperties, String servletPath, String pathInfo) throws XPathException, BadRequestException, PermissionDeniedException {
        long compilationTime;
        URLSource source = new URLSource(this.getClass().getResource("run-xproc.xq"));
        XQuery xquery = broker.getBrokerPool().getXQueryService();
        XQueryPool pool = broker.getBrokerPool().getXQueryPool();
        CompiledXQuery compiled = pool.borrowCompiledXQuery(broker, (Source)source);
        XQueryContext context = compiled == null ? new XQueryContext((Database)broker.getBrokerPool()) : compiled.getContext();
        context.declareVariable("pipeline", (Object)resource.getURI().toString());
        String stdin = request.getParameter("stdin");
        context.declareVariable("stdin", (Object)(stdin == null ? "" : stdin));
        String debug = request.getParameter("debug");
        context.declareVariable("debug", (Object)(debug == null ? "0" : "1"));
        String bindings = request.getParameter("bindings");
        context.declareVariable("bindings", (Object)(bindings == null ? "<bindings/>" : bindings));
        String autobind = request.getParameter("autobind");
        context.declareVariable("autobind", (Object)(autobind == null ? "0" : "1"));
        String options = request.getParameter("options");
        context.declareVariable("options", (Object)(options == null ? "<options/>" : options));
        context.setModuleLoadPath(XmldbURI.EMBEDDED_SERVER_URI.append(resource.getCollection().getURI()).toString());
        context.setStaticallyKnownDocuments(new XmldbURI[]{resource.getCollection().getURI()});
        HttpRequestWrapper reqw = this.declareVariables(context, null, request, response);
        reqw.setServletPath(servletPath);
        reqw.setPathInfo(pathInfo);
        if (compiled == null) {
            try {
                long compilationStart = System.currentTimeMillis();
                compiled = xquery.compile(broker, context, (Source)source);
                compilationTime = System.currentTimeMillis() - compilationStart;
            }
            catch (IOException e) {
                throw new BadRequestException("Failed to read query from " + source.getURL(), e);
            }
        } else {
            compilationTime = 0L;
        }
        try {
            long executeStart = System.currentTimeMillis();
            Sequence result = xquery.execute(broker, compiled, null, outputProperties);
            this.writeResults(response, broker, result, -1, 1, false, outputProperties, false, compilationTime, System.currentTimeMillis() - executeStart);
        }
        finally {
            context.runCleanupTasks();
            pool.returnCompiledXQuery((Source)source, compiled);
        }
    }

    public void setCreatedAndLastModifiedHeaders(HttpServletResponse response, long created, long lastModified) {
        long createdMillisComp;
        long lastModifiedMillisComp = lastModified % 1000L;
        if (lastModifiedMillisComp > 0L) {
            lastModified += 1000L - lastModifiedMillisComp;
        }
        if ((createdMillisComp = created % 1000L) > 0L) {
            created += 1000L - createdMillisComp;
        }
        response.addDateHeader("Last-Modified", lastModified);
        response.addDateHeader("Created", created);
    }

    private void writeResourceAs(DocumentImpl resource, DBBroker broker, String stylesheet, String encoding, String asMimeType, Properties outputProperties, HttpServletRequest request, HttpServletResponse response) throws BadRequestException, PermissionDeniedException, IOException {
        if (!resource.getPermissions().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Not allowed to read resource");
        }
        DocumentMetadata metadata = resource.getMetadata();
        long lastModified = metadata.getLastModified();
        this.setCreatedAndLastModifiedHeaders(response, metadata.getCreated(), lastModified);
        try {
            long ifModifiedSince = request.getDateHeader("If-Modified-Since");
            if (ifModifiedSince > -1L && ifModifiedSince <= System.currentTimeMillis() && lastModified <= ifModifiedSince) {
                response.setStatus(304);
                return;
            }
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("Illegal If-Modified-Since HTTP Header sent on request, ignoring. " + iae.getMessage(), (Throwable)iae);
        }
        if (resource.getResourceType() == 1) {
            if (asMimeType == null) {
                asMimeType = resource.getMetadata().getMimeType();
            }
            if (asMimeType.startsWith("text/")) {
                response.setContentType(asMimeType + "; charset=" + encoding);
            } else {
                response.setContentType(asMimeType);
            }
            response.addHeader("Content-Length", Long.toString(resource.getContentLength()));
            ServletOutputStream os = response.getOutputStream();
            broker.readBinaryResource((BinaryDocument)resource, (OutputStream)os);
            os.flush();
        } else {
            SAXSerializer sax = null;
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            Serializer.HttpContext httpContext = new Serializer.HttpContext(serializer);
            HttpRequestWrapper reqw = new HttpRequestWrapper(request, this.formEncoding, this.containerEncoding);
            httpContext.setRequest((RequestWrapper)reqw);
            httpContext.setSession(reqw.getSession(false));
            serializer.setHttpContext(httpContext);
            try {
                sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
                if (stylesheet != null) {
                    serializer.setStylesheet(resource, stylesheet);
                }
                serializer.setProperties(outputProperties);
                serializer.prepareStylesheets(resource);
                if (asMimeType != null) {
                    response.setContentType(asMimeType + "; charset=" + encoding);
                } else if (serializer.isStylesheetApplied() || serializer.hasXSLPi((Document)resource) != null) {
                    asMimeType = serializer.getStylesheetProperty("media-type");
                    if (!this.useDynamicContentType || asMimeType == null) {
                        asMimeType = MimeType.HTML_TYPE.getName();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("media-type: " + asMimeType);
                    }
                    response.setContentType(asMimeType + "; charset=" + encoding);
                } else {
                    asMimeType = resource.getMetadata().getMimeType();
                    response.setContentType(asMimeType + "; charset=" + encoding);
                }
                if (asMimeType.equals(MimeType.HTML_TYPE.getName())) {
                    outputProperties.setProperty("method", "xhtml");
                    outputProperties.setProperty("media-type", "text/html; charset=" + encoding);
                    outputProperties.setProperty("indent", "yes");
                    outputProperties.setProperty("omit-xml-declaration", "no");
                }
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), encoding);
                sax.setOutput((Writer)writer, outputProperties);
                serializer.setSAXHandlers((ContentHandler)sax, (LexicalHandler)sax);
                serializer.toSAX(resource);
                writer.flush();
                writer.close();
            }
            catch (SAXException saxe) {
                LOG.warn((Object)saxe);
                throw new BadRequestException("Error while serializing XML: " + saxe.getMessage());
            }
            catch (TransformerConfigurationException e) {
                LOG.warn((Object)e);
                throw new BadRequestException(e.getMessageAndLocation());
            }
            finally {
                if (sax != null) {
                    SerializerPool.getInstance().returnObject((Object)sax);
                }
            }
        }
    }

    private void writeXPathExceptionHtml(HttpServletResponse response, int httpStatusCode, String encoding, String query, String path, XPathException e) throws IOException {
        if (!response.isCommitted()) {
            response.reset();
        }
        response.setStatus(httpStatusCode);
        response.setContentType(MimeType.HTML_TYPE.getName() + "; charset=" + encoding);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), encoding);
        writer.write(QUERY_ERROR_HEAD);
        writer.write("<p class=\"path\"><span class=\"high\">Path</span>: ");
        writer.write("<a href=\"");
        writer.write(path);
        writer.write("\">");
        writer.write(path);
        writer.write("</a></p>");
        writer.write("<p class=\"errmsg\">");
        String message = e.getMessage() == null ? e.toString() : e.getMessage();
        writer.write(XMLUtil.encodeAttrMarkup((String)message));
        writer.write("</p>");
        if (query != null) {
            writer.write("<p><span class=\"high\">Query</span>:</p><pre>");
            writer.write(XMLUtil.encodeAttrMarkup((String)query));
            writer.write("</pre>");
        }
        writer.write("</body></html>");
        writer.flush();
        writer.close();
    }

    private void writeXPathException(HttpServletResponse response, int httpStatusCode, String encoding, String query, String path, XPathException e) throws IOException {
        if (!response.isCommitted()) {
            response.reset();
        }
        response.setStatus(httpStatusCode);
        response.setContentType(MimeType.XML_TYPE.getName() + "; charset=" + encoding);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), encoding);){
            writer.write("<?xml version=\"1.0\" ?>");
            writer.write("<exception><path>");
            writer.write(path);
            writer.write("</path>");
            writer.write("<message>");
            String message = e.getMessage() == null ? e.toString() : e.getMessage();
            writer.write(XMLUtil.encodeAttrMarkup((String)message));
            writer.write("</message>");
            if (query != null) {
                writer.write("<query>");
                writer.write(XMLUtil.encodeAttrMarkup((String)query));
                writer.write("</query>");
            }
            writer.write("</exception>");
        }
    }

    private void writeXUpdateResult(HttpServletResponse response, String encoding, long updateCount) throws IOException {
        response.setContentType(MimeType.XML_TYPE.getName() + "; charset=" + encoding);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), encoding);
        writer.write("<?xml version=\"1.0\" ?>");
        writer.write("<exist:modifications xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" count=\"" + updateCount + "\">");
        writer.write(updateCount + " modifications processed.");
        writer.write("</exist:modifications>");
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeCollection(HttpServletResponse response, String encoding, DBBroker broker, Collection collection) throws IOException, PermissionDeniedException, LockException {
        response.setContentType(MimeType.XML_TYPE.getName() + "; charset=" + encoding);
        this.setCreatedAndLastModifiedHeaders(response, collection.getCreationTime(), collection.getCreationTime());
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), encoding);
        SAXSerializer serializer = null;
        try {
            serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            serializer.setOutput((Writer)writer, defaultProperties);
            AttributesImpl attrs = new AttributesImpl();
            serializer.startDocument();
            serializer.startPrefixMapping("exist", "http://exist.sourceforge.net/NS/exist");
            serializer.startElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result", (Attributes)attrs);
            attrs.addAttribute("", "name", "name", "CDATA", collection.getURI().toString());
            try {
                DateTimeValue dtCreated = new DateTimeValue(new Date(collection.getCreationTime()));
                attrs.addAttribute("", "created", "created", "CDATA", dtCreated.getStringValue());
            }
            catch (XPathException e) {
                attrs.addAttribute("", "created", "created", "CDATA", String.valueOf(collection.getCreationTime()));
            }
            this.addPermissionAttributes(attrs, collection.getPermissionsNoLock());
            serializer.startElement("http://exist.sourceforge.net/NS/exist", "collection", "exist:collection", (Attributes)attrs);
            Iterator i = collection.collectionIterator(broker);
            while (i.hasNext()) {
                XmldbURI child = (XmldbURI)i.next();
                Collection childCollection = broker.getCollection(collection.getURI().append(child));
                if (childCollection == null || !childCollection.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) continue;
                attrs.clear();
                attrs.addAttribute("", "name", "name", "CDATA", child.toString());
                try {
                    DateTimeValue dtCreated = new DateTimeValue(new Date(childCollection.getCreationTime()));
                    attrs.addAttribute("", "created", "created", "CDATA", dtCreated.getStringValue());
                }
                catch (XPathException e) {
                    attrs.addAttribute("", "created", "created", "CDATA", String.valueOf(childCollection.getCreationTime()));
                }
                this.addPermissionAttributes(attrs, childCollection.getPermissionsNoLock());
                serializer.startElement("http://exist.sourceforge.net/NS/exist", "collection", "exist:collection", (Attributes)attrs);
                serializer.endElement("http://exist.sourceforge.net/NS/exist", "collection", "exist:collection");
            }
            i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                if (!doc.getPermissions().validate(broker.getCurrentSubject(), 4)) continue;
                XmldbURI resource = doc.getFileURI();
                DocumentMetadata metadata = doc.getMetadata();
                attrs.clear();
                attrs.addAttribute("", "name", "name", "CDATA", resource.toString());
                try {
                    DateTimeValue dtCreated = new DateTimeValue(new Date(metadata.getCreated()));
                    attrs.addAttribute("", "created", "created", "CDATA", dtCreated.getStringValue());
                }
                catch (XPathException e) {
                    attrs.addAttribute("", "created", "created", "CDATA", String.valueOf(metadata.getCreated()));
                }
                try {
                    DateTimeValue dtLastModified = new DateTimeValue(new Date(metadata.getLastModified()));
                    attrs.addAttribute("", "last-modified", "last-modified", "CDATA", dtLastModified.getStringValue());
                }
                catch (XPathException e) {
                    attrs.addAttribute("", "last-modified", "last-modified", "CDATA", String.valueOf(metadata.getLastModified()));
                }
                this.addPermissionAttributes(attrs, doc.getPermissions());
                serializer.startElement("http://exist.sourceforge.net/NS/exist", "resource", "exist:resource", (Attributes)attrs);
                serializer.endElement("http://exist.sourceforge.net/NS/exist", "resource", "exist:resource");
            }
            serializer.endElement("http://exist.sourceforge.net/NS/exist", "collection", "exist:collection");
            serializer.endElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result");
            serializer.endDocument();
            writer.flush();
            writer.close();
        }
        catch (SAXException e) {
            LOG.warn("Error while serializing collection contents: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (serializer != null) {
                SerializerPool.getInstance().returnObject((Object)serializer);
            }
        }
    }

    protected void addPermissionAttributes(AttributesImpl attrs, Permission perm) {
        attrs.addAttribute("", "owner", "owner", "CDATA", perm.getOwner().getName());
        attrs.addAttribute("", "group", "group", "CDATA", perm.getGroup().getName());
        attrs.addAttribute("", "permissions", "permissions", "CDATA", perm.toString());
    }

    protected void writeResults(HttpServletResponse response, DBBroker broker, Sequence results, int howmany, int start, boolean typed, Properties outputProperties, boolean wrap, long compilationTime, long executionTime) throws BadRequestException {
        if (response.isCommitted()) {
            return;
        }
        if (!results.isEmpty()) {
            int rlen = results.getItemCount();
            if (start < 1 || start > rlen) {
                throw new BadRequestException("Start parameter out of range");
            }
            if (howmany + start > rlen || howmany <= 0) {
                howmany = rlen - start + 1;
            }
        } else {
            howmany = 0;
        }
        String method = outputProperties.getProperty(SERIALIZATION_METHOD_PROPERTY, "xml");
        if ("json".equals(method)) {
            this.writeResultJSON(response, broker, results, howmany, start, outputProperties, wrap, compilationTime, executionTime);
        } else {
            this.writeResultXML(response, broker, results, howmany, start, typed, outputProperties, wrap, compilationTime, executionTime);
        }
    }

    private void writeResultXML(HttpServletResponse response, DBBroker broker, Sequence results, int howmany, int start, boolean typed, Properties outputProperties, boolean wrap, long compilationTime, long executionTime) throws BadRequestException {
        outputProperties.setProperty("sax-document-events", "false");
        try {
            String mimeType;
            String encoding = outputProperties.getProperty("encoding");
            if (!response.containsHeader("Content-Type") && (mimeType = outputProperties.getProperty("media-type")) != null) {
                int semicolon = mimeType.indexOf(59);
                if (semicolon != -1) {
                    mimeType = mimeType.substring(0, semicolon);
                }
                if (wrap) {
                    mimeType = "application/xml";
                }
                response.setContentType(mimeType + "; charset=" + encoding);
            }
            if (wrap) {
                outputProperties.setProperty("method", "xml");
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), encoding);
            XQuerySerializer serializer = new XQuerySerializer(broker, outputProperties, (Writer)writer);
            serializer.serialize(results, start, howmany, wrap, typed, compilationTime, executionTime);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (SAXException e) {
            LOG.warn((Object)e);
            throw new BadRequestException("Error while serializing xml: " + e.toString(), e);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new BadRequestException("Error while serializing xml: " + e.toString(), e);
        }
    }

    private void writeResultJSON(HttpServletResponse response, DBBroker broker, Sequence results, int howmany, int start, Properties outputProperties, boolean wrap, long compilationTime, long executionTime) throws BadRequestException {
        int rlen = results.getItemCount();
        if (!results.isEmpty()) {
            if (start < 1 || start > rlen) {
                throw new BadRequestException("Start parameter out of range");
            }
            if (howmany + start > rlen || howmany <= 0) {
                howmany = rlen - start + 1;
            }
        } else {
            howmany = 0;
        }
        Serializer serializer = broker.getSerializer();
        serializer.reset();
        outputProperties.setProperty("sax-document-events", "false");
        try {
            serializer.setProperties(outputProperties);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), outputProperties.getProperty("encoding"));
            JSONObject root = new JSONObject();
            root.addObject((JSONNode)new JSONSimpleProperty("start", Integer.toString(start), true));
            root.addObject((JSONNode)new JSONSimpleProperty("count", Integer.toString(howmany), true));
            root.addObject((JSONNode)new JSONSimpleProperty("hits", Integer.toString(results.getItemCount()), true));
            if (outputProperties.getProperty("serialization.session-id") != null) {
                root.addObject((JSONNode)new JSONSimpleProperty("session", outputProperties.getProperty("serialization.session-id")));
            }
            root.addObject((JSONNode)new JSONSimpleProperty("compilationTime", Long.toString(compilationTime), true));
            root.addObject((JSONNode)new JSONSimpleProperty("executionTime", Long.toString(executionTime), true));
            JSONObject data = new JSONObject("data");
            root.addObject((JSONNode)data);
            for (int i = --start; i < start + howmany; ++i) {
                Item item = results.itemAt(i);
                if (Type.subTypeOf((int)item.getType(), (int)-1)) {
                    JSONValue json;
                    NodeValue value = (NodeValue)item;
                    if ("json".equals(outputProperties.getProperty("method", "xml"))) {
                        json = new JSONValue(serializer.serialize(value), false);
                        json.setSerializationDataType(JSONNode.SerializationDataType.AS_LITERAL);
                    } else {
                        json = new JSONValue(serializer.serialize(value));
                        json.setSerializationType(JSONNode.SerializationType.AS_ARRAY);
                    }
                    data.addObject((JSONNode)json);
                    continue;
                }
                JSONValue json = new JSONValue(item.getStringValue());
                json.setSerializationType(JSONNode.SerializationType.AS_ARRAY);
                data.addObject((JSONNode)json);
            }
            root.serialize((Writer)writer, true);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new BadRequestException("Error while serializing xml: " + e.toString(), e);
        }
        catch (SAXException e) {
            throw new BadRequestException("Error while serializing xml: " + e.toString(), e);
        }
        catch (XPathException e) {
            throw new BadRequestException("Error while serializing xml: " + e.toString(), e);
        }
    }

    private boolean isExecutableType(DocumentImpl resource) {
        return resource != null && (MimeType.XQUERY_TYPE.getName().equals(resource.getMetadata().getMimeType()) || MimeType.XPROC_TYPE.getName().equals(resource.getMetadata().getMimeType()));
    }

    static {
        defaultProperties.setProperty("indent", "yes");
        defaultProperties.setProperty("encoding", "UTF-8");
        defaultProperties.setProperty("media-type", MimeType.XML_TYPE.getName());
        defaultProperties.setProperty("expand-xincludes", "yes");
        defaultProperties.setProperty("highlight-matches", "elements");
        defaultProperties.setProperty("process-xsl-pi", "yes");
        defaultOutputKeysProperties = new Properties();
        defaultOutputKeysProperties.setProperty("indent", "yes");
        defaultOutputKeysProperties.setProperty("encoding", "UTF-8");
        defaultOutputKeysProperties.setProperty("media-type", MimeType.XML_TYPE.getName());
    }

    public static class Namespace {
        private final String prefix;
        private final String uri;

        public Namespace(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUri() {
            return this.uri;
        }
    }

    private class NamespaceExtractor
    extends XMLFilterImpl {
        final List<Namespace> namespaces = new ArrayList<Namespace>();

        private NamespaceExtractor() {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (!"http://exist.sourceforge.net/NS/exist".equals(uri)) {
                Namespace ns = new Namespace(prefix, uri);
                this.namespaces.add(ns);
            }
            super.startPrefixMapping(prefix, uri);
        }

        public List<Namespace> getNamespaces() {
            return this.namespaces;
        }
    }
}

