/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xquery.value.Sequence;

@ThreadSafe
public class SessionManager {
    private static final Logger LOG = LogManager.getLogger(SessionManager.class);
    private static final long TIMEOUT = 120000L;
    private final AtomicInteger sessionIdCounter = new AtomicInteger();
    private final Cache<Integer, QueryResult> cache;

    public SessionManager() {
        Caffeine cacheBuilder = Caffeine.newBuilder().expireAfterAccess(120000L, TimeUnit.MILLISECONDS);
        if (LOG.isDebugEnabled()) {
            cacheBuilder.removalListener((key, value, cause) -> LOG.debug("Removing cached query result for session: " + key));
        }
        this.cache = cacheBuilder.build();
    }

    public int add(String query, Sequence sequence) {
        int sessionId = this.sessionIdCounter.getAndIncrement();
        this.cache.put((Object)sessionId, (Object)new QueryResult(query, sequence));
        return sessionId;
    }

    public Sequence get(String query, int sessionId) {
        if (sessionId < 0 || sessionId >= this.sessionIdCounter.get()) {
            return null;
        }
        QueryResult cached = (QueryResult)this.cache.getIfPresent((Object)sessionId);
        if (cached == null) {
            return null;
        }
        if (cached.query.equals(query)) {
            return cached.sequence;
        }
        return null;
    }

    public void release(int sessionId) {
        if (sessionId < 0 || sessionId >= this.sessionIdCounter.get()) {
            return;
        }
        this.cache.invalidate((Object)sessionId);
    }

    private static class QueryResult {
        final String query;
        final Sequence sequence;

        private QueryResult(String query, Sequence sequence) {
            this.query = query;
            this.sequence = sequence;
        }
    }
}

