/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.http.servlets.Authenticator;
import org.exist.http.servlets.BasicAuthenticator;
import org.exist.security.AuthenticationException;
import org.exist.security.Subject;
import org.exist.security.XmldbPrincipal;
import org.exist.security.internal.web.HttpAccount;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public abstract class AbstractExistHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = 804071766041263220L;
    public static final String DEFAULT_ENCODING = "UTF-8";
    private BrokerPool pool;
    private String formEncoding = "UTF-8";
    private String containerEncoding = "UTF-8";
    private String defaultUsername = "guest";
    private String defaultPassword = "guest";
    private Authenticator authenticator;
    private Subject defaultUser = null;
    private boolean internalOnly = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.setPool(this.getOrCreateBrokerPool(config));
        }
        catch (EXistException e) {
            throw new ServletException("No database instance available");
        }
        catch (DatabaseConfigurationException e) {
            throw new ServletException("Unable to configure database instance: " + e.getMessage(), (Throwable)e);
        }
        this.doGeneralExistServletConfig(config);
    }

    public void destroy() {
        super.destroy();
        BrokerPool.stopAll((boolean)false);
    }

    public abstract Logger getLog();

    private BrokerPool getOrCreateBrokerPool(ServletConfig config) throws EXistException, DatabaseConfigurationException, ServletException {
        if (BrokerPool.isConfigured()) {
            this.getLog().info("Database already started. Skipping configuration ...");
        } else {
            String confFile = Optional.ofNullable(config.getInitParameter("configuration")).orElse("conf.xml");
            Optional<Path> dbHome = Optional.ofNullable(config.getInitParameter("basedir")).map(baseDir -> Optional.ofNullable(config.getServletContext().getRealPath(baseDir)).map(rp -> Optional.of(Paths.get(rp, new String[0]))).orElse(Optional.ofNullable(config.getServletContext().getRealPath("/")).map(dir -> Paths.get(dir, new String[0]).resolve("WEB-INF").toAbsolutePath()))).orElse(Optional.ofNullable(config.getServletContext().getRealPath("/")).map(x$0 -> Paths.get(x$0, new String[0])));
            this.getLog().info("EXistServlet: exist.home=" + dbHome.map(Path::toString).orElse("null"));
            Path cf = dbHome.map(h -> h.resolve(confFile)).orElse(Paths.get(confFile, new String[0]));
            this.getLog().info("Reading configuration from " + cf.toAbsolutePath().toString());
            if (!Files.isReadable(cf)) {
                throw new ServletException("Configuration file " + confFile + " not found or not readable");
            }
            Configuration configuration = new Configuration(confFile, dbHome);
            String start = config.getInitParameter("start");
            if (start != null && "true".equals(start)) {
                this.doDatabaseStartup(configuration);
            }
        }
        return BrokerPool.getInstance();
    }

    private void doDatabaseStartup(Configuration configuration) throws ServletException {
        if (configuration == null) {
            throw new ServletException("Database has not been configured");
        }
        this.getLog().info("Configuring eXist instance");
        try {
            if (!BrokerPool.isConfigured()) {
                BrokerPool.configure((int)1, (int)5, (Configuration)configuration);
            }
        }
        catch (EXistException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (DatabaseConfigurationException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        try {
            this.getLog().info("Registering XMLDB driver");
            Class<?> clazz = Class.forName("org.exist.xmldb.DatabaseImpl");
            Database database = (Database)clazz.newInstance();
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (ClassNotFoundException e) {
            this.getLog().info("ERROR", (Throwable)e);
        }
        catch (InstantiationException e) {
            this.getLog().info("ERROR", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.getLog().info("ERROR", (Throwable)e);
        }
        catch (XMLDBException e) {
            this.getLog().info("ERROR", (Throwable)e);
        }
    }

    private void doGeneralExistServletConfig(ServletConfig config) {
        String param;
        String configContainerEncoding;
        String option = config.getInitParameter("use-default-user");
        boolean useDefaultUser = true;
        if (option != null) {
            useDefaultUser = "true".equals(option.trim());
        }
        if (useDefaultUser) {
            option = config.getInitParameter("user");
            if (option != null) {
                this.setDefaultUsername(option);
                option = config.getInitParameter("password");
                if (option != null) {
                    this.setDefaultPassword(option);
                }
                if (this.getDefaultUsername() != null) {
                    try {
                        this.setDefaultUser(this.getPool().getSecurityManager().authenticate(this.getDefaultUsername(), (Object)this.getDefaultPassword()));
                    }
                    catch (AuthenticationException e) {
                        this.setDefaultUser(null);
                    }
                } else {
                    this.setDefaultUser(null);
                }
            } else {
                this.setDefaultUser(this.pool.getSecurityManager().getGuestSubject());
            }
            if (this.getDefaultUser() != null) {
                this.getLog().info("Using default user " + this.getDefaultUsername() + " for all unauthorized requests.");
            } else {
                this.getLog().error("Default user " + this.getDefaultUsername() + " cannot be found.  A BASIC AUTH challenge will be the default.");
            }
        } else {
            this.getLog().info("No default user.  All requires must be authorized or will result in a BASIC AUTH challenge.");
            this.setDefaultUser(null);
        }
        this.setAuthenticator(new BasicAuthenticator(this.getPool()));
        String configFormEncoding = config.getInitParameter("form-encoding");
        if (configFormEncoding != null) {
            this.setFormEncoding(configFormEncoding);
        }
        if ((configContainerEncoding = config.getInitParameter("container-encoding")) != null) {
            this.setContainerEncoding(configContainerEncoding);
        }
        if ((param = config.getInitParameter("hidden")) != null) {
            this.internalOnly = Boolean.valueOf(param);
        }
    }

    protected Subject authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String auth;
        if (this.isInternalOnly() && request.getAttribute("org.exist.forward") == null) {
            response.sendError(403);
            return null;
        }
        Object principal = HttpAccount.getUserFromServletRequest((HttpServletRequest)request);
        if (principal != null) {
            return principal;
        }
        principal = request.getUserPrincipal();
        if (principal != null) {
            if (XmldbPrincipal.class.isAssignableFrom(principal.getClass())) {
                String username = ((XmldbPrincipal)principal).getName();
                String password = ((XmldbPrincipal)principal).getPassword();
                this.getLog().info("Validating Principle: " + username);
                try {
                    return this.getPool().getSecurityManager().authenticate(username, (Object)password);
                }
                catch (AuthenticationException e) {
                    this.getLog().info(e.getMessage());
                }
            }
            if (principal instanceof Subject) {
                return (Subject)principal;
            }
        }
        if ((auth = request.getHeader("Authorization")) == null && this.getDefaultUser() != null) {
            return this.getDefaultUser();
        }
        return this.getAuthenticator().authenticate(request, response);
    }

    protected boolean isInternalOnly() {
        return this.internalOnly;
    }

    private void setInternalOnly(boolean internalOnly) {
        this.internalOnly = internalOnly;
    }

    protected Subject getDefaultUser() {
        return this.defaultUser;
    }

    private void setDefaultUser(Subject defaultUser) {
        this.defaultUser = defaultUser;
    }

    protected Authenticator getAuthenticator() {
        return this.authenticator;
    }

    private void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    protected String getDefaultPassword() {
        return this.defaultPassword;
    }

    private void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    protected String getDefaultUsername() {
        return this.defaultUsername;
    }

    private void setDefaultUsername(String defaultUsername) {
        this.defaultUsername = defaultUsername;
    }

    protected String getContainerEncoding() {
        return this.containerEncoding;
    }

    private void setContainerEncoding(String containerEncoding) {
        this.containerEncoding = containerEncoding;
    }

    protected String getFormEncoding() {
        return this.formEncoding;
    }

    private void setFormEncoding(String formEncoding) {
        this.formEncoding = formEncoding;
    }

    protected BrokerPool getPool() {
        return this.pool;
    }

    private void setPool(BrokerPool pool) {
        this.pool = pool;
    }
}

