/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.http.servlets.Authenticator;
import org.exist.security.AuthenticationException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.util.Base64Decoder;

public class BasicAuthenticator
implements Authenticator {
    protected static final Logger LOG = LogManager.getLogger(BasicAuthenticator.class);
    private BrokerPool pool;

    public BasicAuthenticator(BrokerPool pool) {
        this.pool = pool;
    }

    @Override
    public Subject authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.authenticate(request, response, true);
    }

    @Override
    public Subject authenticate(HttpServletRequest request, HttpServletResponse response, boolean sendChallenge) throws IOException {
        String credentials = request.getHeader("Authorization");
        String username = null;
        String password = null;
        try {
            if (credentials != null) {
                Base64Decoder dec = new Base64Decoder();
                dec.translate((CharSequence)credentials.substring("Basic ".length()));
                byte[] c = dec.getByteArray();
                String s = new String(c);
                int p = s.indexOf(58);
                username = p < 0 ? s : s.substring(0, p);
                password = p < 0 ? null : s.substring(p + 1);
            }
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("Invalid BASIC authentication header received: " + iae.getMessage(), (Throwable)iae);
            credentials = null;
        }
        HttpSession session = request.getSession(false);
        Subject user = null;
        if (session != null && (user = (Subject)session.getAttribute("_eXist_xmldb_user")) != null && (username == null || user.getName().equals(username))) {
            return user;
        }
        if (user != null) {
            session.removeAttribute("_eXist_xmldb_user");
        }
        if (credentials == null) {
            if (sendChallenge) {
                this.sendChallenge(request, response);
            }
            return null;
        }
        SecurityManager secman = this.pool.getSecurityManager();
        try {
            user = secman.authenticate(username, password);
        }
        catch (AuthenticationException e) {
            if (sendChallenge) {
                this.sendChallenge(request, response);
            }
            return null;
        }
        if (session != null) {
            session.setAttribute("_eXist_xmldb_user", (Object)user);
        }
        return user;
    }

    @Override
    public void sendChallenge(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "Basic realm=\"exist\"");
        response.setStatus(401);
    }
}

