/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.http.servlets.Authenticator;
import org.exist.security.AbstractAccount;
import org.exist.security.MessageDigester;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.internal.AccountImpl;
import org.exist.security.internal.SubjectAccreditedImpl;
import org.exist.storage.BrokerPool;

public class DigestAuthenticator
implements Authenticator {
    private BrokerPool pool;

    public DigestAuthenticator(BrokerPool pool) {
        this.pool = pool;
    }

    @Override
    public Subject authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.authenticate(request, response, true);
    }

    @Override
    public Subject authenticate(HttpServletRequest request, HttpServletResponse response, boolean sendChallenge) throws IOException {
        String credentials = request.getHeader("Authorization");
        if (credentials == null) {
            this.sendChallenge(request, response);
            return null;
        }
        Digest digest = new Digest(request.getMethod());
        DigestAuthenticator.parseCredentials(digest, credentials);
        SecurityManager secman = this.pool.getSecurityManager();
        AccountImpl user = (AccountImpl)secman.getAccount(digest.username);
        if (user == null) {
            if (sendChallenge) {
                this.sendChallenge(request, response);
            }
            return null;
        }
        if (!digest.check(user.getDigestPassword())) {
            if (sendChallenge) {
                this.sendChallenge(request, response);
            }
            return null;
        }
        return new SubjectAccreditedImpl((AbstractAccount)user, (Object)this);
    }

    @Override
    public void sendChallenge(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "Digest realm=\"exist\", nonce=\"" + this.createNonce(request) + "\", domain=\"" + request.getContextPath() + "\", opaque=\"" + MessageDigester.md5((String)Integer.toString(this.hashCode(), 27), (boolean)false) + '\"');
        response.setStatus(401);
    }

    private String createNonce(HttpServletRequest request) {
        return MessageDigester.md5((String)(request.getRemoteAddr() + ':' + Long.toString(System.currentTimeMillis()) + ':' + Integer.toString(this.hashCode())), (boolean)false);
    }

    private static void parseCredentials(Digest digest, String credentials) {
        credentials = credentials.substring("Digest ".length());
        StringBuilder current = new StringBuilder();
        String name = null;
        boolean inQuotedString = false;
        block6: for (int i = 0; i < credentials.length(); ++i) {
            char ch = credentials.charAt(i);
            switch (ch) {
                case ' ': {
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    String value;
                    if (inQuotedString) {
                        value = current.toString();
                        current.setLength(0);
                        inQuotedString = false;
                        if ("username".equalsIgnoreCase(name)) {
                            digest.username = value;
                            continue block6;
                        }
                        if ("realm".equalsIgnoreCase(name)) {
                            digest.realm = value;
                            continue block6;
                        }
                        if ("nonce".equalsIgnoreCase(name)) {
                            digest.nonce = value;
                            continue block6;
                        }
                        if ("uri".equalsIgnoreCase(name)) {
                            digest.uri = value;
                            continue block6;
                        }
                        if (!"response".equalsIgnoreCase(name)) continue block6;
                        digest.response = value;
                        continue block6;
                    }
                    value = null;
                    inQuotedString = true;
                    continue block6;
                }
                case ',': {
                    name = null;
                    continue block6;
                }
                case '=': {
                    name = current.toString();
                    current.setLength(0);
                    continue block6;
                }
                default: {
                    current.append(ch);
                }
            }
        }
    }

    private static class Digest {
        String method = null;
        String username = null;
        String realm = null;
        String nonce = null;
        String uri = null;
        String response = null;

        public Digest(String method) {
            this.method = method;
        }

        public boolean check(String credentials) throws IOException {
            if (credentials == null) {
                return true;
            }
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.reset();
                md.update(this.method.getBytes(StandardCharsets.ISO_8859_1));
                md.update((byte)58);
                md.update(this.uri.getBytes(StandardCharsets.ISO_8859_1));
                byte[] ha2 = md.digest();
                md.update(credentials.getBytes(StandardCharsets.ISO_8859_1));
                md.update((byte)58);
                md.update(this.nonce.getBytes(StandardCharsets.ISO_8859_1));
                md.update((byte)58);
                md.update(MessageDigester.byteArrayToHex((byte[])ha2).getBytes(StandardCharsets.ISO_8859_1));
                byte[] digest = md.digest();
                return MessageDigester.byteArrayToHex((byte[])digest).equalsIgnoreCase(this.response);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("MD5 not supported");
            }
        }
    }
}

