/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.http.BadRequestException;
import org.exist.http.Descriptor;
import org.exist.http.NotFoundException;
import org.exist.http.RESTServer;
import org.exist.http.servlets.AbstractExistHttpServlet;
import org.exist.http.servlets.HttpServletRequestWrapper;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.validation.XmlLibraryChecker;
import org.exist.xmldb.XmldbURI;

public class EXistServlet
extends AbstractExistHttpServlet {
    private static final long serialVersionUID = -3563999345725645647L;
    private static final Logger LOG = LogManager.getLogger(EXistServlet.class);
    private RESTServer srvREST;

    @Override
    public Logger getLog() {
        return LOG;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String useDynamicContentType = config.getInitParameter("dynamic-content-type");
        if (useDynamicContentType == null) {
            useDynamicContentType = "no";
        }
        FeatureEnabled xquerySubmission = this.parseFeatureEnabled(config, "xquery-submission", FeatureEnabled.TRUE);
        FeatureEnabled xupdateSubmission = this.parseFeatureEnabled(config, "xupdate-submission", FeatureEnabled.TRUE);
        this.srvREST = new RESTServer(this.getPool(), this.getFormEncoding(), this.getContainerEncoding(), useDynamicContentType.equalsIgnoreCase("yes") || useDynamicContentType.equalsIgnoreCase("true"), this.isInternalOnly(), xquerySubmission, xupdateSubmission);
        XmlLibraryChecker.check();
    }

    private FeatureEnabled parseFeatureEnabled(ServletConfig config, String paramName, FeatureEnabled defaultValue) {
        String paramValue = config.getInitParameter(paramName);
        if (paramValue != null) {
            if (paramValue.equals("disabled")) {
                return FeatureEnabled.FALSE;
            }
            if (paramValue.equals("enabled")) {
                return FeatureEnabled.TRUE;
            }
            if (paramValue.equals("authenticated")) {
                return FeatureEnabled.AUTHENTICATED_USERS_ONLY;
            }
        }
        return defaultValue;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Subject user;
        String path = this.adjustPath(request);
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        if (descriptor != null) {
            path = descriptor.mapPath(path);
        }
        if ((user = this.authenticate(request, response)) == null) {
            return;
        }
        try (DBBroker broker = this.getPool().get(Optional.of(user));){
            XmldbURI dbpath = XmldbURI.createInternal((String)path);
            Collection collection = broker.getCollection(dbpath);
            if (collection != null) {
                response.sendError(400, "A PUT request is not allowed against a plain collection path.");
                return;
            }
            this.srvREST.doPut(broker, dbpath, request, response);
        }
        catch (BadRequestException e) {
            if (response.isCommitted()) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            response.sendError(400, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            if (user != null && user.equals(this.getDefaultUser())) {
                this.getAuthenticator().sendChallenge(request, response);
            } else {
                response.sendError(403, e.getMessage());
            }
        }
        catch (EXistException e) {
            if (response.isCommitted()) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            response.sendError(500, e.getMessage());
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            throw new ServletException("An unknown error occurred: " + e.getMessage(), e);
        }
    }

    private String adjustPath(HttpServletRequest request) throws ServletException {
        String path = request.getPathInfo();
        if (path == null) {
            return "";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" In: " + path);
        }
        try {
            URI u = URI.create("file://" + path.replaceAll("%2F", "%252F"));
            URI v = new URI("http", "host", u.getPath(), null).normalize();
            path = v.getRawPath().replaceAll("%252F", "%2F");
        }
        catch (URISyntaxException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Out: " + path);
        }
        return path;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Subject user;
        String path = this.adjustPath(request);
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        if (descriptor != null && !descriptor.requestsFiltered()) {
            descriptor.doLogRequestInReplayLog(request);
            path = descriptor.mapPath(path);
        }
        if ((user = this.authenticate(request, response)) == null) {
            return;
        }
        try (DBBroker broker = this.getPool().get(Optional.of(user));){
            this.srvREST.doGet(broker, request, response, path);
        }
        catch (BadRequestException e) {
            if (response.isCommitted()) {
                throw new ServletException(e.getMessage());
            }
            response.sendError(400, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            if (user != null && user.equals(this.getDefaultUser())) {
                this.getAuthenticator().sendChallenge(request, response);
            } else {
                response.sendError(403, e.getMessage());
            }
        }
        catch (NotFoundException e) {
            if (response.isCommitted()) {
                throw new ServletException(e.getMessage());
            }
            response.sendError(404, e.getMessage());
        }
        catch (EXistException e) {
            if (response.isCommitted()) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            response.sendError(500, e.getMessage());
        }
        catch (EOFException ee) {
            this.getLog().error("GET Connection has been interrupted", (Throwable)ee);
            throw new ServletException("GET Connection has been interrupted", (Throwable)ee);
        }
        catch (Throwable e) {
            this.getLog().error(e.getMessage(), e);
            throw new ServletException("An error occurred: " + e.getMessage(), e);
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Subject user;
        String path = this.adjustPath(request);
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        if (descriptor != null && !descriptor.requestsFiltered()) {
            descriptor.doLogRequestInReplayLog(request);
            path = descriptor.mapPath(path);
        }
        if ((user = this.authenticate(request, response)) == null) {
            return;
        }
        try (DBBroker broker = this.getPool().get(Optional.of(user));){
            this.srvREST.doHead(broker, request, response, path);
        }
        catch (BadRequestException e) {
            if (response.isCommitted()) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            response.sendError(400, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            if (user != null && user.equals(this.getDefaultUser())) {
                this.getAuthenticator().sendChallenge(request, response);
            } else {
                response.sendError(403, e.getMessage());
            }
        }
        catch (NotFoundException e) {
            if (response.isCommitted()) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            response.sendError(404, e.getMessage());
        }
        catch (EXistException e) {
            if (response.isCommitted()) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            response.sendError(500, e.getMessage());
        }
        catch (Throwable e) {
            this.getLog().error((Object)e);
            throw new ServletException("An unknown error occurred: " + e.getMessage(), e);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Subject user;
        String path = this.adjustPath(request);
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        if (descriptor != null) {
            path = descriptor.mapPath(path);
        }
        if ((user = this.authenticate(request, response)) == null) {
            return;
        }
        try (DBBroker broker = this.getPool().get(Optional.of(user));){
            this.srvREST.doDelete(broker, path, request, response);
        }
        catch (PermissionDeniedException e) {
            if (user != null && user.equals(this.getDefaultUser())) {
                this.getAuthenticator().sendChallenge(request, response);
            } else {
                response.sendError(403, e.getMessage());
            }
        }
        catch (NotFoundException e) {
            response.sendError(404, e.getMessage());
        }
        catch (EXistException e) {
            if (response.isCommitted()) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            response.sendError(500, e.getMessage());
        }
        catch (Throwable e) {
            this.getLog().error((Object)e);
            throw new ServletException("An unknown error occurred: " + e.getMessage(), e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        Subject user;
        HttpServletRequest request = null;
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        request = descriptor != null ? (descriptor.allowRequestLogging() ? new HttpServletRequestWrapper(req, this.getFormEncoding()) : req) : req;
        String path = request.getPathInfo();
        path = path == null ? "" : this.adjustPath(request);
        if (descriptor != null && !descriptor.requestsFiltered()) {
            descriptor.doLogRequestInReplayLog(request);
            path = descriptor.mapPath(path);
        }
        if ((user = this.authenticate(request, response)) == null) {
            return;
        }
        try (DBBroker broker = this.getPool().get(Optional.of(user));){
            this.srvREST.doPost(broker, request, response, path);
        }
        catch (PermissionDeniedException e) {
            if (user != null && user.equals(this.getDefaultUser())) {
                this.getAuthenticator().sendChallenge(request, response);
            } else {
                response.sendError(403, e.getMessage());
            }
        }
        catch (EXistException e) {
            if (response.isCommitted()) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            response.sendError(500, e.getMessage());
        }
        catch (BadRequestException e) {
            if (response.isCommitted()) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            response.sendError(400, e.getMessage());
        }
        catch (NotFoundException e) {
            if (response.isCommitted()) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            response.sendError(404, e.getMessage());
        }
        catch (Throwable e) {
            this.getLog().error((Object)e);
            throw new ServletException("An unknown error occurred: " + e.getMessage(), e);
        }
    }

    public static enum FeatureEnabled {
        FALSE,
        TRUE,
        AUTHENTICATED_USERS_ONLY;

    }
}

