/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.http.servlets.HttpSessionWrapper;
import org.exist.http.servlets.RequestWrapper;
import org.exist.http.servlets.SessionWrapper;

public class HttpRequestWrapper
implements RequestWrapper {
    private static Logger LOG = LogManager.getLogger((String)HttpRequestWrapper.class.getName());
    private HttpServletRequest servletRequest;
    private String formEncoding = null;
    private String containerEncoding = null;
    private String pathInfo = null;
    private String servletPath = null;
    private boolean isMultipartContent = false;
    private Map<String, Object> params = new LinkedHashMap<String, Object>();
    private boolean isFormDataParsed = false;

    public HttpRequestWrapper(HttpServletRequest servletRequest) {
        this(servletRequest, "UTF-8", "UTF-8");
    }

    public HttpRequestWrapper(HttpServletRequest servletRequest, String formEncoding, String containerEncoding) {
        this(servletRequest, formEncoding, containerEncoding, true);
    }

    public HttpRequestWrapper(HttpServletRequest servletRequest, String formEncoding, String containerEncoding, boolean parseMultipart) {
        this.servletRequest = servletRequest;
        this.formEncoding = formEncoding;
        this.containerEncoding = containerEncoding;
        this.pathInfo = servletRequest.getPathInfo();
        this.servletPath = servletRequest.getServletPath();
        this.parseParameters();
        this.isMultipartContent = ServletFileUpload.isMultipartContent((HttpServletRequest)servletRequest);
        if (parseMultipart && this.isMultipartContent) {
            this.isFormDataParsed = true;
            this.parseMultipartContent();
        }
        LOG.debug("Retrieved " + this.params.size() + " parameters.");
    }

    @Override
    public Object getAttribute(String name) {
        return this.servletRequest.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.servletRequest.getAttributeNames();
    }

    @Override
    public Cookie[] getCookies() {
        return this.servletRequest.getCookies();
    }

    private static void addParameter(Map<String, Object> map, String paramName, Object value) {
        Object original = map.get(paramName);
        if (original != null) {
            if (original instanceof List) {
                ((List)original).add(value);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(original);
                list.add(value);
                map.put(paramName, list);
            }
        } else {
            map.put(paramName, value);
        }
    }

    private void parseMultipartContent() {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(0);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            List items = upload.parseRequest(this.servletRequest);
            for (FileItem item : items) {
                HttpRequestWrapper.addParameter(this.params, item.getFieldName(), item);
            }
        }
        catch (FileUploadException e) {
            LOG.error((Object)e);
        }
    }

    private void parseParameters() {
        Map map = this.servletRequest.getParameterMap();
        for (Map.Entry param : map.entrySet()) {
            for (String value : (String[])param.getValue()) {
                HttpRequestWrapper.addParameter(this.params, (String)param.getKey(), this.decode(value));
            }
        }
    }

    private List<FileItem> getFileItem(Object obj) {
        LinkedList<FileItem> fileList = new LinkedList<FileItem>();
        if (obj instanceof List) {
            List list = (List)obj;
            for (Object listObject : list) {
                if (!(listObject instanceof FileItem) || ((FileItem)listObject).isFormField()) continue;
                fileList.add((FileItem)listObject);
            }
        } else if (obj instanceof FileItem && !((FileItem)obj).isFormField()) {
            fileList.add((FileItem)obj);
        }
        return fileList;
    }

    private String decode(String value) {
        if (this.formEncoding == null || value == null) {
            return value;
        }
        if (this.containerEncoding == null) {
            this.containerEncoding = "ISO-8859-1";
        }
        if (this.containerEncoding.equals(this.formEncoding)) {
            return value;
        }
        try {
            byte[] bytes = value.getBytes(this.containerEncoding);
            return new String(bytes, this.formEncoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)e);
            return value;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.servletRequest.getInputStream();
    }

    @Override
    public String getCharacterEncoding() {
        return this.servletRequest.getCharacterEncoding();
    }

    @Override
    public long getContentLength() {
        long retval = this.servletRequest.getContentLength();
        String lenstr = this.servletRequest.getHeader("Content-Length");
        if (lenstr != null) {
            retval = Long.parseLong(lenstr);
        }
        return retval;
    }

    @Override
    public String getContentType() {
        return this.servletRequest.getContentType();
    }

    @Override
    public String getContextPath() {
        return this.servletRequest.getContextPath();
    }

    @Override
    public String getHeader(String arg0) {
        return this.servletRequest.getHeader(arg0);
    }

    @Override
    public Enumeration getHeaderNames() {
        return this.servletRequest.getHeaderNames();
    }

    @Override
    public Enumeration getHeaders(String arg0) {
        return this.servletRequest.getHeaders(arg0);
    }

    @Override
    public String getMethod() {
        return this.servletRequest.getMethod();
    }

    @Override
    public String getParameter(String name) {
        Object o = this.params.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            List lst = (List)o;
            o = lst.get(0);
        }
        if (o instanceof FileItem) {
            FileItem fi = (FileItem)o;
            if (this.formEncoding == null) {
                return fi.getString();
            }
            try {
                return fi.getString(this.formEncoding);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)e);
                return null;
            }
        }
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    @Override
    public List<File> getFileUploadParam(String name) {
        if (!this.isFormDataParsed) {
            return null;
        }
        Object o = this.params.get(name);
        if (o == null) {
            return null;
        }
        List<FileItem> items = this.getFileItem(o);
        ArrayList<File> files = new ArrayList<File>(items.size());
        for (FileItem item : items) {
            files.add(((DiskFileItem)item).getStoreLocation());
        }
        return files;
    }

    @Override
    public List<String> getUploadedFileName(String name) {
        if (!this.isFormDataParsed) {
            return null;
        }
        Object o = this.params.get(name);
        if (o == null) {
            return null;
        }
        List<FileItem> items = this.getFileItem(o);
        ArrayList<String> files = new ArrayList<String>(items.size());
        for (FileItem item : items) {
            files.add(FilenameUtils.normalize((String)item.getName()));
        }
        return files;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.params.keySet());
    }

    @Override
    public String[] getParameterValues(String key) {
        String[] values;
        Object obj = this.params.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            values = new String[list.size()];
            int position = 0;
            for (Object object : list) {
                if (object instanceof FileItem) {
                    FileItem item = (FileItem)object;
                    try {
                        values[position] = this.formEncoding == null ? item.getString() : item.getString(this.formEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.warn((Object)e);
                        e.printStackTrace();
                    }
                } else {
                    values[position] = (String)object;
                }
                ++position;
            }
        } else {
            values = new String[1];
            if (obj instanceof FileItem) {
                FileItem item = (FileItem)obj;
                try {
                    values[0] = this.formEncoding == null ? item.getString() : item.getString(this.formEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn((Object)e);
                    e.printStackTrace();
                }
            } else {
                values[0] = (String)obj;
            }
        }
        return values;
    }

    @Override
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public String getPathTranslated() {
        return this.servletRequest.getPathTranslated();
    }

    @Override
    public String getProtocol() {
        return this.servletRequest.getProtocol();
    }

    @Override
    public String getQueryString() {
        return this.servletRequest.getQueryString();
    }

    @Override
    public String getRemoteAddr() {
        return this.servletRequest.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        return this.servletRequest.getRemoteHost();
    }

    @Override
    public int getRemotePort() {
        return this.servletRequest.getRemotePort();
    }

    @Override
    public String getRemoteUser() {
        return this.servletRequest.getRemoteUser();
    }

    @Override
    public String getRequestedSessionId() {
        return this.servletRequest.getRequestedSessionId();
    }

    @Override
    public String getRequestURI() {
        return this.servletRequest.getRequestURI();
    }

    @Override
    public StringBuffer getRequestURL() {
        return this.servletRequest.getRequestURL();
    }

    @Override
    public String getScheme() {
        return this.servletRequest.getScheme();
    }

    @Override
    public String getServerName() {
        return this.servletRequest.getServerName();
    }

    @Override
    public int getServerPort() {
        return this.servletRequest.getServerPort();
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public SessionWrapper getSession() {
        HttpSession session = this.servletRequest.getSession();
        if (session == null) {
            return null;
        }
        return new HttpSessionWrapper(session);
    }

    @Override
    public SessionWrapper getSession(boolean arg0) {
        HttpSession session = this.servletRequest.getSession(arg0);
        if (session == null) {
            return null;
        }
        return new HttpSessionWrapper(session);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.servletRequest.getUserPrincipal();
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return this.servletRequest.isRequestedSessionIdFromCookie();
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return this.servletRequest.isRequestedSessionIdFromURL();
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return this.servletRequest.isRequestedSessionIdValid();
    }

    @Override
    public boolean isSecure() {
        return this.servletRequest.isSecure();
    }

    @Override
    public boolean isUserInRole(String arg0) {
        return this.servletRequest.isUserInRole(arg0);
    }

    @Override
    public void removeAttribute(String arg0) {
        this.servletRequest.removeAttribute(arg0);
    }

    @Override
    public void setAttribute(String arg0, Object arg1) {
        this.servletRequest.setAttribute(arg0, arg1);
    }

    @Override
    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.servletRequest.setCharacterEncoding(arg0);
    }

    public void setPathInfo(String arg0) {
        this.pathInfo = arg0;
    }

    public void setServletPath(String arg0) {
        this.servletPath = arg0;
    }

    public boolean isFormDataParsed() {
        return this.isFormDataParsed;
    }

    @Override
    public boolean isMultipartContent() {
        return this.isMultipartContent;
    }
}

