/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.MimeType;
import org.exist.util.VirtualTempFile;

public class HttpServletRequestWrapper
implements HttpServletRequest {
    protected static final Logger LOG = LogManager.getLogger(HttpServletRequestWrapper.class);
    private HttpServletRequest request = null;
    private String formEncoding = null;
    private LinkedHashMap<String, Vector<RequestParamater>> params = null;
    private String contentBodyAsString;
    VirtualTempFile contentBody;

    public HttpServletRequestWrapper(HttpServletRequest request, String formEncoding) throws UnsupportedEncodingException {
        this.request = request;
        this.formEncoding = formEncoding;
        this.params = new LinkedHashMap();
        this.initialiseWrapper();
    }

    private void initialiseWrapper() throws UnsupportedEncodingException {
        int contentLength;
        if (this.request.getCharacterEncoding() == null) {
            this.request.setCharacterEncoding(this.formEncoding);
        } else {
            this.formEncoding = this.getCharacterEncoding();
        }
        this.parseURLParameters(this.request.getQueryString());
        if ("POST".equals(this.request.getMethod().toUpperCase()) && ((contentLength = this.request.getContentLength()) > 0 || contentLength == -1)) {
            String contentType = this.request.getContentType().toLowerCase();
            int semicolon = contentType.indexOf(59);
            if (semicolon > 0) {
                contentType = contentType.substring(0, semicolon).trim();
            }
            if ("application/x-www-form-urlencoded".equals(contentType) && this.request.getHeader("ContentType") == null) {
                this.parseContentBodyParameters();
            } else if (contentType.equals(MimeType.XML_TYPE.getName())) {
                try {
                    this.contentBodyAsString = this.getContentBody();
                }
                catch (IOException ioe) {
                    System.err.println("Error Reading the Content Body into the buffer: " + ioe);
                    ioe.printStackTrace();
                }
            }
        }
    }

    private void parseURLParameters(String querystring) {
        if (querystring != null) {
            this.parseParameters(querystring, 1);
        }
    }

    private void parseContentBodyParameters() {
        try {
            String content = this.getContentBody();
            this.parseParameters(content, 2);
        }
        catch (IOException ioe) {
            System.err.println("Error Reading the Content Body into the buffer: " + ioe);
            ioe.printStackTrace();
        }
    }

    private String getContentBody() throws IOException {
        this.recordContentBody();
        StringBuilder result = new StringBuilder();
        this.appendContentBody(result);
        return result.toString();
    }

    private void parseParameters(String parameters, int type) {
        String[] nameValuePairs = parameters.split("&");
        for (int k = 0; k < nameValuePairs.length; ++k) {
            Vector<Object> vecValues;
            String[] thePair = nameValuePairs[k].split("=");
            try {
                thePair[0] = URLDecoder.decode(thePair[0], this.formEncoding);
                if (thePair.length == 2) {
                    thePair[1] = URLDecoder.decode(thePair[1], this.formEncoding);
                }
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
            if (this.params.containsKey(thePair[0])) {
                vecValues = this.params.get(thePair[0]);
                vecValues.add(new RequestParamater(thePair.length == 2 ? thePair[1] : "", type));
                this.params.put(thePair[0], vecValues);
                continue;
            }
            vecValues = new Vector<RequestParamater>();
            vecValues.add(new RequestParamater(thePair.length == 2 ? thePair[1] : "", type));
            this.params.put(thePair[0], vecValues);
        }
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String name) {
        return this.request.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.request.getIntHeader(name);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathInfo();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String name) {
        return this.request.isUserInRole(name);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public String changeSessionId() {
        return this.request.changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromUrl();
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return this.request.authenticate(httpServletResponse);
    }

    public void login(String s, String s1) throws ServletException {
        this.request.login(s, s1);
    }

    public void logout() throws ServletException {
        this.request.logout();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.request.getParts();
    }

    public Part getPart(String s) throws IOException, ServletException {
        return this.request.getPart(s);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> clazz) throws IOException, ServletException {
        return (T)this.request.upgrade(clazz);
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(env);
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public long getContentLengthLong() {
        return this.request.getContentLengthLong();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.contentBodyRecorded()) {
            return new CachingServletInputStream();
        }
        return this.request.getInputStream();
    }

    public InputStream getContentBodyInputStream() throws IOException {
        this.recordContentBody();
        return this.contentBody.getByteStream();
    }

    private void recordContentBody() throws IOException {
        if (this.contentBody == null) {
            ServletInputStream is = this.request.getInputStream();
            long clen = this.request.getContentLength();
            String lenstr = this.request.getHeader("Content-Length");
            if (lenstr != null) {
                clen = Long.parseLong(lenstr);
            }
            this.contentBody = new VirtualTempFile();
            this.contentBody.setTempPrefix("existWRP");
            this.contentBody.setTempPostfix(".tmp");
            this.contentBody.write((InputStream)is, clen);
            this.contentBody.close();
        }
    }

    private void appendContentBody(Appendable buf) throws IOException {
        String line;
        this.recordContentBody();
        BufferedReader br = this.getReader();
        while ((line = br.readLine()) != null) {
            buf.append(line);
        }
    }

    public String getParameter(String name) {
        if (this.params.containsKey(name)) {
            Vector<RequestParamater> vecParameterValues = this.params.get(name);
            return vecParameterValues.get(0).getValue();
        }
        return null;
    }

    public Enumeration getParameterNames() {
        Object[] keySet = this.params.keySet().toArray();
        String[] strKeySet = new String[keySet.length];
        System.arraycopy(keySet, 0, strKeySet, 0, keySet.length);
        return new StringEnumeration(strKeySet);
    }

    public String[] getParameterValues(String name) {
        if (this.params.containsKey(name)) {
            Vector<RequestParamater> vecParameterValues = this.params.get(name);
            String[] values = new String[vecParameterValues.size()];
            for (int i = 0; i < vecParameterValues.size(); ++i) {
                values[i] = vecParameterValues.get(i).getValue();
            }
            return values;
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> mapParameters = new LinkedHashMap<String, String[]>();
        Set<Map.Entry<String, Vector<RequestParamater>>> setParams = this.params.entrySet();
        for (Map.Entry<String, Vector<RequestParamater>> me : setParams) {
            Vector<RequestParamater> vecParamValues = me.getValue();
            String[] values = new String[vecParamValues.size()];
            int i = 0;
            Iterator<RequestParamater> itParamValues = vecParamValues.iterator();
            while (itParamValues.hasNext()) {
                values[i] = itParamValues.next().getValue();
                ++i;
            }
            mapParameters.put(me.getKey(), values);
        }
        return mapParameters;
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this.contentBodyRecorded()) {
            String encoding = this.request.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            return new BufferedReader(new InputStreamReader(this.getContentBodyInputStream(), encoding));
        }
        return this.request.getReader();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.request.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String name) {
        return this.request.getRequestDispatcher(name);
    }

    public String getRealPath(String path) {
        return this.request.getSession().getServletContext().getRealPath(path);
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public ServletContext getServletContext() {
        return this.request.getServletContext();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.request.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return this.request.startAsync(servletRequest, servletResponse);
    }

    public boolean isAsyncStarted() {
        return this.request.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.request.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return this.request.getAsyncContext();
    }

    public DispatcherType getDispatcherType() {
        return this.request.getDispatcherType();
    }

    public String toString() {
        if (!(!"POST".equals(this.request.getMethod().toUpperCase()) || this.request.getContentLength() <= 0 && this.request.getContentLength() != -1 || this.request.getContentType().toUpperCase().startsWith("MULTIPART/") || this.contentBodyRecorded())) {
            StringBuilder buf = new StringBuilder(this.request.toString());
            Set<Map.Entry<String, Vector<RequestParamater>>> setParams = this.params.entrySet();
            for (Map.Entry<String, Vector<RequestParamater>> me : setParams) {
                Vector<RequestParamater> vecParamValues = me.getValue();
                for (RequestParamater p : vecParamValues) {
                    if (p.type != 2) continue;
                    if (buf.charAt(buf.length() - 1) != '\n') {
                        buf.append("&");
                    }
                    buf.append(me.getKey());
                    buf.append("=");
                    buf.append(p.getValue());
                }
            }
            buf.append(System.getProperty("line.separator")).append(System.getProperty("line.separator"));
            return buf.toString();
        }
        if (this.contentBodyRecorded()) {
            StringBuilder buf = new StringBuilder(this.request.toString());
            try {
                this.appendContentBody(buf);
            }
            catch (IOException ioe) {
                System.err.println("Error Reading the Content Body into the buffer: " + ioe);
                ioe.printStackTrace();
            }
            buf.append(System.getProperty("line.separator")).append(System.getProperty("line.separator"));
            return buf.toString();
        }
        return this.request.toString();
    }

    private boolean contentBodyRecorded() {
        return this.contentBody != null && this.contentBody.length() > 0L;
    }

    private class CachingServletInputStream
    extends ServletInputStream {
        private InputStream istream;

        public CachingServletInputStream() throws IOException {
            this.istream = HttpServletRequestWrapper.this.contentBody == null ? new ByteArrayInputStream(new byte[0]) : HttpServletRequestWrapper.this.contentBody.getByteStream();
        }

        public int read() throws IOException {
            return this.istream.read();
        }

        public int read(byte[] b) throws IOException {
            return this.istream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.istream.read(b, off, len);
        }

        public int available() throws IOException {
            return this.istream.available();
        }

        public boolean isFinished() {
            try {
                return this.istream.available() == 0;
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe);
                return true;
            }
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }
    }

    private static class RequestParamater {
        public static final int PARAM_TYPE_URL = 1;
        public static final int PARAM_TYPE_CONTENT = 2;
        private String value = null;
        private int type = 0;

        RequestParamater(String value, int type) {
            this.value = value;
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public int getType() {
            return this.type;
        }
    }

    private static class StringEnumeration
    implements Enumeration {
        private String[] strings = null;
        int aryPos = -1;

        StringEnumeration(String[] strings) {
            if (strings != null && strings.length > 0) {
                this.strings = new String[strings.length];
                System.arraycopy(strings, 0, this.strings, 0, strings.length);
                this.aryPos = 0;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.aryPos != -1 && this.aryPos < this.strings.length;
        }

        public Object nextElement() {
            if (this.aryPos != -1) {
                if (this.aryPos < this.strings.length) {
                    String s = this.strings[this.aryPos];
                    ++this.aryPos;
                    return s;
                }
                throw new NoSuchElementException("No more String's in the Enumeration, End Reached");
            }
            throw new NoSuchElementException("Enumeration is empty");
        }
    }
}

