/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.security.AuthenticationException;
import org.exist.security.Subject;
import org.exist.security.internal.web.HttpAccount;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.serializers.XIncludeFilter;
import org.exist.util.serializer.Receiver;
import org.exist.util.serializer.ReceiverToSAX;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SAXToReceiver;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.exist.xslt.Stylesheet;
import org.exist.xslt.TemplatesFactory;
import org.exist.xslt.XSLTErrorsListener;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XSLTServlet
extends HttpServlet {
    private static final long serialVersionUID = -7258405385386062151L;
    private static final String REQ_ATTRIBUTE_PREFIX = "xslt.";
    private static final String REQ_ATTRIBUTE_STYLESHEET = "xslt.stylesheet";
    private static final String REQ_ATTRIBUTE_INPUT = "xslt.input";
    private static final String REQ_ATTRIBUTE_OUTPUT = "xslt.output.";
    private static final String REQ_ATTRIBUTE_BASE = "xslt.base";
    private static final Logger LOG = LogManager.getLogger(XSLTServlet.class);
    private static final XSLTErrorsListener<ServletException> errorListener = new XSLTErrorsListener<ServletException>(true, false){

        protected void raiseError(String error, Exception ex) throws ServletException {
            throw new ServletException(error, (Throwable)ex);
        }
    };
    private BrokerPool pool;
    private Boolean caching = null;

    private boolean isCaching() {
        if (this.caching == null) {
            Object property = this.pool.getConfiguration().getProperty("transformer.caching");
            this.caching = property != null ? (Boolean)property : Boolean.valueOf(true);
        }
        return this.caching;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Stylesheet stylesheet;
        Object sourceObj;
        String uri = (String)request.getAttribute(REQ_ATTRIBUTE_STYLESHEET);
        if (uri == null) {
            throw new ServletException("No stylesheet source specified!");
        }
        Item inputNode = null;
        String sourceAttrib = (String)request.getAttribute(REQ_ATTRIBUTE_INPUT);
        if (sourceAttrib != null && (sourceObj = request.getAttribute(sourceAttrib)) != null) {
            ValueSequence seq;
            if (sourceObj instanceof ValueSequence && (seq = (ValueSequence)sourceObj).size() == 1) {
                sourceObj = seq.itemAt(0);
            }
            if (sourceObj instanceof Item) {
                inputNode = (Item)sourceObj;
                if (!Type.subTypeOf((int)inputNode.getType(), (int)-1)) {
                    throw new ServletException("Input for XSLT servlet is not a node. Read from attribute " + sourceAttrib);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Taking XSLT input from request attribute " + sourceAttrib);
                }
            } else {
                throw new ServletException("Input for XSLT servlet is not a node. Read from attribute " + sourceAttrib);
            }
        }
        try {
            this.pool = BrokerPool.getInstance();
        }
        catch (EXistException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        Subject user = this.pool.getSecurityManager().getGuestSubject();
        Subject requestUser = HttpAccount.getUserFromServletRequest((HttpServletRequest)request);
        if (requestUser != null) {
            user = requestUser;
        }
        String userParam = (String)request.getAttribute("xslt.user");
        String passwd = (String)request.getAttribute("xslt.password");
        if (userParam != null) {
            try {
                user = this.pool.getSecurityManager().authenticate(userParam, (Object)passwd);
            }
            catch (AuthenticationException e1) {
                response.sendError(403, "Wrong password or user");
                return;
            }
        }
        if ((stylesheet = this.stylesheet(uri, request, response)) == null) {
            return;
        }
        try (DBBroker broker = this.pool.get(Optional.of(user));){
            BufferedWriter writer;
            block44: {
                TransformerHandler handler = stylesheet.newTransformerHandler(broker, errorListener);
                this.setTransformerParameters(request, handler.getTransformer());
                Properties properties = handler.getTransformer().getOutputProperties();
                this.setOutputProperties(request, properties);
                String encoding = properties.getProperty("encoding");
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                response.setCharacterEncoding(encoding);
                String mediaType = properties.getProperty("media-type");
                if (mediaType != null) {
                    if (!mediaType.contains("charset")) {
                        response.setContentType(mediaType + "; charset=" + encoding);
                    } else {
                        response.setContentType(mediaType);
                    }
                }
                SAXSerializer sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
                writer = new BufferedWriter(response.getWriter());
                sax.setOutput((Writer)writer, properties);
                SAXResult result = new SAXResult((ContentHandler)sax);
                handler.setResult(result);
                Serializer serializer = broker.getSerializer();
                serializer.reset();
                ReceiverToSAX receiver = new ReceiverToSAX((ContentHandler)handler);
                try {
                    FilterInputStream stream;
                    XIncludeFilter xinclude = new XIncludeFilter(serializer, (Receiver)receiver);
                    receiver = xinclude;
                    String base = (String)request.getAttribute(REQ_ATTRIBUTE_BASE);
                    String baseUri = base != null ? this.getServletContext().getRealPath(base) : (uri.startsWith("xmldb:exist://") ? XmldbURI.xmldbUriFor((String)uri).getCollectionPath() : this.getCurrentDir(request).toAbsolutePath().toString());
                    xinclude.setModuleLoadPath(baseUri);
                    serializer.setReceiver((Receiver)receiver);
                    if (inputNode != null) {
                        serializer.toSAX((NodeValue)inputNode);
                        break block44;
                    }
                    SAXToReceiver saxreceiver = new SAXToReceiver((Receiver)receiver);
                    XMLReader reader = this.pool.getParserPool().borrowXMLReader();
                    reader.setContentHandler((ContentHandler)saxreceiver);
                    BufferedInputStream inStream = new BufferedInputStream((InputStream)request.getInputStream());
                    ((InputStream)inStream).mark(10);
                    try {
                        stream = new GZIPInputStream(inStream);
                    }
                    catch (IOException e) {
                        ((InputStream)inStream).reset();
                        stream = inStream;
                    }
                    reader.parse(new InputSource(stream));
                }
                catch (SAXParseException e) {
                    LOG.error(e.getMessage());
                    response.sendError(500, e.getMessage());
                }
                catch (SAXException e) {
                    throw new ServletException("SAX exception while transforming node: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    SerializerPool.getInstance().returnObject((Object)sax);
                }
            }
            ((Writer)writer).flush();
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new ServletException("IO exception while transforming node: " + e.getMessage(), (Throwable)e);
        }
        catch (TransformerException e) {
            throw new ServletException("Exception while transforming node: " + e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            throw new ServletException("An error occurred: " + e.getMessage(), e);
        }
    }

    private Stylesheet stylesheet(String stylesheet, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (stylesheet.indexOf(58) == -1) {
            Path f = Paths.get(stylesheet = stylesheet.replaceAll("//", "/"), new String[0]).normalize();
            if (Files.isReadable(f)) {
                stylesheet = f.toUri().toASCIIString();
            } else {
                if (stylesheet.startsWith("/")) {
                    String url = this.getServletContext().getRealPath(stylesheet);
                    if (url == null) {
                        response.sendError(404, "Stylesheet not found (URL: " + stylesheet + ")");
                        return null;
                    }
                    f = Paths.get(url, new String[0]);
                    stylesheet = f.toUri().toASCIIString();
                } else {
                    f = this.getCurrentDir(request).resolve(stylesheet);
                    stylesheet = f.toUri().toASCIIString();
                }
                if (!Files.isReadable(f)) {
                    response.sendError(404, "Stylesheet not found (URL: " + stylesheet + ")");
                    return null;
                }
            }
        }
        return TemplatesFactory.stylesheet((String)stylesheet, (String)"", (boolean)this.isCaching());
    }

    private Path getCurrentDir(HttpServletRequest request) {
        Path file;
        String path = request.getPathTranslated();
        if (path == null) {
            path = request.getRequestURI().substring(request.getContextPath().length());
            int p = path.lastIndexOf(47);
            if (p != -1) {
                path = path.substring(0, p);
            }
            path = this.getServletContext().getRealPath(path);
        }
        if (Files.isDirectory(file = Paths.get(path, new String[0]).normalize(), new LinkOption[0])) {
            return file;
        }
        return file.getParent();
    }

    private void setTransformerParameters(HttpServletRequest request, Transformer transformer) throws XPathException {
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            NodeValue nv;
            String name = (String)e.nextElement();
            if (!name.startsWith(REQ_ATTRIBUTE_PREFIX) || name.startsWith(REQ_ATTRIBUTE_OUTPUT) || REQ_ATTRIBUTE_INPUT.equals(name) || REQ_ATTRIBUTE_STYLESHEET.equals(name)) continue;
            Object value = request.getAttribute(name);
            if (value instanceof NodeValue && (nv = (NodeValue)value).getImplementationType() == 0) {
                value = nv.toMemNodeSet();
            }
            transformer.setParameter(name, value);
            transformer.setParameter(name.substring(REQ_ATTRIBUTE_PREFIX.length()), value);
        }
    }

    private void setOutputProperties(HttpServletRequest request, Properties properties) {
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            Object value;
            String name = (String)e.nextElement();
            if (!name.startsWith(REQ_ATTRIBUTE_OUTPUT) || (value = request.getAttribute(name)) == null) continue;
            properties.setProperty(name.substring(REQ_ATTRIBUTE_OUTPUT.length()), value.toString());
        }
    }
}

