/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.urlrewrite;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.http.urlrewrite.URLRewrite;
import org.exist.http.urlrewrite.XQueryURLRewrite;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Element;

public class ControllerForward
extends URLRewrite {
    private String serverName = null;

    public ControllerForward(Element config, String uri) {
        super(config, uri);
        this.target = config.getAttribute("path");
    }

    public ControllerForward(ControllerForward other) {
        super(other);
        this.serverName = other.serverName;
    }

    @Override
    public void doRewrite(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    @Override
    public boolean isControllerForward() {
        return true;
    }

    @Override
    protected void updateRequest(XQueryURLRewrite.RequestWrapper request) {
        super.updateRequest(request);
        if (this.target.length() != 0 && !"/".equals(this.target) && !this.target.startsWith("xmldb:")) {
            String oldURI = request.getInContextPath();
            String uri = this.target + oldURI;
            request.setInContextPath(uri);
        }
    }

    @Override
    protected void rewriteRequest(XQueryURLRewrite.RequestWrapper request) {
        if (this.target != null && this.target.startsWith("xmldb:")) {
            XmldbURI dbURI = XmldbURI.create((String)this.target);
            this.uri = "/rest";
            String colPath = dbURI.getCollectionPath();
            String contextPath = request.getInContextPath();
            if (contextPath.startsWith(colPath)) {
                colPath = "";
            }
            request.setPaths("/rest" + colPath + contextPath, "/rest");
            request.setBasePath("/rest" + colPath);
            request.setAttribute("org.exist.forward", "true");
        }
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    @Override
    protected URLRewrite copy() {
        return new ControllerForward(this);
    }
}

