/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.urlrewrite;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.exist.http.urlrewrite.Forward;
import org.exist.http.urlrewrite.URLRewrite;
import org.exist.http.urlrewrite.XQueryURLRewrite;
import org.w3c.dom.Element;

public class PathForward
extends Forward {
    private ServletConfig filterConfig;
    private String servletName = null;

    public PathForward(ServletConfig filterConfig, Element config, String uri) throws ServletException {
        super(config, uri);
        this.filterConfig = filterConfig;
        this.servletName = config.getAttribute("servlet");
        String url = config.getAttribute("url");
        if (this.servletName != null && this.servletName.length() == 0) {
            this.servletName = null;
        }
        if (this.servletName == null) {
            if (url == null || url.length() == 0) {
                throw new ServletException("<exist:forward> needs either an attribute 'url' or 'servlet'.");
            }
            this.setTarget(URLRewrite.normalizePath(url));
        }
    }

    protected PathForward(PathForward other) {
        super(other);
        this.filterConfig = other.filterConfig;
        this.servletName = other.servletName;
    }

    @Override
    protected void setAbsolutePath(XQueryURLRewrite.RequestWrapper request) {
        request.setPaths(this.target, this.servletName);
    }

    @Override
    protected RequestDispatcher getRequestDispatcher(HttpServletRequest request) {
        if (this.servletName != null) {
            return this.filterConfig.getServletContext().getNamedDispatcher(this.servletName);
        }
        if (request != null) {
            return request.getRequestDispatcher(this.target);
        }
        return this.filterConfig.getServletContext().getRequestDispatcher(this.target);
    }

    @Override
    protected URLRewrite copy() {
        return new PathForward(this);
    }
}

