/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.urlrewrite;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.http.servlets.HttpResponseWrapper;
import org.exist.http.urlrewrite.XQueryURLRewrite;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class URLRewrite {
    private static final String UNSET = "";
    protected String uri;
    protected String target;
    protected String prefix = null;
    protected String method = null;
    protected Map<String, String> attributes = null;
    protected Map<String, List<String>> parameters = null;
    protected Map<String, String> headers = null;
    protected boolean absolute = false;

    protected URLRewrite(Element config, String uri) {
        this.uri = uri;
        if (config != null && config.hasAttribute("absolute")) {
            this.absolute = "yes".equals(config.getAttribute("absolute"));
        }
        if (config != null && config.hasAttribute("method")) {
            this.method = config.getAttribute("method").toUpperCase();
        }
        if (config != null && config.hasChildNodes()) {
            for (Node node = config.getFirstChild(); node != null; node = node.getNextSibling()) {
                String ns = node.getNamespaceURI();
                if (node.getNodeType() != 1 || ns == null || !"http://exist.sourceforge.net/NS/exist".equals(ns)) continue;
                Element elem = (Element)node;
                if ("add-parameter".equals(elem.getLocalName())) {
                    this.addParameter(elem.getAttribute("name"), elem.getAttribute("value"));
                    continue;
                }
                if ("set-attribute".equals(elem.getLocalName())) {
                    this.setAttribute(elem.getAttribute("name"), elem.getAttribute("value"));
                    continue;
                }
                if ("clear-attribute".equals(elem.getLocalName())) {
                    this.unsetAttribute(elem.getAttribute("name"));
                    continue;
                }
                if (!"set-header".equals(elem.getLocalName())) continue;
                this.setHeader(elem.getAttribute("name"), elem.getAttribute("value"));
            }
        }
    }

    protected URLRewrite(URLRewrite other) {
        this.uri = other.uri;
        this.target = other.target;
        this.prefix = other.prefix;
        this.method = other.method;
    }

    protected void updateRequest(XQueryURLRewrite.RequestWrapper request) {
        if (this.prefix != null) {
            request.removePathPrefix(this.prefix);
        }
    }

    protected void rewriteRequest(XQueryURLRewrite.RequestWrapper request) {
    }

    protected void setAbsolutePath(XQueryURLRewrite.RequestWrapper request) {
        request.setPaths(this.target, null);
    }

    protected String getMethod() {
        return this.method;
    }

    protected boolean doResolve() {
        return !this.absolute;
    }

    protected String resolve(XQueryURLRewrite.RequestWrapper request) throws ServletException {
        String path = request.getInContextPath();
        if (this.target == null) {
            return path;
        }
        String fixedTarget = request.getBasePath() != null && this.target.startsWith("/") ? request.getBasePath() + this.target : this.target;
        try {
            URI reqURI = new URI(path);
            return reqURI.resolve(fixedTarget).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    protected void copyFrom(URLRewrite other) {
        if (other.headers != null) {
            this.headers = new HashMap<String, String>(other.headers);
        }
        if (other.attributes != null) {
            this.attributes = new HashMap<String, String>(other.attributes);
        }
        if (other.parameters != null) {
            this.parameters = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry : other.parameters.entrySet()) {
                this.parameters.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
        }
    }

    protected abstract URLRewrite copy();

    private void setHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
    }

    private void addNameValue(String name, String value, Map<String, List<String>> map) {
        List<String> values = map.get(name);
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(value);
        map.put(name, values);
    }

    private void addParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, List<String>>();
        }
        this.addNameValue(name, value, this.parameters);
    }

    private void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    private void unsetAttribute(String name) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, UNSET);
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    public void setPrefix(String prefix) {
        if (prefix.endsWith("/")) {
            prefix = prefix.replaceFirst("/+$", UNSET);
        }
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public abstract void doRewrite(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    public void prepareRequest(XQueryURLRewrite.RequestWrapper request) {
        if (this.parameters != null) {
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                for (String paramValue : (List)entry.getValue()) {
                    request.addParameter(entry.getKey(), paramValue);
                }
            }
        }
        if (this.attributes != null) {
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                String value = (String)entry.getValue();
                if (value.equals(UNSET)) {
                    request.removeAttribute(entry.getKey());
                    continue;
                }
                request.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void setHeaders(HttpResponseWrapper response) {
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                response.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean isControllerForward() {
        return false;
    }

    protected static String normalizePath(String path) {
        StringBuilder sb = new StringBuilder(path.length());
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (i != 0 && path.charAt(i - 1) == '/') continue;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

