/*
 * Decompiled with CFR 0.152.
 */
package org.exist.jetty;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.net.BindException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jcip.annotations.GuardedBy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.exist.SystemProperties;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.util.ConfigurationHelper;
import org.exist.util.FileUtils;
import org.exist.util.SingleInstanceConfiguration;
import org.exist.validation.XmlLibraryChecker;
import org.exist.xmldb.DatabaseImpl;
import org.exist.xmldb.ShutdownListener;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;

public class JettyStart
extends Observable
implements LifeCycle.Listener {
    public static final String JETTY_HOME_PROP = "jetty.home";
    public static final String JETTY_BASE_PROP = "jetty.base";
    private static final String JETTY_PROPETIES_FILENAME = "jetty.properties";
    private static final Logger logger = LogManager.getLogger(JettyStart.class);
    public static final String SIGNAL_STARTING = "jetty starting";
    public static final String SIGNAL_STARTED = "jetty started";
    public static final String SIGNAL_ERROR = "error";
    private static final int STATUS_STARTING = 0;
    private static final int STATUS_STARTED = 1;
    private static final int STATUS_STOPPING = 2;
    private static final int STATUS_STOPPED = 3;
    @GuardedBy(value="this")
    private int status = 3;
    @GuardedBy(value="this")
    private Optional<Thread> shutdownHook = Optional.empty();
    @GuardedBy(value="this")
    private int primaryPort = 8080;

    public static void main(String[] args) {
        JettyStart start = new JettyStart();
        start.run(args, null);
    }

    public JettyStart() {
        XmlLibraryChecker.check();
    }

    public synchronized void run() {
        String jettyProperty = Optional.ofNullable(System.getProperty(JETTY_HOME_PROP)).orElseGet(() -> {
            Optional home = ConfigurationHelper.getExistHome();
            Path jettyHome = FileUtils.resolve((Optional)home, (String)"tools").resolve("jetty");
            String jettyPath = jettyHome.toAbsolutePath().toString();
            System.setProperty(JETTY_HOME_PROP, jettyPath);
            return jettyPath;
        });
        Path standaloneFile = Paths.get(jettyProperty, new String[0]).resolve("etc").resolve("standalone.enabled-jetty-configs");
        this.run(new String[]{standaloneFile.toAbsolutePath().toString()}, null);
    }

    public synchronized void run(String[] args, Observer observer) {
        Map<String, String> configProperties;
        if (args.length == 0) {
            logger.error("No configuration file specified!");
            return;
        }
        Path jettyConfig = Paths.get(args[0], new String[0]);
        if (Files.notExists(jettyConfig, new LinkOption[0])) {
            logger.error("Configuration file: {} does not exist!", (Object)jettyConfig.toAbsolutePath().toString());
            return;
        }
        try {
            configProperties = this.getConfigProperties(jettyConfig.getParent());
            if (observer != null) {
                this.addObserver(observer);
            }
            logger.info("Running with Java {} [{} ({}) in {}]", (Object)System.getProperty("java.version", "(unknown java.version)"), (Object)System.getProperty("java.vendor", "(unknown java.vendor)"), (Object)System.getProperty("java.vm.name", "(unknown java.vm.name)"), (Object)System.getProperty("java.home", "(unknown java.home)"));
            logger.info("Running as user '{}'", (Object)System.getProperty("user.name", "(unknown user.name)"));
            logger.info("[eXist Home : {}]", (Object)System.getProperty("exist.home", "unknown"));
            logger.info("[eXist Version : {}]", (Object)SystemProperties.getInstance().getSystemProperty("product-version", "unknown"));
            logger.info("[eXist Build : {}]", (Object)SystemProperties.getInstance().getSystemProperty("product-build", "unknown"));
            logger.info("[Git commit : {}]", (Object)SystemProperties.getInstance().getSystemProperty("git-commit", "unknown"));
            logger.info("[Operating System : {} {} {}]", (Object)System.getProperty("os.name"), (Object)System.getProperty("os.version"), (Object)System.getProperty("os.arch"));
            logger.info("[log4j.configurationFile : {}]", (Object)System.getProperty("log4j.configurationFile"));
            logger.info("[jetty Version: {}]", (Object)JettyStart.getJettyVersion(configProperties.get(JETTY_BASE_PROP)));
            logger.info("[{} : {}]", (Object)JETTY_HOME_PROP, (Object)configProperties.get(JETTY_HOME_PROP));
            logger.info("[{} : {}]", (Object)JETTY_BASE_PROP, (Object)configProperties.get(JETTY_BASE_PROP));
            logger.info("[jetty configuration : {}]", (Object)jettyConfig.toAbsolutePath().toString());
            SingleInstanceConfiguration config = args.length == 2 ? new SingleInstanceConfiguration(args[1]) : new SingleInstanceConfiguration();
            logger.info("Configuring eXist from {}", (Object)config.getConfigFilePath().map(Path::normalize).map(Path::toAbsolutePath).map(Path::toString).orElse("<UNKNOWN>"));
            BrokerPool.configure((int)1, (int)5, (Configuration)config, Optional.ofNullable(observer));
            DatabaseImpl xmldb = new DatabaseImpl();
            xmldb.setProperty("create-database", "false");
            DatabaseManager.registerDatabase((Database)xmldb);
        }
        catch (Exception e) {
            logger.error("configuration error: " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return;
        }
        try {
            List<Path> configFiles = this.getEnabledConfigFiles(jettyConfig);
            ArrayList<Object> configuredObjects = new ArrayList<Object>();
            XmlConfiguration last = null;
            for (Path confFile : configFiles) {
                logger.info("[loading jetty configuration : {}]", (Object)confFile.toString());
                InputStream is = Files.newInputStream(confFile, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    XmlConfiguration configuration = new XmlConfiguration(is);
                    if (last != null) {
                        configuration.getIdMap().putAll(last.getIdMap());
                    }
                    configuration.getProperties().putAll(configProperties);
                    configuredObjects.add(configuration.configure());
                    last = configuration;
                }
                catch (Throwable configuration) {
                    throwable = configuration;
                    throw configuration;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable configuration) {
                            throwable.addSuppressed(configuration);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            Optional<Server> maybeServer = this.startJetty(configuredObjects);
            if (!maybeServer.isPresent()) {
                logger.error("Unable to find a server to start in jetty configurations");
                throw new IllegalStateException();
            }
            Server server = maybeServer.get();
            Connector[] connectors = server.getConnectors();
            StringBuilder allPorts = new StringBuilder();
            if (connectors.length > 1) {
                allPorts.append("s");
            }
            boolean establishedPrimaryPort = false;
            for (Connector connector : connectors) {
                if (!(connector instanceof NetworkConnector)) continue;
                NetworkConnector networkConnector = (NetworkConnector)connector;
                if (!establishedPrimaryPort) {
                    this.primaryPort = networkConnector.getLocalPort();
                    establishedPrimaryPort = true;
                }
                allPorts.append(" ");
                allPorts.append(networkConnector.getLocalPort());
            }
            Class<?> openid = null;
            try {
                openid = Class.forName("org.exist.security.realm.openid.AuthenticatorOpenIdServlet");
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                logger.warn("Could not find OpenID extension. OpenID will be disabled!");
            }
            Class<?> oauth = null;
            try {
                oauth = Class.forName("org.exist.security.realm.oauth.OAuthServlet");
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                logger.warn("Could not find OAuthServlet extension. OAuth will be disabled!");
            }
            Class<?> iprange = null;
            try {
                iprange = Class.forName("org.exist.security.realm.iprange.IPRangeServlet");
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                logger.warn("Could not find IPRangeServlet extension. IPRange will be disabled!");
            }
            List<URI> serverUris = this.getSeverURIs(server);
            if (!serverUris.isEmpty()) {
                this.primaryPort = serverUris.get(0).getPort();
            }
            logger.info("-----------------------------------------------------");
            logger.info("Server has started, listening on:");
            for (URI serverUri : serverUris) {
                logger.info("\t{}", (Object)serverUri.resolve("/"));
            }
            logger.info("Configured contexts:");
            LinkedHashSet<Handler> handlers = this.getAllHandlers(server.getHandler());
            for (Handler handler : handlers) {
                String suffix;
                ContextHandler contextHandler;
                if (handler instanceof ContextHandler) {
                    contextHandler = (ContextHandler)handler;
                    logger.info("\t{}", (Object)contextHandler.getContextPath());
                }
                if (openid != null && handler instanceof ServletContextHandler) {
                    contextHandler = (ServletContextHandler)handler;
                    contextHandler.addServlet(new ServletHolder(openid), "/openid");
                    suffix = contextHandler.getContextPath().endsWith("/") ? "openid" : "/openid";
                    logger.info("\t{}", (Object)(contextHandler.getContextPath() + suffix));
                }
                if (oauth != null && handler instanceof ServletContextHandler) {
                    contextHandler = (ServletContextHandler)handler;
                    contextHandler.addServlet(new ServletHolder(oauth), "/oauth/*");
                    suffix = contextHandler.getContextPath().endsWith("/") ? "oauth" : "/oauth";
                    logger.info("\t{}", (Object)(contextHandler.getContextPath() + suffix));
                }
                if (iprange == null || !(handler instanceof ServletContextHandler)) continue;
                contextHandler = (ServletContextHandler)handler;
                contextHandler.addServlet(new ServletHolder(iprange), "/iprange");
                suffix = contextHandler.getContextPath().endsWith("/") ? "iprange" : "/iprange";
                logger.info("'" + contextHandler.getContextPath() + suffix + "'");
            }
            logger.info("-----------------------------------------------------");
            this.setChanged();
            this.notifyObservers(SIGNAL_STARTED);
        }
        catch (MultiException e) {
            boolean hasBindException = false;
            for (Throwable t : e.getThrowables()) {
                if (!(t instanceof BindException)) continue;
                hasBindException = true;
                logger.error("----------------------------------------------------------");
                logger.error("ERROR: Could not bind to port because {}", (Object)t.getMessage());
                logger.error(t.toString());
                logger.error("----------------------------------------------------------");
            }
            if (!hasBindException) {
                e.printStackTrace();
            }
            this.setChanged();
            this.notifyObservers(SIGNAL_ERROR);
        }
        catch (SocketException e) {
            logger.error("----------------------------------------------------------");
            logger.error("ERROR: Could not bind to port because {}", (Object)e.getMessage());
            logger.error(e.toString());
            logger.error("----------------------------------------------------------");
            this.setChanged();
            this.notifyObservers(SIGNAL_ERROR);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setChanged();
            this.notifyObservers(SIGNAL_ERROR);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJettyVersion(String jettyBase) {
        Path jettyLib = Paths.get(jettyBase, "lib");
        if (!Files.exists(jettyLib, new LinkOption[0])) return "<UNKNOWN>";
        try (Stream<Path> children = Files.list(jettyLib);){
            Optional<Path> jettyServerJar = children.filter(child -> {
                String fileName = FileUtils.fileName((Path)child);
                return fileName.startsWith("jetty-server") && fileName.endsWith(".jar");
            }).findFirst();
            if (!jettyServerJar.isPresent()) return "<UNKNOWN>";
            JarFile jarFile = new JarFile(jettyServerJar.get().toFile());
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) return "<UNKNOWN>";
            Attributes mainAttributes = manifest.getMainAttributes();
            if (mainAttributes == null) return "<UNKNOWN>";
            String jettyVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            if (jettyVersion == null) return "<UNKNOWN>";
            String string = jettyVersion;
            return string;
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
        }
        return "<UNKNOWN>";
    }

    private LinkedHashSet<Handler> getAllHandlers(Handler handler) {
        if (handler instanceof HandlerWrapper) {
            HandlerWrapper handlerWrapper = (HandlerWrapper)handler;
            LinkedHashSet<Handler> handlers = new LinkedHashSet<Handler>();
            handlers.add((Handler)handlerWrapper);
            if (handlerWrapper.getHandler() != null) {
                handlers.addAll(this.getAllHandlers(handlerWrapper.getHandler()));
            }
            return handlers;
        }
        if (handler instanceof HandlerContainer) {
            HandlerContainer handlerContainer = (HandlerContainer)handler;
            LinkedHashSet<Handler> handlers = new LinkedHashSet<Handler>();
            handlers.add(handler);
            for (Handler childHandler : handlerContainer.getChildHandlers()) {
                handlers.addAll(this.getAllHandlers(childHandler));
            }
            return handlers;
        }
        LinkedHashSet<Handler> handlers = new LinkedHashSet<Handler>();
        handlers.add(handler);
        return handlers;
    }

    private List<URI> getSeverURIs(Server server) {
        ContextHandler context = (ContextHandler)server.getChildHandlerByClass(ContextHandler.class);
        return Arrays.stream(server.getConnectors()).filter(connector -> connector instanceof NetworkConnector).map(connector -> (NetworkConnector)connector).map(networkConnector -> this.getURI((NetworkConnector)networkConnector, context)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private URI getURI(NetworkConnector networkConnector, ContextHandler context) {
        try {
            String path;
            String protocol = networkConnector.getDefaultConnectionFactory().getProtocol();
            String scheme = protocol.startsWith("SSL-") || protocol.equals("SSL") ? "https" : "http";
            String host = null;
            host = context != null && context.getVirtualHosts() != null && context.getVirtualHosts().length > 0 ? context.getVirtualHosts()[0] : networkConnector.getHost();
            if (host == null) {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            String string = path = context == null ? null : context.getContextPath();
            if (path == null) {
                path = "/";
            }
            return new URI(scheme, null, host, networkConnector.getLocalPort(), path, null, null);
        }
        catch (URISyntaxException | UnknownHostException e) {
            logger.warn((Object)e);
            return null;
        }
    }

    private Optional<Server> startJetty(List<Object> configuredObjects) throws Exception {
        Optional<Server> server = Optional.empty();
        for (Object configuredObject : configuredObjects) {
            LifeCycle lc;
            if (configuredObject instanceof Server) {
                Server _server = (Server)configuredObject;
                if (server.map(configuredServer -> configuredServer == _server).orElse(false).booleanValue()) continue;
                _server.addLifeCycleListener((LifeCycle.Listener)this);
                BrokerPool.getInstance().registerShutdownListener((ShutdownListener)new ShutdownListenerImpl(_server));
                BrokerPoolAndJettyShutdownHook brokerPoolAndJettyShutdownHook = new BrokerPoolAndJettyShutdownHook(_server);
                Runtime.getRuntime().addShutdownHook(brokerPoolAndJettyShutdownHook);
                this.shutdownHook = Optional.of(brokerPoolAndJettyShutdownHook);
                server = Optional.of(_server);
            }
            if (!(configuredObject instanceof LifeCycle) || (lc = (LifeCycle)configuredObject).isRunning()) continue;
            logger.info("[Starting jetty component : {}]", (Object)lc.getClass().getName());
            lc.start();
        }
        return server;
    }

    private Map<String, String> getConfigProperties(Path configDir) throws IOException {
        HashMap<String, String> configProperties = new HashMap<String, String>();
        Path propertiesFile = configDir.resolve(JETTY_PROPETIES_FILENAME);
        if (Files.exists(propertiesFile, new LinkOption[0])) {
            Properties jettyProperties = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(propertiesFile);){
                jettyProperties.load(reader);
                logger.info("Loaded jetty.properties from: {}", (Object)propertiesFile.toAbsolutePath().toString());
                for (Map.Entry<Object, Object> property : jettyProperties.entrySet()) {
                    configProperties.put(property.getKey().toString(), property.getValue().toString());
                }
            }
        }
        configProperties.put(JETTY_HOME_PROP, System.getProperty(JETTY_HOME_PROP));
        configProperties.put(JETTY_BASE_PROP, System.getProperty(JETTY_BASE_PROP, System.getProperty(JETTY_HOME_PROP)));
        return configProperties;
    }

    private List<Path> getEnabledConfigFiles(Path enabledJettyConfigs) throws IOException {
        if (Files.notExists(enabledJettyConfigs, new LinkOption[0])) {
            throw new IOException("Cannot find config enabler: " + enabledJettyConfigs.toString());
        }
        ArrayList<Path> configFiles = new ArrayList<Path>();
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(enabledJettyConfigs));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String tl = line.trim();
                if (tl.isEmpty() || tl.charAt(0) == '#') continue;
                Path configFile = enabledJettyConfigs.getParent().resolve(tl);
                if (Files.notExists(configFile, new LinkOption[0])) {
                    throw new IOException("Cannot find enabled config: " + configFile.toString());
                }
                configFiles.add(configFile);
            }
        }
        return configFiles;
    }

    public synchronized void shutdown() {
        this.shutdownHook.ifPresent(Runtime.getRuntime()::removeShutdownHook);
        BrokerPool.stopAll((boolean)false);
        while (this.status != 3) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized boolean isStarted() {
        if (this.status == 1 || this.status == 0) {
            return true;
        }
        if (this.status == 3) {
            return false;
        }
        while (this.status != 3) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    public synchronized void lifeCycleStarting(LifeCycle lifeCycle) {
        logger.info("Jetty server starting...");
        this.setChanged();
        this.notifyObservers(SIGNAL_STARTING);
        this.status = 0;
        this.notifyAll();
    }

    public synchronized void lifeCycleStarted(LifeCycle lifeCycle) {
        logger.info("Jetty server started.");
        this.setChanged();
        this.notifyObservers(SIGNAL_STARTED);
        this.status = 1;
        this.notifyAll();
    }

    public void lifeCycleFailure(LifeCycle lifeCycle, Throwable throwable) {
    }

    public synchronized void lifeCycleStopping(LifeCycle lifeCycle) {
        logger.info("Jetty server stopping...");
        this.status = 2;
        this.notifyAll();
    }

    public synchronized void lifeCycleStopped(LifeCycle lifeCycle) {
        logger.info("Jetty server stopped");
        this.status = 3;
        this.notifyAll();
    }

    public synchronized int getPrimaryPort() {
        return this.primaryPort;
    }

    private static class BrokerPoolAndJettyShutdownHook
    extends Thread {
        private final Server server;

        BrokerPoolAndJettyShutdownHook(Server server) {
            super("exist-jettyStart-shutdownHook");
            this.server = server;
        }

        @Override
        public void run() {
            BrokerPool.stopAll((boolean)true);
            if (this.server.isStopping() || this.server.isStopped()) {
                return;
            }
            try {
                this.server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class ShutdownListenerImpl
    implements ShutdownListener {
        private final Server server;

        ShutdownListenerImpl(Server server) {
            this.server = server;
        }

        public void shutdown(String dbname, int remainingInstances) {
            logger.info("Database shutdown: stopping server in 1sec ...");
            if (remainingInstances == 0) {
                Timer timer = new Timer("jetty shutdown schedule", true);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            server.stop();
                            server.join();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, 1000L);
            }
        }
    }
}

