/*
 * Decompiled with CFR 0.152.
 */
package org.exist.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.util.ArgumentUtil;
import org.exist.util.ConfigurationHelper;
import org.exist.xmldb.DatabaseInstanceManager;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentBuilder;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.Arguments;
import se.softhouse.jargo.CommandLineParser;
import se.softhouse.jargo.ParsedArguments;

public class ServerShutdown {
    private static final Argument<?> helpArg = Arguments.helpArgument((String)"-h", (String[])new String[]{"--help"});
    private static final Argument<String> userArg = ((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-u", "--user"}).description("specify username (has to be a member of group dba).")).defaultValue((Object)"admin")).build();
    private static final Argument<String> passwordArg = ((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-p", "--password"}).description("specify password for the user.")).defaultValue((Object)"")).build();
    private static final Argument<String> uriArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-l", "--uri"}).description("the XML:DB URI of the database instance to be shut down.")).build();

    public static void main(String[] args) {
        try {
            ParsedArguments arguments = CommandLineParser.withArguments((Argument[])new Argument[]{userArg, passwordArg, uriArg}).andArguments(new Argument[]{helpArg}).parse(args);
            ServerShutdown.process(arguments);
        }
        catch (ArgumentException e) {
            System.out.println(e.getMessageAndUsage());
            System.exit(3);
        }
    }

    private static void process(ParsedArguments arguments) {
        Properties properties = ServerShutdown.loadProperties();
        String user = (String)arguments.get(userArg);
        String passwd = (String)arguments.get(passwordArg);
        String uri = ArgumentUtil.getOpt((ParsedArguments)arguments, uriArg).orElseGet(() -> properties.getProperty("uri", "xmldb:exist://localhost:8080/exist/xmlrpc"));
        try {
            Class<?> cl = Class.forName("org.exist.xmldb.DatabaseImpl");
            Database database = (Database)cl.newInstance();
            DatabaseManager.registerDatabase((Database)database);
            if (!uri.endsWith("/db")) {
                uri = uri + "/db";
            }
            Collection root = DatabaseManager.getCollection((String)uri, (String)user, (String)passwd);
            DatabaseInstanceManager manager = (DatabaseInstanceManager)root.getService("DatabaseInstanceManager", "1.0");
            System.out.println("Shutting down database instance at ");
            System.out.println('\t' + uri);
            manager.shutdown();
        }
        catch (XMLDBException e) {
            System.err.println("ERROR: " + e.getMessage());
            Throwable t = e.getCause();
            if (t != null && t instanceof XmlRpcException) {
                System.err.println("CAUSE: " + t.getMessage());
            } else {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Properties loadProperties() {
        Properties properties;
        block27: {
            Path propFile = ConfigurationHelper.lookup((String)"client.properties");
            properties = new Properties();
            try {
                if (Files.isReadable(propFile)) {
                    try (InputStream pin = Files.newInputStream(propFile, new OpenOption[0]);){
                        properties.load(pin);
                        break block27;
                    }
                }
                try (InputStream pin = ServerShutdown.class.getResourceAsStream("client.properties");){
                    properties.load(pin);
                }
            }
            catch (IOException e) {
                System.err.println("WARN - Unable to load properties from: " + propFile.toAbsolutePath().toString());
            }
        }
        return properties;
    }
}

