/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webstart;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JnlpHelper {
    private static final String LIB_CORE = "../lib/core";
    private static final String LIB_EXIST = "..";
    private static final String LIB_WEBINF = "WEB-INF/lib/";
    private static final Logger LOGGER = LogManager.getLogger(JnlpHelper.class);
    private Path coreJarsFolder = null;
    private Path existJarFolder = null;
    private Path webappsFolder = null;

    private boolean isInWarFile(Path existHome) {
        return !Files.isDirectory(existHome.resolve(LIB_CORE), new LinkOption[0]);
    }

    public JnlpHelper(Path contextRoot) {
        if (this.isInWarFile(contextRoot)) {
            LOGGER.debug("eXist is running in servlet container (.war).");
            this.existJarFolder = this.coreJarsFolder = contextRoot.resolve(LIB_WEBINF).normalize();
            this.webappsFolder = contextRoot;
        } else {
            LOGGER.debug("eXist is running private jetty server.");
            this.coreJarsFolder = contextRoot.resolve(LIB_CORE).normalize();
            this.existJarFolder = contextRoot.resolve(LIB_EXIST).normalize();
            this.webappsFolder = contextRoot;
        }
        LOGGER.debug(String.format("CORE jars location=%s", this.coreJarsFolder.toAbsolutePath().toString()));
        LOGGER.debug(String.format("EXIST jars location=%s", this.existJarFolder.toAbsolutePath().toString()));
        LOGGER.debug(String.format("WEBAPP location=%s", this.webappsFolder.toAbsolutePath().toString()));
    }

    public Path getWebappFolder() {
        return this.webappsFolder;
    }

    public Path getCoreJarsFolder() {
        return this.coreJarsFolder;
    }

    public Path getExistJarFolder() {
        return this.existJarFolder;
    }
}

