/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webstart;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.webstart.JnlpHelper;
import org.exist.webstart.JnlpJarFiles;
import org.exist.webstart.JnlpWriter;

public class JnlpServlet
extends HttpServlet {
    private static final long serialVersionUID = 1238966115449192258L;
    private static final Logger LOGGER = LogManager.getLogger(JnlpServlet.class);
    private JnlpJarFiles jf = null;
    private JnlpHelper jh = null;

    public void init() throws ServletException {
        LOGGER.info("Initializing JNLP servlet");
        String realPath = this.getServletContext().getRealPath("/");
        if (realPath == null) {
            String txt = "getServletContext().getRealPath() did not return a value. Webstart is not available.";
            LOGGER.error("getServletContext().getRealPath() did not return a value. Webstart is not available.");
            throw new ServletException("getServletContext().getRealPath() did not return a value. Webstart is not available.");
        }
        Path contextRoot = Paths.get(realPath, new String[0]).normalize();
        this.jh = new JnlpHelper(contextRoot);
        this.jf = new JnlpJarFiles(this.jh);
    }

    private String stripFilename(String URI2) {
        int lastPos = URI2.lastIndexOf(47);
        return URI2.substring(lastPos + 1);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            JnlpWriter jw = new JnlpWriter();
            String requestURI = request.getRequestURI();
            String filename = this.stripFilename(request.getPathInfo());
            LOGGER.debug("Requested URI=" + requestURI);
            if (requestURI.endsWith(".jnlp")) {
                jw.writeJnlpXML(this.jf, request, response);
            } else if (requestURI.endsWith(".jar") || requestURI.endsWith(".jar.pack.gz")) {
                jw.sendJar(this.jf, filename, request, response);
            } else if (requestURI.endsWith(".gif") || requestURI.endsWith(".jpg")) {
                jw.sendImage(this.jh, this.jf, filename, response);
            } else {
                LOGGER.error("Invalid filename extension.");
                response.sendError(404, filename + " not found.");
            }
        }
        catch (EOFException | SocketException ex) {
            LOGGER.debug(ex.getMessage());
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
            throw new ServletException("An error occurred: " + e.getMessage());
        }
    }

    protected long getLastModified(HttpServletRequest req) {
        try {
            return this.jf.getLastModified();
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            return -1L;
        }
    }
}

