/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import java.nio.charset.StandardCharsets;
import javax.servlet.http.Cookie;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class GetCookieValue
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(GetCookieValue.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-cookie-value", "http://exist-db.org/xquery/request", "request"), "Returns the value of a named Cookie.", new SequenceType[]{new FunctionParameterSequenceType("cookie-name", 22, 2, "The name of the cookie to retrieve the value from.")}, (SequenceType)new FunctionReturnSequenceType(22, 3, "the value of the named Cookie"));

    public GetCookieValue(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null || var.getValue().getItemType() != 100) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String cookieName = args[0].getStringValue();
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            Cookie[] cookies = ((RequestWrapper)value.getObject()).getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(cookieName)) continue;
                    return new StringValue(this.decode(cookie.getValue()));
                }
            }
            return Sequence.EMPTY_SEQUENCE;
        }
        throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to a Request object.");
    }

    private String decode(String value) {
        return new String(value.getBytes(StandardCharsets.ISO_8859_1));
    }
}

