/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetHeader
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(GetHeader.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-header", "http://exist-db.org/xquery/request", "request"), "Returns the HTTP request header identified by $header-name. The list of all headers included in the HTTP request are available through the request:get-header-names function.", new SequenceType[]{new FunctionParameterSequenceType("header-name", 22, 2, "The HTTP request header name")}, (SequenceType)new FunctionReturnSequenceType(22, 3, "the HTTP request header value"));

    public GetHeader(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null || var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to an Java object.");
        }
        String param = args[0].getStringValue();
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            String headerValue = ((RequestWrapper)value.getObject()).getHeader(param);
            if (headerValue == null) {
                return Sequence.EMPTY_SEQUENCE;
            }
            return XPathUtil.javaObjectToXPath((Object)headerValue, null, (boolean)false);
        }
        throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to a Request object.");
    }
}

