/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import java.util.Enumeration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class GetRequestAttribute
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(GetRequestAttribute.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-attribute", "http://exist-db.org/xquery/request", "request"), "Returns the string value of the request attribute specified in the argument or the empty sequence if no such attribute exists. The attribute value should be a string.", new SequenceType[]{new FunctionParameterSequenceType("attribute-name", 22, 2, "The name of the attribute")}, (SequenceType)new FunctionReturnSequenceType(11, 7, "the string value of the requested attribute")), new FunctionSignature(new QName("attribute-names", "http://exist-db.org/xquery/request", "request"), "Returns the names of all request attributes in the current request.", null, (SequenceType)new FunctionReturnSequenceType(22, 7, "the names of all attributes attached to the current request"))};

    public GetRequestAttribute(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No request object found in the current XQuery context.");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to an Java object.");
        }
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            if (this.isCalledAs("get-attribute")) {
                String name = args[0].getStringValue();
                Object attrib = ((RequestWrapper)value.getObject()).getAttribute(name);
                return attrib == null ? Sequence.EMPTY_SEQUENCE : XPathUtil.javaObjectToXPath((Object)attrib, (XQueryContext)this.context);
            }
            ValueSequence names = new ValueSequence();
            Enumeration<String> e = ((RequestWrapper)value.getObject()).getAttributeNames();
            while (e.hasMoreElements()) {
                names.add((Item)new StringValue(e.nextElement()));
            }
            return names;
        }
        throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to a Request object.");
    }
}

