/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import java.io.File;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromFile;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class GetUploadedFile
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(GetUploadedFile.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-uploaded-file-data", "http://exist-db.org/xquery/request", "request"), "Retrieve the base64 encoded data where the file part of a multi-part request has been stored. Returns the empty sequence if the request is not a multi-part request or the parameter name does not point to a file part.", new SequenceType[]{new FunctionParameterSequenceType("upload-param-name", 22, 2, "The parameter name")}, (SequenceType)new FunctionReturnSequenceType(26, 7, "the base64 encoded data from the uploaded file"))};

    public GetUploadedFile(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No request object found in the current XQuery context.");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to an Java object.");
        }
        String uploadParamName = args[0].getStringValue();
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            RequestWrapper request = (RequestWrapper)value.getObject();
            List<File> files = request.getFileUploadParam(uploadParamName);
            if (files == null) {
                logger.debug("File param not found: " + uploadParamName);
                return Sequence.EMPTY_SEQUENCE;
            }
            ValueSequence result = new ValueSequence();
            for (File file : files) {
                result.add((Item)BinaryValueFromFile.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (File)file));
            }
            return result;
        }
        throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to a Request object.");
    }
}

