/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class GetUploadedFileName
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(GetUploadedFileName.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-uploaded-file-name", "http://exist-db.org/xquery/request", "request"), "Retrieve the file name of an uploaded file from a multi-part request. This returns the file name of the file on the client (without path). Returns the empty sequence if the request is not a multi-part request or the parameter name does not point to a file part.", new SequenceType[]{new FunctionParameterSequenceType("upload-param-name", 22, 2, "The parameter name")}, (SequenceType)new FunctionReturnSequenceType(22, 7, "the file name of the uploaded files"));

    public GetUploadedFileName(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No request object found in the current XQuery context.");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to an Java object.");
        }
        String uploadParamName = args[0].getStringValue();
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            RequestWrapper request = (RequestWrapper)value.getObject();
            List<String> fnames = request.getUploadedFileName(uploadParamName);
            if (fnames == null) {
                return Sequence.EMPTY_SEQUENCE;
            }
            ValueSequence result = new ValueSequence();
            for (String name : fnames) {
                result.add((Item)new StringValue(name));
            }
            return result;
        }
        throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to a Request object.");
    }
}

