/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class SetAttribute
extends Function {
    protected static final Logger logger = LogManager.getLogger(SetAttribute.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("set-attribute", "http://exist-db.org/xquery/request", "request"), "Stores a value in the current request using the supplied attribute name.", new SequenceType[]{new FunctionParameterSequenceType("name", 22, 2, "The attribute name"), new FunctionParameterSequenceType("value", 11, 7, "The attribute value")}, new SequenceType(11, 1));

    public SetAttribute(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        RequestModule myModule;
        Variable var;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start((Expression)this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName((int)this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((var = (myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request")).resolveVariable(RequestModule.REQUEST_VAR)) == null || var.getValue() == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Request not set");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to a Java object.");
        }
        JavaObjectValue request = (JavaObjectValue)var.getValue().itemAt(0);
        String attribName = this.getArgument(0).eval(contextSequence, contextItem).getStringValue();
        Sequence attribValue = this.getArgument(1).eval(contextSequence, contextItem);
        if (!(request.getObject() instanceof RequestWrapper)) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Type error: variable $request is not bound to a request object");
        }
        ((RequestWrapper)request.getObject()).setAttribute(attribName, attribValue);
        return Sequence.EMPTY_SEQUENCE;
    }
}

