/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.response;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class RedirectTo
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(RedirectTo.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("redirect-to", "http://exist-db.org/xquery/response", "response"), "Sends a HTTP redirect response (302) to the client. Note: this is not supported by the Cocooon generator. Use a sitemap redirect instead.", new SequenceType[]{new FunctionParameterSequenceType("uri", 25, 2, "The URI to redirect the client to")}, new SequenceType(11, 1));

    public RedirectTo(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ResponseModule myModule = (ResponseModule)this.context.getModule("http://exist-db.org/xquery/response");
        String redirectURI = args[0].getStringValue();
        Variable var = myModule.resolveVariable(ResponseModule.RESPONSE_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No response object found in the current XQuery context.");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $response is not bound to an Java object.");
        }
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof ResponseWrapper) {
            try {
                ((ResponseWrapper)value.getObject()).sendRedirect(redirectURI);
            }
            catch (IOException e) {
                throw new XPathException((Expression)this, "An IO exception occurred during redirect: " + e.getMessage(), (Throwable)e);
            }
        } else {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable response is not bound to a response object.");
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

