/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.response;

import java.util.Date;
import javax.xml.datatype.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class SetCookie
extends Function {
    protected static final Logger logger = LogManager.getLogger(SetCookie.class);
    protected static final FunctionParameterSequenceType NAME_PARAM = new FunctionParameterSequenceType("name", 22, 2, "The cookie name");
    protected static final FunctionParameterSequenceType VALUE_PARAM = new FunctionParameterSequenceType("value", 22, 2, "The cookie value");
    protected static final FunctionParameterSequenceType MAX_AGE_PARAM = new FunctionParameterSequenceType("max-age", 53, 3, "The xs:duration of the cookie");
    protected static final FunctionParameterSequenceType SECURE_PARAM = new FunctionParameterSequenceType("secure-flag", 23, 3, "The flag for whether the cookie is to be secure (i.e., only transferred using HTTPS)");
    protected static final FunctionParameterSequenceType DOMAIN_PARAM = new FunctionParameterSequenceType("domain", 22, 3, "The cookie domain");
    protected static final FunctionParameterSequenceType PATH_PARAM = new FunctionParameterSequenceType("path", 22, 3, "The cookie path");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("set-cookie", "http://exist-db.org/xquery/response", "response"), "Sets a HTTP Cookie on the HTTP Response.", new SequenceType[]{NAME_PARAM, VALUE_PARAM}, new SequenceType(11, 1)), new FunctionSignature(new QName("set-cookie", "http://exist-db.org/xquery/response", "response"), "Sets a HTTP Cookie on the HTTP Response.", new SequenceType[]{NAME_PARAM, VALUE_PARAM, MAX_AGE_PARAM, SECURE_PARAM}, new SequenceType(11, 1)), new FunctionSignature(new QName("set-cookie", "http://exist-db.org/xquery/response", "response"), "Sets a HTTP Cookie on the HTTP Response.", new SequenceType[]{NAME_PARAM, VALUE_PARAM, MAX_AGE_PARAM, SECURE_PARAM, DOMAIN_PARAM, PATH_PARAM}, new SequenceType(11, 1))};

    public SetCookie(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        ResponseModule myModule;
        Variable var;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start((Expression)this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName((int)this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((var = (myModule = (ResponseModule)this.context.getModule("http://exist-db.org/xquery/response")).resolveVariable(ResponseModule.RESPONSE_VAR)) == null || var.getValue() == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Response not set");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $response is not bound to a Java object.");
        }
        JavaObjectValue response = (JavaObjectValue)var.getValue().itemAt(0);
        String name = this.getArgument(0).eval(contextSequence, contextItem).getStringValue();
        String value = this.getArgument(1).eval(contextSequence, contextItem).getStringValue();
        Sequence ageSeq = Sequence.EMPTY_SEQUENCE;
        Sequence secureSeq = Sequence.EMPTY_SEQUENCE;
        Sequence domainSeq = Sequence.EMPTY_SEQUENCE;
        Sequence pathSeq = Sequence.EMPTY_SEQUENCE;
        int maxAge = -1;
        if (this.getArgumentCount() > 2) {
            ageSeq = this.getArgument(2).eval(contextSequence, contextItem);
            secureSeq = this.getArgument(3).eval(contextSequence, contextItem);
            if (!ageSeq.isEmpty()) {
                Duration duration = ((DurationValue)ageSeq.itemAt(0)).getCanonicalDuration();
                maxAge = (int)(duration.getTimeInMillis(new Date(System.currentTimeMillis())) / 1000L);
            }
            if (this.getArgumentCount() > 4) {
                domainSeq = this.getArgument(4).eval(contextSequence, contextItem);
                pathSeq = this.getArgument(5).eval(contextSequence, contextItem);
            }
        }
        if (response.getObject() instanceof ResponseWrapper) {
            switch (this.getArgumentCount()) {
                case 2: {
                    ((ResponseWrapper)response.getObject()).addCookie(name, value);
                    break;
                }
                case 4: {
                    if (secureSeq.isEmpty()) {
                        ((ResponseWrapper)response.getObject()).addCookie(name, value, maxAge);
                        break;
                    }
                    ((ResponseWrapper)response.getObject()).addCookie(name, value, maxAge, ((BooleanValue)secureSeq.itemAt(0)).effectiveBooleanValue());
                    break;
                }
                case 6: {
                    boolean secure = false;
                    String domain = null;
                    String path = null;
                    if (!secureSeq.isEmpty()) {
                        secure = ((BooleanValue)secureSeq.itemAt(0)).effectiveBooleanValue();
                    }
                    if (!domainSeq.isEmpty()) {
                        domain = domainSeq.itemAt(0).getStringValue();
                    }
                    if (!pathSeq.isEmpty()) {
                        path = pathSeq.itemAt(0).getStringValue();
                    }
                    ((ResponseWrapper)response.getObject()).addCookie(name, value, maxAge, secure, domain, path);
                    break;
                }
            }
        } else {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Type error: variable $response is not bound to a response object");
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

