/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.session;

import org.exist.dom.QName;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class EncodeURL
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("encode-url", "http://exist-db.org/xquery/session", "session"), "Encodes the specified URL with the current HTTP session-id.", new SequenceType[]{new FunctionParameterSequenceType("url", 25, 2, "The URL to encode")}, (SequenceType)new FunctionReturnSequenceType(25, 2, "the encoded URL"));

    public EncodeURL(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ResponseModule myModule = (ResponseModule)this.context.getModule("http://exist-db.org/xquery/response");
        Variable var = myModule.resolveVariable(ResponseModule.RESPONSE_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No request object found in the current XQuery context.");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $response is not bound to an Java object.");
        }
        String url = args[0].getStringValue();
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof ResponseWrapper) {
            return new AnyURIValue(((ResponseWrapper)value.getObject()).encodeURL(url));
        }
        throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $response is not bound to a Response object.");
    }
}

