/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.session;

import java.util.Date;
import org.exist.dom.QName;
import org.exist.http.servlets.SessionWrapper;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.session.SessionModule;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetLastAccessedTime
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-last-accessed-time", "http://exist-db.org/xquery/session", "session"), "Returns the last time the client sent a request associated with this session. If a session does not exist, a new one is created. Actions that your application takes, such as getting or setting a value associated with the session, do not affect the access time.  If the session is already invalidated, it returns January 1, 1970 GMT", null, (SequenceType)new FunctionReturnSequenceType(50, 2, "the date-time when the session was last accessed"));

    public GetLastAccessedTime(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        SessionModule myModule;
        Variable var;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start((Expression)this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName((int)this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((var = (myModule = (SessionModule)this.context.getModule("http://exist-db.org/xquery/session")).resolveVariable(SessionModule.SESSION_VAR)) == null || var.getValue() == null) {
            return XPathUtil.javaObjectToXPath((Object)-1, (XQueryContext)this.context);
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $session is not bound to a Java object.");
        }
        JavaObjectValue session = (JavaObjectValue)var.getValue().itemAt(0);
        if (session.getObject() instanceof SessionWrapper) {
            try {
                long lastAccessedTime = ((SessionWrapper)session.getObject()).getLastAccessedTime();
                return new DateTimeValue(new Date(lastAccessedTime));
            }
            catch (IllegalStateException ise) {
                return new DateTimeValue(new Date(0L));
            }
        }
        throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Type error: variable $session is not bound to a session object");
    }
}

