/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.session;

import org.exist.dom.QName;
import org.exist.http.servlets.SessionWrapper;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.session.SessionModule;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetMaxInactiveInterval
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-max-inactive-interval", "http://exist-db.org/xquery/session", "session"), "Returns the maximum time interval, in seconds, that the servlet container will keep this session open between client accesses. After this interval, the servlet container will invalidate the session. The maximum time interval can be set with the session:set-max-inactive-interval function. A negative time indicates the session should never timeout. ", null, (SequenceType)new FunctionReturnSequenceType(38, 2, "the maximum time interval, in seconds"));

    public GetMaxInactiveInterval(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        SessionModule myModule = (SessionModule)this.context.getModule("http://exist-db.org/xquery/session");
        Variable var = myModule.resolveVariable(SessionModule.SESSION_VAR);
        if (var == null || var.getValue() == null) {
            return XPathUtil.javaObjectToXPath((Object)-1, (XQueryContext)this.context);
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $session is not bound to a Java object.");
        }
        JavaObjectValue session = (JavaObjectValue)var.getValue().itemAt(0);
        if (session.getObject() instanceof SessionWrapper) {
            try {
                int interval = ((SessionWrapper)session.getObject()).getMaxInactiveInterval();
                return XPathUtil.javaObjectToXPath((Object)interval, (XQueryContext)this.context);
            }
            catch (IllegalStateException ise) {
                return XPathUtil.javaObjectToXPath((Object)-1, (XQueryContext)this.context);
            }
        }
        throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Type error: variable $session is not bound to a session object");
    }
}

