/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.session;

import java.util.List;
import java.util.Map;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.http.servlets.SessionWrapper;
import org.exist.xquery.AbstractInternalModule;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.functions.session.Clear;
import org.exist.xquery.functions.session.Create;
import org.exist.xquery.functions.session.EncodeURL;
import org.exist.xquery.functions.session.GetAttribute;
import org.exist.xquery.functions.session.GetAttributeNames;
import org.exist.xquery.functions.session.GetCreationTime;
import org.exist.xquery.functions.session.GetExists;
import org.exist.xquery.functions.session.GetID;
import org.exist.xquery.functions.session.GetLastAccessedTime;
import org.exist.xquery.functions.session.GetMaxInactiveInterval;
import org.exist.xquery.functions.session.Invalidate;
import org.exist.xquery.functions.session.RemoveAttribute;
import org.exist.xquery.functions.session.SetAttribute;
import org.exist.xquery.functions.session.SetCurrentUser;
import org.exist.xquery.functions.session.SetMaxInactiveInterval;
import org.exist.xquery.value.JavaObjectValue;

public class SessionModule
extends AbstractInternalModule {
    public static final String NAMESPACE_URI = "http://exist-db.org/xquery/session";
    public static final String PREFIX = "session";
    public static final String INCLUSION_DATE = "2006-04-09";
    public static final String RELEASED_IN_VERSION = "eXist-1.0";
    public static final QName SESSION_VAR = new QName("session", "http://exist-db.org/xquery/session", "session");
    public static final FunctionDef[] functions = new FunctionDef[]{new FunctionDef(Create.signature, Create.class), new FunctionDef(Clear.signature, Clear.class), new FunctionDef(EncodeURL.signature, EncodeURL.class), new FunctionDef(GetID.signature, GetID.class), new FunctionDef(GetAttribute.signature, GetAttribute.class), new FunctionDef(RemoveAttribute.signature, RemoveAttribute.class), new FunctionDef(GetAttributeNames.signature, GetAttributeNames.class), new FunctionDef(GetCreationTime.signature, GetCreationTime.class), new FunctionDef(GetLastAccessedTime.signature, GetLastAccessedTime.class), new FunctionDef(GetMaxInactiveInterval.signature, GetMaxInactiveInterval.class), new FunctionDef(SetMaxInactiveInterval.signature, SetMaxInactiveInterval.class), new FunctionDef(Invalidate.signature, Invalidate.class), new FunctionDef(SetAttribute.signature, SetAttribute.class), new FunctionDef(SetCurrentUser.signature, SetCurrentUser.class), new FunctionDef(GetExists.signature, GetExists.class)};

    public SessionModule(Map<String, List<? extends Object>> parameters) throws XPathException {
        super(functions, parameters);
    }

    public String getDescription() {
        return "A module for dealing with the HTTP session.";
    }

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public String getDefaultPrefix() {
        return PREFIX;
    }

    public String getReleaseVersion() {
        return RELEASED_IN_VERSION;
    }

    static JavaObjectValue createSession(XQueryContext context, Function fn) throws XPathException {
        JavaObjectValue ret = null;
        RequestModule myModule = (RequestModule)context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException((Expression)fn, ErrorCodes.XPDY0002, "No request object found in the current XQuery context.");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)fn, ErrorCodes.XPDY0002, "Variable $request is not bound to an Java object.");
        }
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (!(value.getObject() instanceof RequestWrapper)) {
            throw new XPathException((Expression)fn, ErrorCodes.XPDY0002, "Variable $request is not bound to a Request object.");
        }
        SessionModule sessionModule = (SessionModule)context.getModule(NAMESPACE_URI);
        SessionWrapper session = ((RequestWrapper)value.getObject()).getSession(true);
        sessionModule.declareVariable(SESSION_VAR, session);
        ret = (JavaObjectValue)sessionModule.resolveVariable(SESSION_VAR).getValue().itemAt(0);
        return ret;
    }

    public void reset(XQueryContext xqueryContext, boolean keepGlobals) {
        super.reset(xqueryContext, keepGlobals);
    }
}

