/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.session;

import org.exist.dom.QName;
import org.exist.http.servlets.SessionWrapper;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.session.SessionModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class SetMaxInactiveInterval
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("set-max-inactive-interval", "http://exist-db.org/xquery/session", "session"), "Sets the maximum time interval, in seconds, that the servlet container will keep this session open between client accesses. After this interval, the servlet container will invalidate the session. A negative time indicates the session should never timeout. ", new SequenceType[]{new FunctionParameterSequenceType("interval", 38, 2, "The maximum inactive interval (in seconds) before closing the session")}, new SequenceType(11, 1));

    public SetMaxInactiveInterval(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        JavaObjectValue session;
        SessionModule myModule;
        Variable var;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start((Expression)this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName((int)this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((var = (myModule = (SessionModule)this.context.getModule("http://exist-db.org/xquery/session")).resolveVariable(SessionModule.SESSION_VAR)) == null || var.getValue() == null) {
            session = SessionModule.createSession(this.context, this);
        } else {
            if (var.getValue().getItemType() != 100) {
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $session is not bound to a Java object.");
            }
            session = (JavaObjectValue)var.getValue().itemAt(0);
        }
        int interval = ((IntegerValue)this.getArgument(0).eval(contextSequence, contextItem).convertTo(38)).getInt();
        if (!(session.getObject() instanceof SessionWrapper)) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Type error: variable $session is not bound to a session object");
        }
        ((SessionWrapper)session.getObject()).setMaxInactiveInterval(interval);
        return Sequence.EMPTY_SEQUENCE;
    }
}

